# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`dns`](#dns): Manage an ISC BIND nameserver

#### Private Classes

* `dns::config`: Configure dns
* `dns::install`: Install dns service
* `dns::logging`: Enable logging for named
* `dns::params`: Default parameters
* `dns::service`: Enable and start dns service

### Defined types

* [`dns::dnssec_policy`](#dns--dnssec_policy): Manage custom DNSSEC policies
* [`dns::key`](#dns--key): Generate a new key for the dns
* [`dns::logging::category`](#dns--logging--category): Define new category for logging
* [`dns::logging::channel`](#dns--logging--channel): Define new channel for logging
* [`dns::view`](#dns--view): Define new view for the dns
* [`dns::zone`](#dns--zone): Define new zone for the dns

### Functions

* [`dns::dnssec_keygen`](#dns--dnssec_keygen): Generate a DNSSEC key
* [`dns::reverse_dns`](#dns--reverse_dns): Get the reverse DNS for an IP address
* [`dns::tsig_keygen`](#dns--tsig_keygen): Generate a TSIG key
* [`get_in_addr_arpa`](#get_in_addr_arpa): DEPRECATED.  Use the [`dns::reverse_dns`](#dnsreverse_dns) function instead.

### Data types

* [`Dns::Dnssec_policy_key`](#Dns--Dnssec_policy_key): Validate dnssec-policy parameter
* [`Dns::Forwarder`](#Dns--Forwarder): a DNS forwarder entry
* [`Dns::UpdatePolicy`](#Dns--UpdatePolicy): Validate update-policy parameter

## Classes

### <a name="dns"></a>`dns`

Manage an ISC BIND nameserver

* **See also**
  * dns::zone
  * dns::key
  * dns::logging::category
  * dns::logging::channel

#### Parameters

The following parameters are available in the `dns` class:

* [`namedconf_path`](#-dns--namedconf_path)
* [`dnsdir`](#-dns--dnsdir)
* [`dns_server_package`](#-dns--dns_server_package)
* [`rndckeypath`](#-dns--rndckeypath)
* [`optionspath`](#-dns--optionspath)
* [`publicviewpath`](#-dns--publicviewpath)
* [`vardir`](#-dns--vardir)
* [`logdir`](#-dns--logdir)
* [`group_manage`](#-dns--group_manage)
* [`manage_service`](#-dns--manage_service)
* [`namedservicename`](#-dns--namedservicename)
* [`zonefilepath`](#-dns--zonefilepath)
* [`localzonepath`](#-dns--localzonepath)
* [`defaultzonepath`](#-dns--defaultzonepath)
* [`forward`](#-dns--forward)
* [`forwarders`](#-dns--forwarders)
* [`listen_on_v6`](#-dns--listen_on_v6)
* [`recursion`](#-dns--recursion)
* [`allow_recursion`](#-dns--allow_recursion)
* [`allow_query`](#-dns--allow_query)
* [`empty_zones_enable`](#-dns--empty_zones_enable)
* [`dns_notify`](#-dns--dns_notify)
* [`dnssec_enable`](#-dns--dnssec_enable)
* [`dnssec_validation`](#-dns--dnssec_validation)
* [`namedconf_template`](#-dns--namedconf_template)
* [`acls`](#-dns--acls)
* [`optionsconf_template`](#-dns--optionsconf_template)
* [`sysconfig_file`](#-dns--sysconfig_file)
* [`sysconfig_template`](#-dns--sysconfig_template)
* [`sysconfig_startup_options`](#-dns--sysconfig_startup_options)
* [`sysconfig_resolvconf_integration`](#-dns--sysconfig_resolvconf_integration)
* [`sysconfig_disable_zone_checking`](#-dns--sysconfig_disable_zone_checking)
* [`sysconfig_additional_settings`](#-dns--sysconfig_additional_settings)
* [`controls`](#-dns--controls)
* [`statistics_channels`](#-dns--statistics_channels)
* [`service_ensure`](#-dns--service_ensure)
* [`service_enable`](#-dns--service_enable)
* [`service_restart_command`](#-dns--service_restart_command)
* [`config_check`](#-dns--config_check)
* [`additional_options`](#-dns--additional_options)
* [`additional_directives`](#-dns--additional_directives)
* [`enable_views`](#-dns--enable_views)
* [`zones`](#-dns--zones)
* [`keys`](#-dns--keys)
* [`logging_categories`](#-dns--logging_categories)
* [`logging_channels`](#-dns--logging_channels)
* [`disable_empty_zones`](#-dns--disable_empty_zones)

##### <a name="-dns--namedconf_path"></a>`namedconf_path`

Data type: `Stdlib::Absolutepath`

Path of the named config

Default value: `$dns::params::namedconf_path`

##### <a name="-dns--dnsdir"></a>`dnsdir`

Data type: `Stdlib::Absolutepath`

Directory holding the named configs

Default value: `$dns::params::dnsdir`

##### <a name="-dns--dns_server_package"></a>`dns_server_package`

Data type: `String`

Name of the package to install

Default value: `$dns::params::dns_server_package`

##### <a name="-dns--rndckeypath"></a>`rndckeypath`

Data type: `Stdlib::Absolutepath`

Path of the RNDC key

Default value: `$dns::params::rndckeypath`

##### <a name="-dns--optionspath"></a>`optionspath`

Data type: `Stdlib::Absolutepath`

Path of the named options

Default value: `$dns::params::optionspath`

##### <a name="-dns--publicviewpath"></a>`publicviewpath`

Data type: `Stdlib::Absolutepath`

Path of the config file holding all the zones

Default value: `$dns::params::publicviewpath`

##### <a name="-dns--vardir"></a>`vardir`

Data type: `Stdlib::Absolutepath`

Directory holding the variable or working files

Default value: `$dns::params::vardir`

##### <a name="-dns--logdir"></a>`logdir`

Data type: `Stdlib::Absolutepath`

Directory holding the log files for named

Default value: `'/var/log/named'`

##### <a name="-dns--group_manage"></a>`group_manage`

Data type: `Boolean`

Should this module manage the Unix system group under which BIND runs (see
dns::params)?  Defaults to true. Set to false if you want to manage the
system group yourself.

Default value: `true`

##### <a name="-dns--manage_service"></a>`manage_service`

Data type: `Boolean`

Should this module manage the dns service?
This only applies to the service management (running, stopped) and not to
whether the service should be installed or not.
IMPORTANT: this will not reload the service after a config change, you'll
have to do that manually or via a separate call to notify

Default value: `true`

##### <a name="-dns--namedservicename"></a>`namedservicename`

Data type: `String`

Name of the service

Default value: `$dns::params::namedservicename`

##### <a name="-dns--zonefilepath"></a>`zonefilepath`

Data type: `Stdlib::Absolutepath`

Directory containing zone files

Default value: `$dns::params::zonefilepath`

##### <a name="-dns--localzonepath"></a>`localzonepath`

Data type: `Variant[Enum['unmanaged'], Stdlib::Absolutepath]`

File holding local zones like RFC1912 or RFC1918 files.  The special value
'unmanaged' can be used if one plans to create custom RFC1912/RFC1918 zones
via dns, where the inclusion of package-shipped zone files is not desired.

Default value: `$dns::params::localzonepath`

##### <a name="-dns--defaultzonepath"></a>`defaultzonepath`

Data type: `Variant[Enum['unmanaged'], Stdlib::Absolutepath]`

File holding some RFC1912 zone includes on systems like Debian.
The special value 'unmanaged' can be used if one plans to create custom
zones via dns, where the inclusion of package-shipped zone files is not
desired.

Default value: `$dns::params::defaultzonepath`

##### <a name="-dns--forward"></a>`forward`

Data type: `Optional[Enum['only', 'first']]`

The forward option

Default value: `undef`

##### <a name="-dns--forwarders"></a>`forwarders`

Data type: `Array[Dns::Forwarder]`

The forwarders option

Default value: `[]`

##### <a name="-dns--listen_on_v6"></a>`listen_on_v6`

Data type: `Variant[String, Boolean]`

The listen-on-v6 option

Default value: `'any'`

##### <a name="-dns--recursion"></a>`recursion`

Data type: `Enum['yes', 'no']`

The recursion option

Default value: `'yes'`

##### <a name="-dns--allow_recursion"></a>`allow_recursion`

Data type: `Array[String]`

The allow-recursion option

Default value: `['localnets', 'localhost']`

##### <a name="-dns--allow_query"></a>`allow_query`

Data type: `Array[String]`

The allow-query option

Default value: `['any']`

##### <a name="-dns--empty_zones_enable"></a>`empty_zones_enable`

Data type: `Enum['yes', 'no']`

The empty-zones-enable option

Default value: `'yes'`

##### <a name="-dns--dns_notify"></a>`dns_notify`

Data type: `Optional[Enum['yes', 'no', 'explicit']]`

The notify option in named.conf

Default value: `undef`

##### <a name="-dns--dnssec_enable"></a>`dnssec_enable`

Data type: `Optional[Enum['yes', 'no']]`

The dnssec-enable option. This option is deprecated and has no effect since
BIND 9.15. It's been removed in BIND 9.18.

Default value: `$dns::params::dnssec_enable`

##### <a name="-dns--dnssec_validation"></a>`dnssec_validation`

Data type: `Enum['yes', 'no', 'auto']`

The dnssec-validation option

Default value: `'yes'`

##### <a name="-dns--namedconf_template"></a>`namedconf_template`

Data type: `String`

The template to be used for named.conf

Default value: `'dns/named.conf.erb'`

##### <a name="-dns--acls"></a>`acls`

Data type: `Hash[String, Array[String]]`

Specify a hash of ACLs. Each key is the name of a network, and its value is
an array of subnet strings.

Default value: `{}`

##### <a name="-dns--optionsconf_template"></a>`optionsconf_template`

Data type: `String`

The template to be used for options.conf

Default value: `'dns/options.conf.erb'`

##### <a name="-dns--sysconfig_file"></a>`sysconfig_file`

Data type: `Optional[Stdlib::Absolutepath]`

Path to the sysconfig or default file used to set startup options for
named. Under Debian this is /etc/default/bind9, under RedHat this is
/etc/sysconfig/named. FreeBSD/DragonFly and ArchLinux do not feature such
files, thus the sysconfig parameters are not relevant for these operating
systems.

Default value: `$dns::params::sysconfig_file`

##### <a name="-dns--sysconfig_template"></a>`sysconfig_template`

Data type: `Optional[String]`

The template used to model /etc/default/bind9 or /etc/sysconfig/named.
Default is "dns/sysconfig.${facts[osfamily]}.erb" for Debian and RedHat,
and undef for others.

Default value: `$dns::params::sysconfig_template`

##### <a name="-dns--sysconfig_startup_options"></a>`sysconfig_startup_options`

Data type: `Optional[String]`

Startup options for the `named` process, rendered as the `OPTIONS` string
in the sysconfig file (see above). Use this to set commandline flags and
options for `named`. For example, to use IPv4 only and disable IPv6 support
in named on Debian set this parameter to `-u bind -4`. The default value
depends on the underlying OS.

Default value: `$dns::params::sysconfig_startup_options`

##### <a name="-dns--sysconfig_resolvconf_integration"></a>`sysconfig_resolvconf_integration`

Data type: `Optional[Boolean]`

Should named integrate with resolvconf upon startup? Default is false, and
this only pertains to the Debian OS family.

Default value: `$dns::params::sysconfig_resolvconf_integration`

##### <a name="-dns--sysconfig_disable_zone_checking"></a>`sysconfig_disable_zone_checking`

Data type: `Optional[Boolean]`

Should zone checking be disabled upon named startup? Default is undef, and
this only pertains to the RedHat OS family.

Default value: `$dns::params::sysconfig_disable_zone_checking`

##### <a name="-dns--sysconfig_additional_settings"></a>`sysconfig_additional_settings`

Data type: `Hash[String[1], String]`

Additional settings to add to the sysconfig file. This is a simple hash of
key-value strings that will be rendered as `KEY="value"` in the sysconfig
file. Use this to add custom (environment) variables relevant for named.
Default is empty.

Default value: `{}`

##### <a name="-dns--controls"></a>`controls`

Data type: `Hash[String, Hash[String, Data]]`

Specify a hash of controls. Each key is the name of a network, and its
value is a hash containing 'port' => integer, 'keys' => array and
'allowed_addresses' => array

Default value: `$dns::params::controls`

##### <a name="-dns--statistics_channels"></a>`statistics_channels`

Data type: `Hash[String, Hash[String, Data]]`

Specify a hash of statistics-channels. Each key is the name of a network,
and its value is a hash containing 'port' => integer and
'allowed_addresses' => array

Default value: `{}`

##### <a name="-dns--service_ensure"></a>`service_ensure`

Data type: `Variant[Enum['running', 'stopped'], Boolean]`

The ensure attribute on the service

Default value: `'running'`

##### <a name="-dns--service_enable"></a>`service_enable`

Data type: `Boolean`

Whether to enable the service (start at boot)

Default value: `true`

##### <a name="-dns--service_restart_command"></a>`service_restart_command`

Data type: `Optional[String[1]]`

Custom command to use when the service will be restarted (notified by
configuration changes). Will be passed directly to the restart parameter of
the contained service resource. This is useful when you want BIND to reload
its configuration instead of restarting the whole process, for example by
setting `service_restart_command` to `/usr/sbin/service bind9 reload` or
`/usr/sbin/rndc reload` or even `/usr/bin/systemctl try-reload-or-restart bind9`.
Default is 'undef' so the service resource default is used.

Default value: `undef`

##### <a name="-dns--config_check"></a>`config_check`

Data type: `Boolean`

Should this module run configuration checks before putting new configurations in
place?  Defaults to true. Set to false if you don't want configuration checks when
config files are changed.

Default value: `true`

##### <a name="-dns--additional_options"></a>`additional_options`

Data type: `Hash[String, Data]`

Additional options

Default value: `{}`

##### <a name="-dns--additional_directives"></a>`additional_directives`

Data type: `Array[String]`

Additional directives. These are free form strings that allow for full
customization. Use with caution.

Default value: `[]`

##### <a name="-dns--enable_views"></a>`enable_views`

Data type: `Boolean`

Flag to indicate bind views support. Will remove global zone configuration
like localzonepath inclusion.

Default value: `false`

##### <a name="-dns--zones"></a>`zones`

Data type: `Hash[String, Hash]`

A hash of zones to be created. See dns::zone for options.

Default value: `{}`

##### <a name="-dns--keys"></a>`keys`

Data type: `Hash[String, Hash]`

A hash of keys to be created. See dns::key for options.

Default value: `{}`

##### <a name="-dns--logging_categories"></a>`logging_categories`

Data type: `Hash[String, Hash]`

A hash of logging categories to be created. See dns::logging::category for options.

Default value: `{}`

##### <a name="-dns--logging_channels"></a>`logging_channels`

Data type: `Hash[String, Hash]`

A hash of logging channels to be created. See dns::logging::channel for options.

Default value: `{}`

##### <a name="-dns--disable_empty_zones"></a>`disable_empty_zones`

Data type: `Array[Stdlib::Fqdn]`

A list of empty zones that shouldn't be created by bind
See: https://kb.isc.org/docs/aa-00800

Default value: `[]`

## Defined types

### <a name="dns--dnssec_policy"></a>`dns::dnssec_policy`

Manage custom DNSSEC policies

#### Parameters

The following parameters are available in the `dns::dnssec_policy` defined type:

* [`dnskey_ttl`](#-dns--dnssec_policy--dnskey_ttl)
* [`keys`](#-dns--dnssec_policy--keys)
* [`max_zone_ttl`](#-dns--dnssec_policy--max_zone_ttl)
* [`parent_ds_ttl`](#-dns--dnssec_policy--parent_ds_ttl)
* [`parent_propagation_delay`](#-dns--dnssec_policy--parent_propagation_delay)
* [`publish_safety`](#-dns--dnssec_policy--publish_safety)
* [`retire_safety`](#-dns--dnssec_policy--retire_safety)
* [`signatures_refresh`](#-dns--dnssec_policy--signatures_refresh)
* [`signatures_validity`](#-dns--dnssec_policy--signatures_validity)
* [`signatures_validity_dnskey`](#-dns--dnssec_policy--signatures_validity_dnskey)
* [`zone_propagation_delay`](#-dns--dnssec_policy--zone_propagation_delay)

##### <a name="-dns--dnssec_policy--dnskey_ttl"></a>`dnskey_ttl`

Data type: `Optional[Integer]`

This indicates the TTL to use when generating DNSKEY resource records.

Default value: `undef`

##### <a name="-dns--dnssec_policy--keys"></a>`keys`

Data type: `Array[Dns::Dnssec_policy_key]`

This is a list specifying the algorithms and roles to use when generating
keys and signing the zone. Entries in this list do not represent specific
DNSSEC keys, which may be changed on a regular basis, but the roles that
keys play in the signing policy.

Default value: `[]`

##### <a name="-dns--dnssec_policy--max_zone_ttl"></a>`max_zone_ttl`

Data type: `Optional[Integer]`

This specifies the maximum permissible TTL value in seconds for the zone.

Default value: `undef`

##### <a name="-dns--dnssec_policy--parent_ds_ttl"></a>`parent_ds_ttl`

Data type: `Optional[Integer]`

This is the TTL of the DS RRset that the parent zone uses.

Default value: `undef`

##### <a name="-dns--dnssec_policy--parent_propagation_delay"></a>`parent_propagation_delay`

Data type: `Optional[String[1]]`

This is the expected propagation delay from the time when the parent zone is
updated to the time when the new version is served by all of the parent
zone’s name servers.

Default value: `undef`

##### <a name="-dns--dnssec_policy--publish_safety"></a>`publish_safety`

Data type: `Optional[String[1]]`

This is a margin that is added to the pre-publication interval in rollover
timing calculations, to give some extra time to cover unforeseen events.
This increases the time between when keys are published and they become
active.

Default value: `undef`

##### <a name="-dns--dnssec_policy--retire_safety"></a>`retire_safety`

Data type: `Optional[String[1]]`

This is a margin that is added to the post-publication interval in rollover
timing calculations, to give some extra time to cover unforeseen events.
This increases the time a key remains published after it is no longer
active.

Default value: `undef`

##### <a name="-dns--dnssec_policy--signatures_refresh"></a>`signatures_refresh`

Data type: `Optional[String[1]]`

This determines how frequently an RRSIG record needs to be refreshed. The
signature is renewed when the time until the expiration time is closer than
the specified interval.

Default value: `undef`

##### <a name="-dns--dnssec_policy--signatures_validity"></a>`signatures_validity`

Data type: `Optional[String[1]]`

This indicates the validity period of an RRSIG record (subject to inception
offset and jitter).

Default value: `undef`

##### <a name="-dns--dnssec_policy--signatures_validity_dnskey"></a>`signatures_validity_dnskey`

Data type: `Optional[String[1]]`

This is similar to signatures-validity, but for DNSKEY records.

Default value: `undef`

##### <a name="-dns--dnssec_policy--zone_propagation_delay"></a>`zone_propagation_delay`

Data type: `Optional[String[1]]`

This is the expected propagation delay from the time when a zone is first
updated to the time when the new version of the zone is served by all
secondary servers.

Default value: `undef`

### <a name="dns--key"></a>`dns::key`

Generate a new key for the dns

#### Parameters

The following parameters are available in the `dns::key` defined type:

* [`algorithm`](#-dns--key--algorithm)
* [`filename`](#-dns--key--filename)
* [`secret`](#-dns--key--secret)
* [`keydir`](#-dns--key--keydir)
* [`keysize`](#-dns--key--keysize)

##### <a name="-dns--key--algorithm"></a>`algorithm`

Data type: `String`

The algorithm used to generate the secret key

Default value: `'hmac-md5'`

##### <a name="-dns--key--filename"></a>`filename`

Data type: `String`

The filename to store the key. This is placed in the key directory.

Default value: `"${name}.key"`

##### <a name="-dns--key--secret"></a>`secret`

Data type: `Optional[String]`

This is the secret to be place inside the keyfile, if left empty the key
will be generated

Default value: `undef`

##### <a name="-dns--key--keydir"></a>`keydir`

Data type: `Stdlib::Absolutepath`

The directory to store the key in. Inherited from the main dns class by default.

Default value: `$dns::dnsdir`

##### <a name="-dns--key--keysize"></a>`keysize`

Data type: `Integer`

The size of the key to generate. Only used when generating the key. It's
ignored if when a key is specified.

Default value: `512`

### <a name="dns--logging--category"></a>`dns::logging::category`

Define new category for logging

#### Parameters

The following parameters are available in the `dns::logging::category` defined type:

* [`channels`](#-dns--logging--category--channels)
* [`order`](#-dns--logging--category--order)

##### <a name="-dns--logging--category--channels"></a>`channels`

Data type: `Array`

The array of channels to attach to the category

##### <a name="-dns--logging--category--order"></a>`order`

Data type: `Integer[51, 59]`

The order of the category in the configuration file

Default value: `55`

### <a name="dns--logging--channel"></a>`dns::logging::channel`

Define new channel for logging

#### Parameters

The following parameters are available in the `dns::logging::channel` defined type:

* [`file_path`](#-dns--logging--channel--file_path)
* [`file_size`](#-dns--logging--channel--file_size)
* [`file_versions`](#-dns--logging--channel--file_versions)
* [`log_type`](#-dns--logging--channel--log_type)
* [`order`](#-dns--logging--channel--order)
* [`print_category`](#-dns--logging--channel--print_category)
* [`print_severity`](#-dns--logging--channel--print_severity)
* [`print_time`](#-dns--logging--channel--print_time)
* [`severity`](#-dns--logging--channel--severity)
* [`syslog_facility`](#-dns--logging--channel--syslog_facility)

##### <a name="-dns--logging--channel--file_path"></a>`file_path`

Data type: `Optional[Stdlib::Absolutepath]`

The path to the log file

Default value: `undef`

##### <a name="-dns--logging--channel--file_size"></a>`file_size`

Data type: `Optional[String]`

The maximum size the log file is allowed to reach

Default value: `undef`

##### <a name="-dns--logging--channel--file_versions"></a>`file_versions`

Data type: `Optional[Integer]`

The number of log files to keep when rotating

Default value: `undef`

##### <a name="-dns--logging--channel--log_type"></a>`log_type`

Data type: `Enum['file', 'null', 'stderr', 'syslog']`

The destination type for the log (file, stderr, syslog, or "null")

Default value: `undef`

##### <a name="-dns--logging--channel--order"></a>`order`

Data type: `Integer[51, 59]`

The order of the channel in the configuration file

Default value: `51`

##### <a name="-dns--logging--channel--print_category"></a>`print_category`

Data type: `Optional[Enum['no', 'yes']]`

Decide whether to log the category in the log message

Default value: `undef`

##### <a name="-dns--logging--channel--print_severity"></a>`print_severity`

Data type: `Optional[Enum['no', 'yes']]`

Decide whether to log the severity in the log message

Default value: `undef`

##### <a name="-dns--logging--channel--print_time"></a>`print_time`

Data type: `Optional[Enum['no', 'yes']]`

Decide whether to log the time in the log message

Default value: `undef`

##### <a name="-dns--logging--channel--severity"></a>`severity`

Data type: `Optional[String]`

The severity of messages to log

Default value: `undef`

##### <a name="-dns--logging--channel--syslog_facility"></a>`syslog_facility`

Data type: `Optional[String]`

The syslog facility to use when logging to a syslog log_type

Default value: `undef`

### <a name="dns--view"></a>`dns::view`

Define new view for the dns

* **See also**
  * https://kb.isc.org/docs/aa-00851

#### Parameters

The following parameters are available in the `dns::view` defined type:

* [`match_clients`](#-dns--view--match_clients)
* [`match_destinations`](#-dns--view--match_destinations)
* [`match_recursive_only`](#-dns--view--match_recursive_only)
* [`allow_transfer`](#-dns--view--allow_transfer)
* [`allow_recursion`](#-dns--view--allow_recursion)
* [`allow_query`](#-dns--view--allow_query)
* [`allow_query_cache`](#-dns--view--allow_query_cache)
* [`also_notify`](#-dns--view--also_notify)
* [`forwarders`](#-dns--view--forwarders)
* [`forward`](#-dns--view--forward)
* [`recursion`](#-dns--view--recursion)
* [`dnssec_enable`](#-dns--view--dnssec_enable)
* [`dnssec_validation`](#-dns--view--dnssec_validation)
* [`dns_notify`](#-dns--view--dns_notify)
* [`include_localzones`](#-dns--view--include_localzones)
* [`include_defaultzones`](#-dns--view--include_defaultzones)
* [`order`](#-dns--view--order)

##### <a name="-dns--view--match_clients"></a>`match_clients`

Data type: `Array[String]`

The value for match-clients in the view definition

Default value: `[]`

##### <a name="-dns--view--match_destinations"></a>`match_destinations`

Data type: `Array[String]`

The value for match-destinations in the view definition

Default value: `[]`

##### <a name="-dns--view--match_recursive_only"></a>`match_recursive_only`

Data type: `Optional[Enum['yes','no']]`

The value for match-recursive-only in the view definition

Default value: `undef`

##### <a name="-dns--view--allow_transfer"></a>`allow_transfer`

Data type: `Array[String]`

The value for allow-transfer in the view definition

Default value: `[]`

##### <a name="-dns--view--allow_recursion"></a>`allow_recursion`

Data type: `Array[String]`

The value for allow-recursion in the view definition

Default value: `[]`

##### <a name="-dns--view--allow_query"></a>`allow_query`

Data type: `Array[String]`

The value for allow-query in the view definition

Default value: `[]`

##### <a name="-dns--view--allow_query_cache"></a>`allow_query_cache`

Data type: `Array[String]`

The value for allow-query-cache in the view definition

Default value: `[]`

##### <a name="-dns--view--also_notify"></a>`also_notify`

Data type: `Array[String]`

The value for also-notify in the view definition

Default value: `[]`

##### <a name="-dns--view--forwarders"></a>`forwarders`

Data type: `Array[Dns::Forwarder]`

The value for forwarders in the view definition

Default value: `[]`

##### <a name="-dns--view--forward"></a>`forward`

Data type: `Optional[Enum['only','first']]`

The value for forward in the view definition. Only used if forwarders is
not empty.

Default value: `undef`

##### <a name="-dns--view--recursion"></a>`recursion`

Data type: `Optional[Enum['yes','no']]`

The value for recursion in the view definition

Default value: `undef`

##### <a name="-dns--view--dnssec_enable"></a>`dnssec_enable`

Data type: `Optional[Enum['yes','no']]`

The value for dnssec-enable in the view definition

Default value: `undef`

##### <a name="-dns--view--dnssec_validation"></a>`dnssec_validation`

Data type: `Optional[Enum['yes','no']]`

The value for dnssec-validation in the view definition

Default value: `undef`

##### <a name="-dns--view--dns_notify"></a>`dns_notify`

Data type: `Optional[Enum['yes','no','explicit']]`

The value for notify in the view definition

Default value: `undef`

##### <a name="-dns--view--include_localzones"></a>`include_localzones`

Data type: `Boolean`

Whether to include the local zones or not. Requires dns::localzonepath not
to be unmanaged to be effective.

Default value: `true`

##### <a name="-dns--view--include_defaultzones"></a>`include_defaultzones`

Data type: `Boolean`

Whether to include the default zones or not. Requires dns::defaultzonepath
not to be unmanaged to be effective.

Default value: `true`

##### <a name="-dns--view--order"></a>`order`

Data type: `String`

The order parameter to the concat fragment.

Default value: `'-'`

### <a name="dns--zone"></a>`dns::zone`

Define new zone for the dns

#### Parameters

The following parameters are available in the `dns::zone` defined type:

* [`soaip`](#-dns--zone--soaip)
* [`soaipv6`](#-dns--zone--soaipv6)
* [`manage_file`](#-dns--zone--manage_file)
* [`manage_file_name`](#-dns--zone--manage_file_name)
* [`replace_file`](#-dns--zone--replace_file)
* [`update_policy`](#-dns--zone--update_policy)
* [`target_views`](#-dns--zone--target_views)
* [`zonetype`](#-dns--zone--zonetype)
* [`soa`](#-dns--zone--soa)
* [`reverse`](#-dns--zone--reverse)
* [`ttl`](#-dns--zone--ttl)
* [`refresh`](#-dns--zone--refresh)
* [`update_retry`](#-dns--zone--update_retry)
* [`expire`](#-dns--zone--expire)
* [`negttl`](#-dns--zone--negttl)
* [`serial`](#-dns--zone--serial)
* [`records`](#-dns--zone--records)
* [`masters`](#-dns--zone--masters)
* [`allow_transfer`](#-dns--zone--allow_transfer)
* [`allow_query`](#-dns--zone--allow_query)
* [`allow_update`](#-dns--zone--allow_update)
* [`also_notify`](#-dns--zone--also_notify)
* [`zone`](#-dns--zone--zone)
* [`contact`](#-dns--zone--contact)
* [`zonefilepath`](#-dns--zone--zonefilepath)
* [`filename`](#-dns--zone--filename)
* [`forward`](#-dns--zone--forward)
* [`master_empty_forwarders_enable`](#-dns--zone--master_empty_forwarders_enable)
* [`forwarders`](#-dns--zone--forwarders)
* [`dns_notify`](#-dns--zone--dns_notify)
* [`zone_statistics`](#-dns--zone--zone_statistics)
* [`key_directory`](#-dns--zone--key_directory)
* [`inline_signing`](#-dns--zone--inline_signing)
* [`dnssec_secure_to_insecure`](#-dns--zone--dnssec_secure_to_insecure)
* [`auto_dnssec`](#-dns--zone--auto_dnssec)
* [`dnssec_policy`](#-dns--zone--dnssec_policy)
* [`masterfile_format`](#-dns--zone--masterfile_format)

##### <a name="-dns--zone--soaip"></a>`soaip`

Data type: `Optional[Stdlib::IP::Address::V4]`

The IP address for the SOA. If `reverse` is false, an A record will be
created pointing to this IP address for `$soa`. This only makes sense if
`$soa` is withing this zone and needs glue records.

Default value: `undef`

##### <a name="-dns--zone--soaipv6"></a>`soaipv6`

Data type: `Optional[Stdlib::IP::Address::V6]`

The IPv6 address for the SOA. If `reverse` is false, an AAAA record will be
created pointing to this IP address for `$soa`. This only makes sense if
`$soa` is withing this zone and needs glue records.

Default value: `undef`

##### <a name="-dns--zone--manage_file"></a>`manage_file`

Data type: `Boolean`

Whether the manage the file resource. When true $manage_file_name is implied.

Default value: `true`

##### <a name="-dns--zone--manage_file_name"></a>`manage_file_name`

Data type: `Boolean`

Whether to set the file parameter in the zone file.

Default value: `false`

##### <a name="-dns--zone--replace_file"></a>`replace_file`

Data type: `Boolean`

Whether to update the zone file when a change is detected.

Default value: `false`

##### <a name="-dns--zone--update_policy"></a>`update_policy`

Data type: `Optional[Dns::UpdatePolicy]`

This can be used to specifiy additional update policy rules in the
following format
{ '<KEY_NAME' => {'matchtype' => '<VALUE>', 'tname' => '<VALUE>', 'rr' => 'VALUE' } }
Example {'foreman_key' => {'matchtype' => 'zonesub', 'rr' => 'ANY'}}
tname and rr are optional

Default value: `undef`

##### <a name="-dns--zone--target_views"></a>`target_views`

Data type: `Array[String]`



Default value: `[]`

##### <a name="-dns--zone--zonetype"></a>`zonetype`

Data type: `String`



Default value: `'master'`

##### <a name="-dns--zone--soa"></a>`soa`

Data type: `String`



Default value: `$facts['networking']['fqdn']`

##### <a name="-dns--zone--reverse"></a>`reverse`

Data type: `Boolean`



Default value: `false`

##### <a name="-dns--zone--ttl"></a>`ttl`

Data type: `String`



Default value: `'10800'`

##### <a name="-dns--zone--refresh"></a>`refresh`

Data type: `Integer`



Default value: `86400`

##### <a name="-dns--zone--update_retry"></a>`update_retry`

Data type: `Integer`



Default value: `3600`

##### <a name="-dns--zone--expire"></a>`expire`

Data type: `Integer`



Default value: `604800`

##### <a name="-dns--zone--negttl"></a>`negttl`

Data type: `Integer`



Default value: `3600`

##### <a name="-dns--zone--serial"></a>`serial`

Data type: `Integer`



Default value: `1`

##### <a name="-dns--zone--records"></a>`records`

Data type: `Array[String[1]]`

A list of records which will be added to the zone file in
the RFC 1035 format (see https://datatracker.ietf.org/doc/html/rfc1035)
Example ['host1 IN A 192.168.0.10', 'alt-host1 IN CNAME host1']

Default value: `[]`

##### <a name="-dns--zone--masters"></a>`masters`

Data type: `Array`



Default value: `[]`

##### <a name="-dns--zone--allow_transfer"></a>`allow_transfer`

Data type: `Array`



Default value: `[]`

##### <a name="-dns--zone--allow_query"></a>`allow_query`

Data type: `Array`



Default value: `[]`

##### <a name="-dns--zone--allow_update"></a>`allow_update`

Data type: `Array`



Default value: `[]`

##### <a name="-dns--zone--also_notify"></a>`also_notify`

Data type: `Array`



Default value: `[]`

##### <a name="-dns--zone--zone"></a>`zone`

Data type: `String`



Default value: `$title`

##### <a name="-dns--zone--contact"></a>`contact`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dns--zone--zonefilepath"></a>`zonefilepath`

Data type: `Stdlib::Absolutepath`



Default value: `$dns::zonefilepath`

##### <a name="-dns--zone--filename"></a>`filename`

Data type: `String`



Default value: `"db.${title}"`

##### <a name="-dns--zone--forward"></a>`forward`

Data type: `Enum['first', 'only']`



Default value: `'first'`

##### <a name="-dns--zone--master_empty_forwarders_enable"></a>`master_empty_forwarders_enable`

Data type: `Boolean`

Enable empty forwarders option in master zone.
Applicable when forwarders are empty and zonetype is set to master.

Default value: `false`

##### <a name="-dns--zone--forwarders"></a>`forwarders`

Data type: `Array[Dns::Forwarder]`



Default value: `[]`

##### <a name="-dns--zone--dns_notify"></a>`dns_notify`

Data type: `Optional[Enum['yes', 'no', 'explicit']]`



Default value: `undef`

##### <a name="-dns--zone--zone_statistics"></a>`zone_statistics`

Data type: `Optional[Enum['yes', 'no']]`



Default value: `undef`

##### <a name="-dns--zone--key_directory"></a>`key_directory`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

##### <a name="-dns--zone--inline_signing"></a>`inline_signing`

Data type: `Optional[Enum['yes', 'no']]`



Default value: `undef`

##### <a name="-dns--zone--dnssec_secure_to_insecure"></a>`dnssec_secure_to_insecure`

Data type: `Optional[Enum['yes', 'no']]`



Default value: `undef`

##### <a name="-dns--zone--auto_dnssec"></a>`auto_dnssec`

Data type: `Optional[Enum['allow', 'maintain', 'off']]`



Default value: `undef`

##### <a name="-dns--zone--dnssec_policy"></a>`dnssec_policy`

Data type: `Optional[String[1]]`

Causes the zone to be signed and turns on automatic maintenance for the zone.

Default value: `undef`

##### <a name="-dns--zone--masterfile_format"></a>`masterfile_format`

Data type: `Optional[Enum['text', 'raw', 'map']]`

The format used to load the master file

Default value: `undef`

## Functions

### <a name="dns--dnssec_keygen"></a>`dns::dnssec_keygen`

Type: Ruby 4.x API

Generate a DNSSEC key

#### `dns::dnssec_keygen(String[1] $name, String[1] $algorithm, Optional[Integer[1, 4096]] $keysize, Optional[String[1]] $nametype)`

The dns::dnssec_keygen function.

Returns: `Hash[String, String]`

##### `name`

Data type: `String[1]`



##### `algorithm`

Data type: `String[1]`



##### `keysize`

Data type: `Optional[Integer[1, 4096]]`



##### `nametype`

Data type: `Optional[String[1]]`



### <a name="dns--reverse_dns"></a>`dns::reverse_dns`

Type: Ruby 4.x API

Get the reverse DNS for an IP address

#### `dns::reverse_dns(Stdlib::IP::Address::Nosubnet $ip)`

The dns::reverse_dns function.

Returns: `Stdlib::Fqdn`

##### `ip`

Data type: `Stdlib::IP::Address::Nosubnet`

The IP address to get the reverse for

### <a name="dns--tsig_keygen"></a>`dns::tsig_keygen`

Type: Ruby 4.x API

Generate a TSIG key

#### `dns::tsig_keygen(String[1] $name, Optional[String[1]] $algorithm)`

The dns::tsig_keygen function.

Returns: `Hash[String, String]`

##### `name`

Data type: `String[1]`



##### `algorithm`

Data type: `Optional[String[1]]`



### <a name="get_in_addr_arpa"></a>`get_in_addr_arpa`

Type: Ruby 4.x API

DEPRECATED.  Use the [`dns::reverse_dns`](#dnsreverse_dns) function instead.

#### `get_in_addr_arpa(Any *$args)`

The get_in_addr_arpa function.

Returns: `Any`

##### `*args`

Data type: `Any`



## Data types

### <a name="Dns--Dnssec_policy_key"></a>`Dns::Dnssec_policy_key`

Validate dnssec-policy parameter

Alias of

```puppet
Struct[{
    type      => Enum['csk', 'ksk', 'zsk'],
    directory => Optional[Enum['key-directory']],
    lifetime  => String[1],
    algorithm => Variant[String[1], Integer],
    size      => Optional[Integer],
  }]
```

### <a name="Dns--Forwarder"></a>`Dns::Forwarder`

A forwarder is an IP address (v4 or v6) with optionally followed a port.
Since we can't compose patterns, this copies stdlib's implementation for v4.
For v6 it uses the default type and grossly simplifies the port check for simplicity.

Alias of `Variant[Pattern[/\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\s+port\s+[0-9]{1,5})?\z/], Stdlib::IP::Address::V6::Nosubnet, Pattern[/(\A(:{0,2}[[:xdigit:]]{1,4}){1,8}\s+port\s[0-9]{1,5}\Z)/]]`

### <a name="Dns--UpdatePolicy"></a>`Dns::UpdatePolicy`

Validate update-policy parameter

Alias of

```puppet
Variant[Enum['local'], Hash[
    String,
    Struct[{
      Optional[action] => Enum['deny', 'grant'],
      Optional[tname]  => String,
      rr               => String,
      matchtype        => Enum[
        '6to4-self',
        'external',
        'krb5-self',
        'krb5-selfsub',
        'krb5-subdomain',
        'ms-self',
        'ms-selfsub',
        'ms-subdomain',
        'name',
        'self',
        'selfsub',
        'selfwild',
        'subdomain',
        'tcp-self',
        'wildcard',
        'zonesub',
      ],
    }],
  ]]
```

