# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Functions

* [`extlib::cache_data`](#extlib--cache_data): Retrieves data from a cache file, or creates it with supplied data if the file doesn't exist
* [`extlib::cidr_to_netmask`](#extlib--cidr_to_netmask): Converts an CIDR address of the form 192.168.0.1/24 into its netmask.
* [`extlib::cidr_to_network`](#extlib--cidr_to_network): Converts a CIDR address of the form 2001:DB8::/32 or 192.0.2.0/24 into their network address (also known as net address)
* [`extlib::compare_ip`](#extlib--compare_ip): A function that compares two IP addresses. To be used with the built-in sort() function.
* [`extlib::default_content`](#extlib--default_content): Takes an optional content and an optional template name and returns the contents of a file.
* [`extlib::dir_clean`](#extlib--dir_clean): Take a path and normalise it to its Unix form.
* [`extlib::dir_split`](#extlib--dir_split): Splits the given directory or directories into individual paths.
* [`extlib::dump_args`](#extlib--dump_args): Prints the args to STDOUT in Pretty JSON format.
* [`extlib::dump_params`](#extlib--dump_params): this function is used to get a list of parameters passed to or resource.
* [`extlib::echo`](#extlib--echo): This function outputs the variable content and its type to the debug log. It's similiar to the `notice` function but provides a better output
* [`extlib::file_separator`](#extlib--file_separator): Returns the os specific file path separator.
* [`extlib::has_module`](#extlib--has_module): A function that lets you know whether a specific module is on your modulepath.
* [`extlib::ip_to_cron`](#extlib--ip_to_cron): Provides a "random" value to cron based on the last bit of the machine IP address. used to avoid starting a certain cron job at the same time
* [`extlib::ip_to_reverse`](#extlib--ip_to_reverse): Returns the reverse of an IP address
* [`extlib::is_in_cidr`](#extlib--is_in_cidr): Returns a boolean indicating whether an IP address is part of a network CIDR
* [`extlib::last_in_cidr`](#extlib--last_in_cidr): Converts an IPv4 or IPv6 CIDR address of the form 192.0.2.1/24 or 2001:db8::1/64 into the last address in the network
* [`extlib::mkdir_p`](#extlib--mkdir_p): Like the unix command mkdir_p except with puppet code.
* [`extlib::netmask_to_cidr`](#extlib--netmask_to_cidr): Converts an octet netmask address of the form 255.255.255.0 into its CIDR variant.
Thus making it directly usable with the values from facter.
* [`extlib::path_join`](#extlib--path_join): Take one or more paths and join them together
* [`extlib::random_password`](#extlib--random_password): A function to return a string of arbitrary length that contains randomly selected characters.
* [`extlib::read_url`](#extlib--read_url): Fetch a string from a URL (should only be used with 'small' remote files).  This function should only be used with trusted/internal sources. 
* [`extlib::resources_deep_merge`](#extlib--resources_deep_merge): Deeply merge a "defaults" hash into a "resources" hash like the ones expected by `create_resources()`.
* [`extlib::sort_by_version`](#extlib--sort_by_version): A function that sorts an array of version numbers.
* [`extlib::to_ini`](#extlib--to_ini): This converts a puppet hash to an INI string.

Based on https://github.com/mmckinst/puppet-hash2stuff/blob/master/lib/puppet/parser/functions/hash2ini.rb

## Functions

### <a name="extlib--cache_data"></a>`extlib::cache_data`

Type: Ruby 4.x API

Retrieves data from a cache file, or creates it with supplied data if the
file doesn't exist

Useful for having data that's randomly generated once on the master side
(e.g. a password), but then stays the same on subsequent runs. Because it's
stored on the master on disk, it doesn't work when you use mulitple Puppet
masters that don't share their vardir.

#### Examples

##### Calling the function

```puppet
$password = cache_data('mysql', 'mysql_password', 'this_is_my_password')
```

##### With a random password

```puppet
$password = cache_data('mysql', 'mysql_password', random_password())
```

#### `extlib::cache_data(String[1] $namespace, String[1] $name, Any $initial_data)`

Retrieves data from a cache file, or creates it with supplied data if the
file doesn't exist

Useful for having data that's randomly generated once on the master side
(e.g. a password), but then stays the same on subsequent runs. Because it's
stored on the master on disk, it doesn't work when you use mulitple Puppet
masters that don't share their vardir.

Returns: `Any` The cached value when it exists. The initial data when no cache exists

##### Examples

###### Calling the function

```puppet
$password = cache_data('mysql', 'mysql_password', 'this_is_my_password')
```

###### With a random password

```puppet
$password = cache_data('mysql', 'mysql_password', random_password())
```

##### `namespace`

Data type: `String[1]`

Namespace for the cache

##### `name`

Data type: `String[1]`

Cache key within the namespace

##### `initial_data`

Data type: `Any`

The data for when there is no cache yet

### <a name="extlib--cidr_to_netmask"></a>`extlib::cidr_to_netmask`

Type: Ruby 4.x API

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

#### Examples

##### calling the function

```puppet
extlib::cidr_to_netmask('127.0.0.1/8')
```

#### `extlib::cidr_to_netmask(Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR] $ip)`

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

Returns: `Variant[Stdlib::IP::Address::V4::Nosubnet,Stdlib::IP::Address::V6::Nosubnet]` IPv6 or IPv4 netmask address

##### Examples

###### calling the function

```puppet
extlib::cidr_to_netmask('127.0.0.1/8')
```

##### `ip`

Data type: `Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR]`

IPv6 or IPv4 address in CIDR notation

### <a name="extlib--cidr_to_network"></a>`extlib::cidr_to_network`

Type: Ruby 4.x API

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

#### Examples

##### calling the function

```puppet
extlib::cidr_to_network('2001:DB8::/32')
```

#### `extlib::cidr_to_network(Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR] $ip)`

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

Returns: `Variant[Stdlib::IP::Address::V4::Nosubnet,Stdlib::IP::Address::V6::Nosubnet]` IPv6 or IPv4 network/net address

##### Examples

###### calling the function

```puppet
extlib::cidr_to_network('2001:DB8::/32')
```

##### `ip`

Data type: `Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR]`

IPv6 or IPv4 address in CIDR notation

### <a name="extlib--compare_ip"></a>`extlib::compare_ip`

Type: Ruby 4.x API

A function that compares two IP addresses. To be used with the built-in sort()
function.

#### Examples

##### Sorting the array of IP addresses

```puppet
$ip_addresses = ['10.1.1.1', '10.10.1.1', '10.2.1.1']
$ip_addresses.sort |$a, $b| { extlib::compare_ip($a, $b) }
```

#### `extlib::compare_ip(Stdlib::IP::Address $left, Stdlib::IP::Address $right)`

A function that compares two IP addresses. To be used with the built-in sort()
function.

Returns: `Integer[-1,1]` -1, 0 or 1 if left value is lesser, equal or greater than right value

##### Examples

###### Sorting the array of IP addresses

```puppet
$ip_addresses = ['10.1.1.1', '10.10.1.1', '10.2.1.1']
$ip_addresses.sort |$a, $b| { extlib::compare_ip($a, $b) }
```

##### `left`

Data type: `Stdlib::IP::Address`

Left value

##### `right`

Data type: `Stdlib::IP::Address`

Right value

### <a name="extlib--default_content"></a>`extlib::default_content`

Type: Ruby 4.x API

Takes an optional content and an optional template name and returns the contents of a file.

#### Examples

##### Using the function with a file resource.

```puppet
$config_file_content = default_content($file_content, $template_location)
file { '/tmp/x':
  ensure  => 'file',
  content => $config_file_content,
}
```

#### `extlib::default_content(Optional[String] $content, Optional[String] $template_name)`

Takes an optional content and an optional template name and returns the contents of a file.

Returns: `Optional[String]` Returns the value of the content parameter if it's a non empty string.
Otherwise returns the rendered output from `template_name`.
Returns `undef` if both `content` and `template_name` are `undef`.

##### Examples

###### Using the function with a file resource.

```puppet
$config_file_content = default_content($file_content, $template_location)
file { '/tmp/x':
  ensure  => 'file',
  content => $config_file_content,
}
```

##### `content`

Data type: `Optional[String]`



##### `template_name`

Data type: `Optional[String]`

The path to an .erb or .epp template file or `undef`.

### <a name="extlib--dir_clean"></a>`extlib::dir_clean`

Type: Puppet Language

Instead of having to deal with the different separators between Unix and Windows this
function instead formats Windows paths a equivalent Unix like path.

$dir is defined as a Variant to support cleaning 'c:' which is not a valid
Stdlib::Absolutepath

#### Examples

##### clean Unix paths to return `/tmp/test/libs` (i.e. noop)

```puppet
extlib::dir_clean('/tmp/test/libs')
```

##### Clean Windows paths to return `/c/test/libs`

```puppet
extlib::dir_clean('c:\\'test\\libs')
```

#### `extlib::dir_clean(Variant[Stdlib::Absolutepath, Pattern[/\A[a-zA-Z]:\z/]] $dir)`

Instead of having to deal with the different separators between Unix and Windows this
function instead formats Windows paths a equivalent Unix like path.

$dir is defined as a Variant to support cleaning 'c:' which is not a valid
Stdlib::Absolutepath

Returns: `Stdlib::Unixpath` Stdlib::Unixpath The cleaned path

##### Examples

###### clean Unix paths to return `/tmp/test/libs` (i.e. noop)

```puppet
extlib::dir_clean('/tmp/test/libs')
```

###### Clean Windows paths to return `/c/test/libs`

```puppet
extlib::dir_clean('c:\\'test\\libs')
```

##### `dir`

Data type: `Variant[Stdlib::Absolutepath, Pattern[/\A[a-zA-Z]:\z/]]`

The path to clean

### <a name="extlib--dir_split"></a>`extlib::dir_split`

Type: Puppet Language

Use this function when you need to split a absolute path into multiple absolute paths
that all descend from the given path.

#### Examples

##### calling the function

```puppet
extlib::dir_split('/opt/puppetlabs') => ['/opt', '/opt/puppetlabs']
```

#### `extlib::dir_split(Variant[Stdlib::Absolutepath, Array[Stdlib::Absolutepath]] $dirs)`

Use this function when you need to split a absolute path into multiple absolute paths
that all descend from the given path.

Returns: `Array[String]` - an array of absolute paths after being cut into individual paths.

##### Examples

###### calling the function

```puppet
extlib::dir_split('/opt/puppetlabs') => ['/opt', '/opt/puppetlabs']
```

##### `dirs`

Data type: `Variant[Stdlib::Absolutepath, Array[Stdlib::Absolutepath]]`

- either an absolute path or a array of absolute paths.

### <a name="extlib--dump_args"></a>`extlib::dump_args`

Type: Ruby 4.x API

Prints the args to STDOUT in Pretty JSON format.

Useful for debugging purposes only. Ideally you would use this in
conjunction with a rspec-puppet unit test.  Otherwise the output will
be shown during a puppet run when verbose/debug options are enabled.

#### `extlib::dump_args(Any $args)`

Prints the args to STDOUT in Pretty JSON format.

Useful for debugging purposes only. Ideally you would use this in
conjunction with a rspec-puppet unit test.  Otherwise the output will
be shown during a puppet run when verbose/debug options are enabled.

Returns: `Undef` Returns nothing.

##### `args`

Data type: `Any`

The data you want to dump as pretty JSON.

### <a name="extlib--dump_params"></a>`extlib::dump_params`

Type: Ruby 4.x API

this function is used to get a list of parameters passed to or resource.

#### Examples

##### Passing Parameters from a profile straight though to a base class

```puppet

class profile::foobar ($param1, $param2) {
   class { 'foobar':
     *                => extlib::dump_params,
     additional_param => 'foobar',
   }
 }
```

##### Passing parameters directly to a config file.

```puppet

class foobar ($app_param1, $app_param2, $class_param1) {
  file { '/etc/foo/config.yaml':
    ensure => file,
    # class param and name are not understoof by the foo app
    content => extlib::dump_params(['name', 'class_param1']).to_yaml
  }
}
```

#### `extlib::dump_params(Optional[Array[String[1]]] $filter_keys)`

The extlib::dump_params function.

Returns: `Any`

##### Examples

###### Passing Parameters from a profile straight though to a base class

```puppet

class profile::foobar ($param1, $param2) {
   class { 'foobar':
     *                => extlib::dump_params,
     additional_param => 'foobar',
   }
 }
```

###### Passing parameters directly to a config file.

```puppet

class foobar ($app_param1, $app_param2, $class_param1) {
  file { '/etc/foo/config.yaml':
    ensure => file,
    # class param and name are not understoof by the foo app
    content => extlib::dump_params(['name', 'class_param1']).to_yaml
  }
}
```

##### `filter_keys`

Data type: `Optional[Array[String[1]]]`

an optional parameters of keys to filter out.  default value is set to 'name'

### <a name="extlib--echo"></a>`extlib::echo`

Type: Ruby 4.x API

This function outputs the variable content and its type to the
debug log. It's similiar to the `notice` function but provides
a better output format useful to trace variable types and values
in the manifests.

```
$v1 = 'test'
$v2 = ["1", "2", "3"]
$v3 = {"a"=>"1", "b"=>"2"}
$v4 = true
# $v5 is not defined
$v6 = { "b" => { "b" => [1,2,3], "c" => true, "d" => { 'x' => 'y' }}, 'x' => 'y', 'z' => [1,2,3,4,5,6]}
$v7 = 12345

echo($v1, 'My string')
echo($v2, 'My array')
echo($v3, 'My hash')
echo($v4, 'My boolean')
echo($v5, 'My undef')
echo($v6, 'My structure')
echo($v7) # no comment here
debug log output
My string (String) "test"
My array (Array) ["1", "2", "3"]
My hash (Hash) {"a"=>"1", "b"=>"2"}
My boolean (TrueClass) true
My undef (String) ""
My structure (Hash) {"b"=>{"b"=>["1", "2", "3"], "c"=>true, "d"=>{"x"=>"y"}}, "x"=>"y", "z"=>["1", "2", "3", "4", "5", "6"]}
(String) "12345"
```

#### `extlib::echo(Any $value, Optional[String] $comment)`

This function outputs the variable content and its type to the
debug log. It's similiar to the `notice` function but provides
a better output format useful to trace variable types and values
in the manifests.

```
$v1 = 'test'
$v2 = ["1", "2", "3"]
$v3 = {"a"=>"1", "b"=>"2"}
$v4 = true
# $v5 is not defined
$v6 = { "b" => { "b" => [1,2,3], "c" => true, "d" => { 'x' => 'y' }}, 'x' => 'y', 'z' => [1,2,3,4,5,6]}
$v7 = 12345

echo($v1, 'My string')
echo($v2, 'My array')
echo($v3, 'My hash')
echo($v4, 'My boolean')
echo($v5, 'My undef')
echo($v6, 'My structure')
echo($v7) # no comment here
debug log output
My string (String) "test"
My array (Array) ["1", "2", "3"]
My hash (Hash) {"a"=>"1", "b"=>"2"}
My boolean (TrueClass) true
My undef (String) ""
My structure (Hash) {"b"=>{"b"=>["1", "2", "3"], "c"=>true, "d"=>{"x"=>"y"}}, "x"=>"y", "z"=>["1", "2", "3", "4", "5", "6"]}
(String) "12345"
```

Returns: `Undef` Returns nothing.

##### `value`

Data type: `Any`

The value you want to inspect.

##### `comment`

Data type: `Optional[String]`

An optional comment to prepend to the debug output.

### <a name="extlib--file_separator"></a>`extlib::file_separator`

Type: Puppet Language

Returns the os specific file path separator.

#### Examples

##### Example of how to use

```puppet
extlib::file_separator() => '/'
```

#### `extlib::file_separator()`

The extlib::file_separator function.

Returns: `String` - The os specific path separator.

##### Examples

###### Example of how to use

```puppet
extlib::file_separator() => '/'
```

### <a name="extlib--has_module"></a>`extlib::has_module`

Type: Ruby 4.x API

A function that lets you know whether a specific module is on your modulepath.

#### Examples

##### Calling the function

```puppet
extlib::has_module('camptocamp/systemd')
```

#### `extlib::has_module(Pattern[/\A\w+[-\/]\w+\z/] $module_name)`

A function that lets you know whether a specific module is on your modulepath.

Returns: `Boolean` Returns `true` or `false`.

##### Examples

###### Calling the function

```puppet
extlib::has_module('camptocamp/systemd')
```

##### `module_name`

Data type: `Pattern[/\A\w+[-\/]\w+\z/]`

The full name of the module you want to know exists or not.
Namespace and modulename can be separated with either `-` or `/`.

### <a name="extlib--ip_to_cron"></a>`extlib::ip_to_cron`

Type: Ruby 4.x API

Provides a "random" value to cron based on the last bit of the machine IP address.
used to avoid starting a certain cron job at the same time on all servers.
Takes the runinterval in seconds as parameter and returns an array of [hour, minute]

example usage
```
ip_to_cron(3600) - returns [ '*', one value between 0..59 ]
ip_to_cron(1800) - returns [ '*', an array of two values between 0..59 ]
ip_to_cron(7200) - returns [ an array of twelve values between 0..23, one value between 0..59 ]
```

#### `extlib::ip_to_cron(Optional[Integer[1]] $runinterval)`

Provides a "random" value to cron based on the last bit of the machine IP address.
used to avoid starting a certain cron job at the same time on all servers.
Takes the runinterval in seconds as parameter and returns an array of [hour, minute]

example usage
```
ip_to_cron(3600) - returns [ '*', one value between 0..59 ]
ip_to_cron(1800) - returns [ '*', an array of two values between 0..59 ]
ip_to_cron(7200) - returns [ an array of twelve values between 0..23, one value between 0..59 ]
```

Returns: `Array`

##### `runinterval`

Data type: `Optional[Integer[1]]`

The number of seconds to use as the run interval

### <a name="extlib--ip_to_reverse"></a>`extlib::ip_to_reverse`

Type: Ruby 4.x API

No actual query is done to the DNS server, it only calculate the record that
could be added to a DNS zone file.

If you want to effectively make a query, see Vox Pupuli dns-query module:
https://github.com/voxpupuli/puppet-dnsquery

#### Examples

##### Calling the function

```puppet
extlib::ip_to_reverse('192.0.2.0')
```

#### `extlib::ip_to_reverse(Stdlib::IP::Address $ip)`

No actual query is done to the DNS server, it only calculate the record that
could be added to a DNS zone file.

If you want to effectively make a query, see Vox Pupuli dns-query module:
https://github.com/voxpupuli/puppet-dnsquery

Returns: `String`

##### Examples

###### Calling the function

```puppet
extlib::ip_to_reverse('192.0.2.0')
```

##### `ip`

Data type: `Stdlib::IP::Address`

IPv4 or IPv6 address

### <a name="extlib--is_in_cidr"></a>`extlib::is_in_cidr`

Type: Ruby 4.x API

Returns a boolean indicating whether an IP address is part of a network CIDR

#### Examples

##### Calling the function

```puppet
'192.0.2.42'.extlib::is_in_cidr('192.0.2.0/24')
```

#### `extlib::is_in_cidr(Stdlib::IP::Address::Nosubnet $ip, Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR] $cidr)`

The extlib::is_in_cidr function.

Returns: `Boolean`

##### Examples

###### Calling the function

```puppet
'192.0.2.42'.extlib::is_in_cidr('192.0.2.0/24')
```

##### `ip`

Data type: `Stdlib::IP::Address::Nosubnet`

IPv4 or IPv6 address

##### `cidr`

Data type: `Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR]`

CIDR you want to check whether the IP address is in or not

### <a name="extlib--last_in_cidr"></a>`extlib::last_in_cidr`

Type: Ruby 4.x API

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

#### Examples

##### calling the function

```puppet
extlib::last_in_cidr('127.0.0.1/8')
```

#### `extlib::last_in_cidr(Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR] $ip)`

Imported by Tim 'bastelfreak' Meusel into voxpupuli/extlib because Yelp/netstdlib got abandoned

Returns: `Variant[Stdlib::IP::Address::V4::Nosubnet,Stdlib::IP::Address::V6::Nosubnet]` last address in the network

##### Examples

###### calling the function

```puppet
extlib::last_in_cidr('127.0.0.1/8')
```

##### `ip`

Data type: `Variant[Stdlib::IP::Address::V4::CIDR,Stdlib::IP::Address::V6::CIDR]`

IP address in CIDR notation

### <a name="extlib--mkdir_p"></a>`extlib::mkdir_p`

Type: Puppet Language

This creates file resources for all directories and utilizes the dir_split() function
to get a list of all the descendant directories.  You will have no control over any other parameters
for the file resource.  If you wish to control the file resources you can use the dir_split() function
and get an array of directories for use in your own code.  Please note this does not use an exec resource.

* **Note** splits the given directories into paths that are then created using file resources

#### Examples

##### How to use

```puppet
extlib::mkdir_p('/opt/puppetlabs/bin') => ['/opt', '/opt/puppetlabs', '/opt/puppetlabs/bin']
```

#### `extlib::mkdir_p(Variant[Stdlib::Absolutepath, Array[Stdlib::Absolutepath]] $dirs)`

This creates file resources for all directories and utilizes the dir_split() function
to get a list of all the descendant directories.  You will have no control over any other parameters
for the file resource.  If you wish to control the file resources you can use the dir_split() function
and get an array of directories for use in your own code.  Please note this does not use an exec resource.

Returns: `Array[Stdlib::Absolutepath]`

##### Examples

###### How to use

```puppet
extlib::mkdir_p('/opt/puppetlabs/bin') => ['/opt', '/opt/puppetlabs', '/opt/puppetlabs/bin']
```

##### `dirs`

Data type: `Variant[Stdlib::Absolutepath, Array[Stdlib::Absolutepath]]`

- the path(s) to create

### <a name="extlib--netmask_to_cidr"></a>`extlib::netmask_to_cidr`

Type: Ruby 4.x API

Converts an octet netmask address of the form 255.255.255.0 into its CIDR variant.
Thus making it directly usable with the values from facter.

#### Examples

##### calling the function

```puppet
extlib::netmask_to_cidr('255.0.0.0')
```

#### `extlib::netmask_to_cidr(Stdlib::IP::Address::Nosubnet $netmask)`

The extlib::netmask_to_cidr function.

Returns: `Integer[0, 128]` CIDR / prefix length

##### Examples

###### calling the function

```puppet
extlib::netmask_to_cidr('255.0.0.0')
```

##### `netmask`

Data type: `Stdlib::IP::Address::Nosubnet`

IPv6 or IPv4 netmask in octet notation

### <a name="extlib--path_join"></a>`extlib::path_join`

Type: Puppet Language

This function will format a windows paths into equivalent unix like paths.
This type of unix like path should work on windows.

#### Examples

##### Joining Unix paths to return `/tmp/test/libs`

```puppet
extlib::path_join(['/tmp', 'test', 'libs'])
```

##### Joining Windows paths to return `/c/test/libs`

```puppet
extlib::path_join(['c:', 'test', 'libs'])
```

#### `extlib::path_join(Variant[String, Array[String]] $dirs)`

This function will format a windows paths into equivalent unix like paths.
This type of unix like path should work on windows.

Returns: `Stdlib::Absolutepath` The joined path

##### Examples

###### Joining Unix paths to return `/tmp/test/libs`

```puppet
extlib::path_join(['/tmp', 'test', 'libs'])
```

###### Joining Windows paths to return `/c/test/libs`

```puppet
extlib::path_join(['c:', 'test', 'libs'])
```

##### `dirs`

Data type: `Variant[String, Array[String]]`

Joins two or more directories by file separator.

### <a name="extlib--random_password"></a>`extlib::random_password`

Type: Ruby 4.x API

A function to return a string of arbitrary length that contains randomly selected characters.

#### Examples

##### Calling the function

```puppet
random_password(42)
```

#### `extlib::random_password(Integer[1] $length)`

A function to return a string of arbitrary length that contains randomly selected characters.

Returns: `String` The random string returned consists of alphanumeric characters excluding 'look-alike' characters.

##### Examples

###### Calling the function

```puppet
random_password(42)
```

##### `length`

Data type: `Integer[1]`

The length of random password you want generated.

### <a name="extlib--read_url"></a>`extlib::read_url`

Type: Ruby 4.x API

Fetch a string from a URL (should only be used with 'small' remote files).

This function should only be used with trusted/internal sources.
This is especially important if using it in conjunction with `inline_template`
or `inline_epp`.
The current implementation is also very basic.  No thought has gone into timeouts,
support for redirects, CA paths etc.

#### Examples

##### Calling the function

```puppet
extlib::read_url('https://example.com/sometemplate.epp')
```

#### `extlib::read_url(Stdlib::HTTPUrl $url)`

Fetch a string from a URL (should only be used with 'small' remote files).

This function should only be used with trusted/internal sources.
This is especially important if using it in conjunction with `inline_template`
or `inline_epp`.
The current implementation is also very basic.  No thought has gone into timeouts,
support for redirects, CA paths etc.

Returns: `String` Returns the contents of the url as a string

##### Examples

###### Calling the function

```puppet
extlib::read_url('https://example.com/sometemplate.epp')
```

##### `url`

Data type: `Stdlib::HTTPUrl`

The URL to read from

### <a name="extlib--resources_deep_merge"></a>`extlib::resources_deep_merge`

Type: Ruby 4.x API

Deeply merge a "defaults" hash into a "resources" hash like the ones expected by `create_resources()`.

Internally calls the puppetlabs-stdlib function `deep_merge()`. In case of
duplicate keys the `resources` hash keys win over the `defaults` hash keys.

Example
```puppet
$defaults_hash = {
  'one'   => '1',
  'two'   => '2',
  'three' => '3',
  'four'  => {
    'five'  => '5',
    'six'   => '6',
    'seven' => '7',
  }
}

$numbers_hash = {
  'german' => {
    'one'   => 'eins',
    'three' => 'drei',
    'four'  => {
      'six' => 'sechs',
    },
  },
  'french' => {
    'one' => 'un',
    'two' => 'deux',
    'four' => {
      'five'  => 'cinq',
      'seven' => 'sept',
    },
  }
}

$result_hash = resources_deep_merge($numbers_hash, $defaults_hash)
```

The $result_hash then looks like this:

```puppet
$result_hash = {
  'german' => {
    'one'   => 'eins',
    'two'   => '2',
    'three' => 'drei',
    'four'  => {
      'five'  => '5',
      'six'   => 'sechs',
      'seven' => '7',
    }
  },
  'french' => {
    'one'   => 'un',
    'two'   => 'deux',
    'three' => '3',
    'four'  => {
      'five'  => 'cinq',
      'six'   => '6',
      'seven' => 'sept',
    }
  }
}
```

#### `extlib::resources_deep_merge(Hash $resources, Hash $defaults)`

Deeply merge a "defaults" hash into a "resources" hash like the ones expected by `create_resources()`.

Internally calls the puppetlabs-stdlib function `deep_merge()`. In case of
duplicate keys the `resources` hash keys win over the `defaults` hash keys.

Example
```puppet
$defaults_hash = {
  'one'   => '1',
  'two'   => '2',
  'three' => '3',
  'four'  => {
    'five'  => '5',
    'six'   => '6',
    'seven' => '7',
  }
}

$numbers_hash = {
  'german' => {
    'one'   => 'eins',
    'three' => 'drei',
    'four'  => {
      'six' => 'sechs',
    },
  },
  'french' => {
    'one' => 'un',
    'two' => 'deux',
    'four' => {
      'five'  => 'cinq',
      'seven' => 'sept',
    },
  }
}

$result_hash = resources_deep_merge($numbers_hash, $defaults_hash)
```

The $result_hash then looks like this:

```puppet
$result_hash = {
  'german' => {
    'one'   => 'eins',
    'two'   => '2',
    'three' => 'drei',
    'four'  => {
      'five'  => '5',
      'six'   => 'sechs',
      'seven' => '7',
    }
  },
  'french' => {
    'one'   => 'un',
    'two'   => 'deux',
    'three' => '3',
    'four'  => {
      'five'  => 'cinq',
      'six'   => '6',
      'seven' => 'sept',
    }
  }
}
```

Returns: `Hash` Returns the merged hash.

##### `resources`

Data type: `Hash`

The hash of resources.

##### `defaults`

Data type: `Hash`

The hash of defaults to merge.

### <a name="extlib--sort_by_version"></a>`extlib::sort_by_version`

Type: Ruby 4.x API

A function that sorts an array of version numbers.

#### Examples

##### Calling the function

```puppet
extlib::sort_by_version(['10.0.0b12', '10.0.0b3', '10.0.0a2', '9.0.10', '9.0.3'])
```

#### `extlib::sort_by_version(Array[String] $versions)`

A function that sorts an array of version numbers.

Returns: `Array[String]` Returns the sorted array.

##### Examples

###### Calling the function

```puppet
extlib::sort_by_version(['10.0.0b12', '10.0.0b3', '10.0.0a2', '9.0.10', '9.0.3'])
```

##### `versions`

Data type: `Array[String]`

An array of version strings you want sorted.

### <a name="extlib--to_ini"></a>`extlib::to_ini`

Type: Ruby 4.x API

This converts a puppet hash to an INI string.

Based on https://github.com/mmckinst/puppet-hash2stuff/blob/master/lib/puppet/parser/functions/hash2ini.rb

#### Examples

##### How to output ini to a file

```puppet
file { '/tmp/config.ini':
  ensure  => file,
  content => extlib::to_ini($myhash),
}
```

#### `extlib::to_ini(Hash $data, Optional[Hash] $settings)`

The extlib::to_ini function.

Returns: `String` Converted data as ini string

##### Examples

###### How to output ini to a file

```puppet
file { '/tmp/config.ini':
  ensure  => file,
  content => extlib::to_ini($myhash),
}
```

##### `data`

Data type: `Hash`

Data structure which needs to be converted into ini

##### `settings`

Data type: `Optional[Hash]`

Override default ini generation settings

