# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`pulpcore`](#pulpcore): Manage your next generation Pulp server
* [`pulpcore::cli`](#pulpcore--cli): = Pulpcore command line interface  This class installs the Pulpcore command line interface (CLI).  === Parameters:  $pulpcore_url::       URL
* [`pulpcore::plugin::ansible`](#pulpcore--plugin--ansible): Pulp Ansible plugin
* [`pulpcore::plugin::certguard`](#pulpcore--plugin--certguard): Pulp Certguard plugin
* [`pulpcore::plugin::container`](#pulpcore--plugin--container): Pulp Container plugin
* [`pulpcore::plugin::deb`](#pulpcore--plugin--deb): Pulp Deb plugin
* [`pulpcore::plugin::file`](#pulpcore--plugin--file): Pulp File plugin
* [`pulpcore::plugin::ostree`](#pulpcore--plugin--ostree): Pulp Ostree plugin
* [`pulpcore::plugin::python`](#pulpcore--plugin--python): Pulp Python plugin
* [`pulpcore::plugin::rpm`](#pulpcore--plugin--rpm): Pulp RPM plugin
* [`pulpcore::repo`](#pulpcore--repo): Configure the Pulpcore repo

#### Private Classes

* `pulpcore::apache`: Configure an Apache vhost
* `pulpcore::config`: Configures pulp3
* `pulpcore::database`: Set up the PostgreSQL and Redis databases
* `pulpcore::install`: Install pulpcore packages, configure user and group
* `pulpcore::service`: configure, enable, and start pulpcore services
* `pulpcore::static`: Manage the static files (assets)

### Defined types

#### Public Defined types

* [`pulpcore::admin`](#pulpcore--admin): Run a pulpcore-manager command
* [`pulpcore::plugin`](#pulpcore--plugin): Install a plugin

#### Private Defined types

* `pulpcore::apache::fragment`: Deploy an Apache fragment. Only intended to be used within the module
* `pulpcore::socket_service`: Create a systemd socket activated service

### Data types

* [`Pulpcore::ChecksumTypes`](#Pulpcore--ChecksumTypes): The supported checksum types by pulpcore
* [`Pulpcore::LogLevel`](#Pulpcore--LogLevel)
* [`Pulpcore::Logger`](#Pulpcore--Logger)

## Classes

### <a name="pulpcore"></a>`pulpcore`

Manage your next generation Pulp server

* **See also**
  * https://docs.djangoproject.com/en/2.2/howto/static-files/

#### Examples

##### Default configuration

```puppet
include pulpcore
```

#### Parameters

The following parameters are available in the `pulpcore` class:

* [`user`](#-pulpcore--user)
* [`group`](#-pulpcore--group)
* [`user_home`](#-pulpcore--user_home)
* [`apache_http_vhost`](#-pulpcore--apache_http_vhost)
* [`apache_https_vhost`](#-pulpcore--apache_https_vhost)
* [`apache_https_cert`](#-pulpcore--apache_https_cert)
* [`apache_https_key`](#-pulpcore--apache_https_key)
* [`apache_https_ca`](#-pulpcore--apache_https_ca)
* [`apache_https_chain`](#-pulpcore--apache_https_chain)
* [`apache_vhost_priority`](#-pulpcore--apache_vhost_priority)
* [`api_socket_path`](#-pulpcore--api_socket_path)
* [`content_socket_path`](#-pulpcore--content_socket_path)
* [`config_dir`](#-pulpcore--config_dir)
* [`cache_dir`](#-pulpcore--cache_dir)
* [`apache_docroot`](#-pulpcore--apache_docroot)
* [`media_root`](#-pulpcore--media_root)
* [`static_root`](#-pulpcore--static_root)
* [`static_url`](#-pulpcore--static_url)
* [`postgresql_db_name`](#-pulpcore--postgresql_db_name)
* [`postgresql_db_user`](#-pulpcore--postgresql_db_user)
* [`postgresql_db_password`](#-pulpcore--postgresql_db_password)
* [`postgresql_db_host`](#-pulpcore--postgresql_db_host)
* [`postgresql_db_port`](#-pulpcore--postgresql_db_port)
* [`postgresql_manage_db`](#-pulpcore--postgresql_manage_db)
* [`postgresql_db_ssl`](#-pulpcore--postgresql_db_ssl)
* [`postgresql_db_ssl_require`](#-pulpcore--postgresql_db_ssl_require)
* [`postgresql_db_ssl_cert`](#-pulpcore--postgresql_db_ssl_cert)
* [`postgresql_db_ssl_key`](#-pulpcore--postgresql_db_ssl_key)
* [`postgresql_db_ssl_root_ca`](#-pulpcore--postgresql_db_ssl_root_ca)
* [`django_secret_key`](#-pulpcore--django_secret_key)
* [`redis_db`](#-pulpcore--redis_db)
* [`servername`](#-pulpcore--servername)
* [`serveraliases`](#-pulpcore--serveraliases)
* [`remote_user_environ_name`](#-pulpcore--remote_user_environ_name)
* [`authentication_backends`](#-pulpcore--authentication_backends)
* [`rest_framework_default_authentication_classes`](#-pulpcore--rest_framework_default_authentication_classes)
* [`allowed_import_path`](#-pulpcore--allowed_import_path)
* [`allowed_export_path`](#-pulpcore--allowed_export_path)
* [`allowed_content_checksums`](#-pulpcore--allowed_content_checksums)
* [`worker_count`](#-pulpcore--worker_count)
* [`worker_ttl`](#-pulpcore--worker_ttl)
* [`service_enable`](#-pulpcore--service_enable)
* [`service_ensure`](#-pulpcore--service_ensure)
* [`content_service_worker_count`](#-pulpcore--content_service_worker_count)
* [`api_service_worker_count`](#-pulpcore--api_service_worker_count)
* [`content_service_worker_timeout`](#-pulpcore--content_service_worker_timeout)
* [`api_service_worker_timeout`](#-pulpcore--api_service_worker_timeout)
* [`api_service_worker_max_requests`](#-pulpcore--api_service_worker_max_requests)
* [`api_service_worker_max_requests_jitter`](#-pulpcore--api_service_worker_max_requests_jitter)
* [`api_client_auth_cn_map`](#-pulpcore--api_client_auth_cn_map)
* [`cache_enabled`](#-pulpcore--cache_enabled)
* [`cache_expires_ttl`](#-pulpcore--cache_expires_ttl)
* [`log_level`](#-pulpcore--log_level)
* [`loggers`](#-pulpcore--loggers)
* [`analytics`](#-pulpcore--analytics)
* [`hide_guarded_distributions`](#-pulpcore--hide_guarded_distributions)
* [`import_workers_percent`](#-pulpcore--import_workers_percent)

##### <a name="-pulpcore--user"></a>`user`

Data type: `String`

Pulp user

Default value: `'pulp'`

##### <a name="-pulpcore--group"></a>`group`

Data type: `String`

Pulp user group

Default value: `'pulp'`

##### <a name="-pulpcore--user_home"></a>`user_home`

Data type: `Stdlib::Absolutepath`

Pulp user home directory

Default value: `'/var/lib/pulp'`

##### <a name="-pulpcore--apache_http_vhost"></a>`apache_http_vhost`

Data type: `Variant[Boolean, String[1]]`

When true, deploy a separate apache vhost for pulp3 listening on HTTP.
When a name is given, fragments are attached to the specified vhost.
When false, no Apache HTTP vhost is touched.

Default value: `true`

##### <a name="-pulpcore--apache_https_vhost"></a>`apache_https_vhost`

Data type: `Variant[Boolean, String[1]]`

When true, deploy a separate apache vhost for pulp3 listening on HTTPS.
When a name is given, fragments are attached to the specified vhost.
When false, no Apache HTTPS vhost is touched.

Default value: `true`

##### <a name="-pulpcore--apache_https_cert"></a>`apache_https_cert`

Data type: `Optional[Stdlib::Absolutepath]`

The certificate file to use in the HTTPS vhost. Only used when
apache_https_vhost is true.

Default value: `undef`

##### <a name="-pulpcore--apache_https_key"></a>`apache_https_key`

Data type: `Optional[Stdlib::Absolutepath]`

The key file to use in the HTTPS vhost. Only used when apache_https_vhost
is true.

Default value: `undef`

##### <a name="-pulpcore--apache_https_ca"></a>`apache_https_ca`

Data type: `Optional[Stdlib::Absolutepath]`

The ca file to use in the HTTPS vhost. Only used when apache_https_vhost is
true. The ca file should contain the certificates allowed to sign client
certificates. This can be a different CA than the chain.

Default value: `undef`

##### <a name="-pulpcore--apache_https_chain"></a>`apache_https_chain`

Data type: `Optional[Stdlib::Absolutepath]`

The chain file to use in the HTTPS vhost. Only used when apache_https_vhost
is true. The chain file should contain the CA certificate an any
intermediate certificates that signed the certificate.

Default value: `undef`

##### <a name="-pulpcore--apache_vhost_priority"></a>`apache_vhost_priority`

Data type: `String[1]`

The Apache vhost priority. When a name is passed to apache_http_vhost or
apache_https_vhost, this will be used when attaching fragments to those
vhosts. Note that this implies both vhosts need to have the same priority.

Default value: `'10'`

##### <a name="-pulpcore--api_socket_path"></a>`api_socket_path`

Data type: `Stdlib::Absolutepath`

Path where the Pulpcore API service is listening. This is a unix socket.

Default value: `'/run/pulpcore-api.sock'`

##### <a name="-pulpcore--content_socket_path"></a>`content_socket_path`

Data type: `Stdlib::Absolutepath`

Path where the Pulpcore Content service is listening. This is a unix socket.

Default value: `'/run/pulpcore-content.sock'`

##### <a name="-pulpcore--config_dir"></a>`config_dir`

Data type: `Stdlib::Absolutepath`

Pulp configuration directory. The settings.py file is created under this
directory.

Default value: `'/etc/pulp'`

##### <a name="-pulpcore--cache_dir"></a>`cache_dir`

Data type: `Stdlib::Absolutepath`

Pulp cache directory. This is used to configure WORKING_DIRECTORY and
FILE_UPLOAD_TEMP_DIR.

Default value: `'/var/lib/pulp/tmp'`

##### <a name="-pulpcore--apache_docroot"></a>`apache_docroot`

Data type: `Stdlib::Absolutepath`

Root directory for the Apache vhost. Only created if the Apache vhost is
managed by this module.

Default value: `'/var/lib/pulp/pulpcore_static'`

##### <a name="-pulpcore--media_root"></a>`media_root`

Data type: `Stdlib::Absolutepath`

Directory for Pulp's uploaded media. This corresponds to the MEDIA_ROOT
setting.

Default value: `'/var/lib/pulp/media'`

##### <a name="-pulpcore--static_root"></a>`static_root`

Data type: `Stdlib::Absolutepath`

Root directory for collected static content. This corresponds to the
STATIC_ROOT setting.

Default value: `'/var/lib/pulp/assets'`

##### <a name="-pulpcore--static_url"></a>`static_url`

Data type: `Pattern['^/.+/$']`

The "URL" that serves the collected static content. This corresponds to the
STATIC_URL setting. In reality this can also be just the path and doesn't
have to be a full URL.

Default value: `'/assets/'`

##### <a name="-pulpcore--postgresql_db_name"></a>`postgresql_db_name`

Data type: `String`

Name of Pulp PostgreSQL database

Default value: `'pulpcore'`

##### <a name="-pulpcore--postgresql_db_user"></a>`postgresql_db_user`

Data type: `String`

Pulp PostgreSQL database user

Default value: `'pulp'`

##### <a name="-pulpcore--postgresql_db_password"></a>`postgresql_db_password`

Data type: `String`

Password of Pulp PostgreSQL database

Default value: `extlib::cache_data('pulpcore_cache_data', 'db_password', extlib::random_password(32))`

##### <a name="-pulpcore--postgresql_db_host"></a>`postgresql_db_host`

Data type: `Stdlib::Host`

Host to connect to Pulp PostgreSQL database

Default value: `'localhost'`

##### <a name="-pulpcore--postgresql_db_port"></a>`postgresql_db_port`

Data type: `Stdlib::Port`

Port to connect to Pulp PostgreSQL database

Default value: `5432`

##### <a name="-pulpcore--postgresql_manage_db"></a>`postgresql_manage_db`

Data type: `Boolean`

Whether or not to manage the PostgreSQL installation. If false, a database at the specified host and port is expected to exist and the user should have sufficient permissions.

Default value: `true`

##### <a name="-pulpcore--postgresql_db_ssl"></a>`postgresql_db_ssl`

Data type: `Boolean`

Whether to configure SSL connection for PostgresQL database. The configuration is only applied if the PostgresQL database is unmanaged.

Default value: `false`

##### <a name="-pulpcore--postgresql_db_ssl_require"></a>`postgresql_db_ssl_require`

Data type: `Optional[Boolean]`

Specifies whether pulpcore is configured to require an encrypted connection to the unmanaged PostgreSQL database server.

Default value: `undef`

##### <a name="-pulpcore--postgresql_db_ssl_cert"></a>`postgresql_db_ssl_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Path to the SSL certificate to be used for the SSL connection to PostgreSQL.

Default value: `undef`

##### <a name="-pulpcore--postgresql_db_ssl_key"></a>`postgresql_db_ssl_key`

Data type: `Optional[Stdlib::Absolutepath]`

Path to the key to be used for the SSL connection to PostgreSQL.

Default value: `undef`

##### <a name="-pulpcore--postgresql_db_ssl_root_ca"></a>`postgresql_db_ssl_root_ca`

Data type: `Optional[Stdlib::Absolutepath]`

Path to the root certificate authority to validate the certificate supplied by the PostgreSQL database server.

Default value: `undef`

##### <a name="-pulpcore--django_secret_key"></a>`django_secret_key`

Data type: `String`

SECRET_KEY for Django

Default value: `extlib::cache_data('pulpcore_cache_data', 'secret_key', extlib::random_password(50))`

##### <a name="-pulpcore--redis_db"></a>`redis_db`

Data type: `Integer[0]`

Redis DB number to use. By default, Redis supports a DB number of 0 through 15.

Default value: `8`

##### <a name="-pulpcore--servername"></a>`servername`

Data type: `Stdlib::Fqdn`

Server name of the VirtualHost in the webserver

Default value: `$facts['networking']['fqdn']`

##### <a name="-pulpcore--serveraliases"></a>`serveraliases`

Data type: `Array[Stdlib::Fqdn]`

Server aliases of the VirtualHost in the webserver

Default value: `[]`

##### <a name="-pulpcore--remote_user_environ_name"></a>`remote_user_environ_name`

Data type: `String[1]`

Django remote user environment variable

Default value: `'HTTP_REMOTE_USER'`

##### <a name="-pulpcore--authentication_backends"></a>`authentication_backends`

Data type: `Array[String[1]]`

List of used authentication backends

Default value: `['pulpcore.app.authentication.PulpNoCreateRemoteUserBackend']`

##### <a name="-pulpcore--rest_framework_default_authentication_classes"></a>`rest_framework_default_authentication_classes`

Data type: `Array[String[1]]`

List of used REST framework default authentication classes

Default value:

```puppet
[
    'rest_framework.authentication.SessionAuthentication',
    'pulpcore.app.authentication.PulpRemoteUserAuthentication',
  ]
```

##### <a name="-pulpcore--allowed_import_path"></a>`allowed_import_path`

Data type: `Array[Stdlib::Absolutepath]`

Allowed paths that pulp can use for content imports, or sync from using file:// protocol

Default value: `['/var/lib/pulp/sync_imports']`

##### <a name="-pulpcore--allowed_export_path"></a>`allowed_export_path`

Data type: `Array[Stdlib::Absolutepath]`

Allowed paths that pulp can use for content exports

Default value: `[]`

##### <a name="-pulpcore--allowed_content_checksums"></a>`allowed_content_checksums`

Data type: `Pulpcore::ChecksumTypes`

List of checksum types to allow for content operations

Default value: `['sha224', 'sha256', 'sha384', 'sha512']`

##### <a name="-pulpcore--worker_count"></a>`worker_count`

Data type: `Integer[0]`

Number of pulpcore workers. Defaults to 8 or the number of CPU cores, whichever is smaller. Enabling more than 8 workers, even with additional CPU cores
available, likely results in performance degradation due to I/O blocking and is not recommended in most cases. Modifying this parameter should
be done incrementally with benchmarking at each step to determine an optimal value for your deployment.

Default value: `min(8, $facts['processors']['count'])`

##### <a name="-pulpcore--worker_ttl"></a>`worker_ttl`

Data type: `Optional[Integer[0]]`

Configure Pulpcore's WORKER_TTL setting. This is the number of seconds before a Pulpcore worker should be considered lost.
If undefined, the setting will be omitted from the configuration file and Pulpcore will use its default value.
To determine the current value in Pulpcore, see instructions about the diffsettings tool in this module's README.
You should not need to modify this setting unless the application reports workers timing out while they are busy completing tasks.
Modification should be performed incrementally to determine the least value that prevents false positive worker timeouts.

Default value: `undef`

##### <a name="-pulpcore--service_enable"></a>`service_enable`

Data type: `Boolean`

Enable/disable Pulp services at boot.

Default value: `true`

##### <a name="-pulpcore--service_ensure"></a>`service_ensure`

Data type: `Boolean`

Specify if Pulp services should be running or stopped.

Default value: `true`

##### <a name="-pulpcore--content_service_worker_count"></a>`content_service_worker_count`

Data type: `Integer[0]`

Number of pulpcore-content service workers for gunicorn to use.
Modifying this parameter should be done incrementally with benchmarking at each step to determine an optimal value for your deployment.

Default value: `(2*min(8, $facts['processors']['count']) + 1`

##### <a name="-pulpcore--api_service_worker_count"></a>`api_service_worker_count`

Data type: `Integer[0]`

Number of pulpcore-api service workers for gunicorn to use.
Modifying this parameter should be done incrementally with benchmarking at each step to determine an optimal value for your deployment.

Default value: `min(4, $facts['processors']['count']) + 1`

##### <a name="-pulpcore--content_service_worker_timeout"></a>`content_service_worker_timeout`

Data type: `Integer[0]`

Timeout in seconds of the pulpcore-content gunicorn workers.

Default value: `90`

##### <a name="-pulpcore--api_service_worker_timeout"></a>`api_service_worker_timeout`

Data type: `Integer[0]`

Timeout in seconds of the pulpcore-api gunicorn workers.

Default value: `90`

##### <a name="-pulpcore--api_service_worker_max_requests"></a>`api_service_worker_max_requests`

Data type: `Integer[0]`

Number of requests a gunicorn worker will process before restarting.

Default value: `800`

##### <a name="-pulpcore--api_service_worker_max_requests_jitter"></a>`api_service_worker_max_requests_jitter`

Data type: `Integer[0]`

Jitter to add to the max_requests setting of the gunicorn worker.

Default value: `100`

##### <a name="-pulpcore--api_client_auth_cn_map"></a>`api_client_auth_cn_map`

Data type: `Hash[String[1], String[1]]`

Mapping of certificate common name and Pulp user to authenticate to Pulp API.

Default value: `{}`

##### <a name="-pulpcore--cache_enabled"></a>`cache_enabled`

Data type: `Boolean`

Enables Redis based content caching within the Pulp content app.

Default value: `false`

##### <a name="-pulpcore--cache_expires_ttl"></a>`cache_expires_ttl`

Data type: `Optional[Variant[Integer[1], Enum['None']]]`

The number of seconds that content should be cached for. Specify 'None' to never expire the cache.

Default value: `undef`

##### <a name="-pulpcore--log_level"></a>`log_level`

Data type: `Pulpcore::LogLevel`

Sets the log level for the root logger.

Default value: `'INFO'`

##### <a name="-pulpcore--loggers"></a>`loggers`

Data type: `Hash[String[1], Pulpcore::Logger]`

Configure additional loggers or override pre-defined logger configuration.

Default value: `{}`

##### <a name="-pulpcore--analytics"></a>`analytics`

Data type: `Optional[Boolean]`

Configure ANALYTICS in settings.yml, which controls the reporting of anonymous data to https://analytics.pulpproject.org/,
starting with Pulpcore version 3.21.0, to guide Pulp project developers. Set this to false to opt out of this anonymous reporting;
if undef, it will instead be omitted from settings.yml and Pulp will report these usage statistics per its default behavior.
Originally, the pulp setting was called TELEMETRY and this param was called telemetry; it was renamed by the pulp developers.

Default value: `undef`

##### <a name="-pulpcore--hide_guarded_distributions"></a>`hide_guarded_distributions`

Data type: `Optional[Boolean]`

If activated, the distributions that are protected by a content guard will not be shown on the
directory listing in the content app.

Default value: `undef`

##### <a name="-pulpcore--import_workers_percent"></a>`import_workers_percent`

Data type: `Optional[Integer[1,100]]`

What percentage of available-workers will pulpcore use for import tasks at a time.
By default, pulpcore will use all available workers.

Default value: `undef`

### <a name="pulpcore--cli"></a>`pulpcore::cli`

= Pulpcore command line interface

This class installs the Pulpcore command line interface (CLI).

=== Parameters:

$pulpcore_url::       URL on which Pulpcore runs

$username::           Username for authentication

$password::           Password for authentication

$cert::               Client certificate for authentication

$key::                Client key for authentication

=== Advanced parameters:

$manage_root_config:: Whether to manage /root/.config/pulp configuration.

$api_root::           Absolute API base path on server (not including 'api/v3/')

$verify_ssl::         Verify SSL connection

$dry_run::            Trace commands without performing any unsafe HTTP calls

$version::            pulp-cli package version, it's passed to ensure parameter of package resource
                      can be set to specific version number, 'latest', 'present' etc.

#### Parameters

The following parameters are available in the `pulpcore::cli` class:

* [`pulpcore_url`](#-pulpcore--cli--pulpcore_url)
* [`version`](#-pulpcore--cli--version)
* [`username`](#-pulpcore--cli--username)
* [`password`](#-pulpcore--cli--password)
* [`cert`](#-pulpcore--cli--cert)
* [`key`](#-pulpcore--cli--key)
* [`api_root`](#-pulpcore--cli--api_root)
* [`verify_ssl`](#-pulpcore--cli--verify_ssl)
* [`dry_run`](#-pulpcore--cli--dry_run)
* [`manage_root_config`](#-pulpcore--cli--manage_root_config)

##### <a name="-pulpcore--cli--pulpcore_url"></a>`pulpcore_url`

Data type: `Optional[Stdlib::HTTPUrl]`



Default value: `undef`

##### <a name="-pulpcore--cli--version"></a>`version`

Data type: `String`



Default value: `'installed'`

##### <a name="-pulpcore--cli--username"></a>`username`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-pulpcore--cli--password"></a>`password`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-pulpcore--cli--cert"></a>`cert`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-pulpcore--cli--key"></a>`key`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-pulpcore--cli--api_root"></a>`api_root`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-pulpcore--cli--verify_ssl"></a>`verify_ssl`

Data type: `Boolean`



Default value: `true`

##### <a name="-pulpcore--cli--dry_run"></a>`dry_run`

Data type: `Boolean`



Default value: `true`

##### <a name="-pulpcore--cli--manage_root_config"></a>`manage_root_config`

Data type: `Boolean`



Default value: `true`

### <a name="pulpcore--plugin--ansible"></a>`pulpcore::plugin::ansible`

Pulp Ansible plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin::ansible` class:

* [`ansible_galaxy_path`](#-pulpcore--plugin--ansible--ansible_galaxy_path)
* [`permission_classes`](#-pulpcore--plugin--ansible--permission_classes)

##### <a name="-pulpcore--plugin--ansible--ansible_galaxy_path"></a>`ansible_galaxy_path`

Data type: `String`

In the Apache configuration the path to forward to the api app
for ansible galaxy support

Default value: `'/pulp_ansible/galaxy/'`

##### <a name="-pulpcore--plugin--ansible--permission_classes"></a>`permission_classes`

Data type: `Optional[Array[String[1]]]`

Configure the RBAC permission classes

Default value: `undef`

### <a name="pulpcore--plugin--certguard"></a>`pulpcore::plugin::certguard`

Pulp Certguard plugin

### <a name="pulpcore--plugin--container"></a>`pulpcore::plugin::container`

Pulp Container plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin::container` class:

* [`location_prefix`](#-pulpcore--plugin--container--location_prefix)
* [`registry_version_path`](#-pulpcore--plugin--container--registry_version_path)

##### <a name="-pulpcore--plugin--container--location_prefix"></a>`location_prefix`

Data type: `String`

In the Apache configuration a location with this prefix is exposed. The
version (currently v2) will be appended.

Default value: `'/pulpcore_registry'`

##### <a name="-pulpcore--plugin--container--registry_version_path"></a>`registry_version_path`

Data type: `String`

The path beneath the location prefix to forward. This is also appended to
the content base url.

Default value: `'/v2/'`

### <a name="pulpcore--plugin--deb"></a>`pulpcore::plugin::deb`

Pulp Deb plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin::deb` class:

* [`use_pulp2_content_route`](#-pulpcore--plugin--deb--use_pulp2_content_route)
* [`force_ignore_missing_package_indices`](#-pulpcore--plugin--deb--force_ignore_missing_package_indices)

##### <a name="-pulpcore--plugin--deb--use_pulp2_content_route"></a>`use_pulp2_content_route`

Data type: `Boolean`

Whether to redirect the legacy (Pulp 2) URL, /pulp/deb/, to the content server

Default value: `false`

##### <a name="-pulpcore--plugin--deb--force_ignore_missing_package_indices"></a>`force_ignore_missing_package_indices`

Data type: `Boolean`

Wheter to set the FORCE_IGNORE_MISSING_PACKAGE_INDICES setting to True or
False in /etc/pulp/settings.py.

Default value: `true`

### <a name="pulpcore--plugin--file"></a>`pulpcore::plugin::file`

Pulp File plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin::file` class:

* [`use_pulp2_content_route`](#-pulpcore--plugin--file--use_pulp2_content_route)

##### <a name="-pulpcore--plugin--file--use_pulp2_content_route"></a>`use_pulp2_content_route`

Data type: `Boolean`

Whether to redirect the legacy (Pulp 2) URLs to the content server

Default value: `false`

### <a name="pulpcore--plugin--ostree"></a>`pulpcore::plugin::ostree`

Pulp Ostree plugin

### <a name="pulpcore--plugin--python"></a>`pulpcore::plugin::python`

Pulp Python plugin

### <a name="pulpcore--plugin--rpm"></a>`pulpcore::plugin::rpm`

Pulp RPM plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin::rpm` class:

* [`use_pulp2_content_route`](#-pulpcore--plugin--rpm--use_pulp2_content_route)
* [`keep_changelog_limit`](#-pulpcore--plugin--rpm--keep_changelog_limit)
* [`allow_automatic_unsafe_advisory_conflict_resolution`](#-pulpcore--plugin--rpm--allow_automatic_unsafe_advisory_conflict_resolution)

##### <a name="-pulpcore--plugin--rpm--use_pulp2_content_route"></a>`use_pulp2_content_route`

Data type: `Boolean`

Whether to redirect the legacy (Pulp 2) URLs to the content server

Default value: `false`

##### <a name="-pulpcore--plugin--rpm--keep_changelog_limit"></a>`keep_changelog_limit`

Data type: `Optional[Integer[0]]`

Pulpcore's KEEP_CHANGELOG_LIMIT setting. Uses Pulpcore's default when
undefined. Increasing this limit will cause pulpcore workers to use more
memory when more changelogs are available in the repo metadata.

Default value: `undef`

##### <a name="-pulpcore--plugin--rpm--allow_automatic_unsafe_advisory_conflict_resolution"></a>`allow_automatic_unsafe_advisory_conflict_resolution`

Data type: `Boolean`

Allow resolving of conflicts due to duplicate advisory ids with different creation dates
https://docs.pulpproject.org/pulp_rpm/settings.html#allow-automatic-unsafe-advisory-conflict-resolution

Default value: `false`

### <a name="pulpcore--repo"></a>`pulpcore::repo`

Configure the Pulpcore repo

#### Parameters

The following parameters are available in the `pulpcore::repo` class:

* [`version`](#-pulpcore--repo--version)
* [`baseurl`](#-pulpcore--repo--baseurl)
* [`gpgkey`](#-pulpcore--repo--gpgkey)

##### <a name="-pulpcore--repo--version"></a>`version`

Data type: `Variant[Enum['nightly'], Pattern['^\d+\.\d+$']]`

The Pulpcore version to use

Default value: `'3.39'`

##### <a name="-pulpcore--repo--baseurl"></a>`baseurl`

Data type: `Optional[Stdlib::HTTPUrl]`

An optional base URL to be used for yumrepo, instead of the default

Default value: `undef`

##### <a name="-pulpcore--repo--gpgkey"></a>`gpgkey`

Data type: `Optional[String[0]]`

An optional value for gpgkey to be used for yumrepo, instead of the default.
If an empty string is passed, gpgcheck will be disabled.

Default value: `undef`

## Defined types

### <a name="pulpcore--admin"></a>`pulpcore::admin`

Run a pulpcore-manager command

* **See also**
  * exec

#### Parameters

The following parameters are available in the `pulpcore::admin` defined type:

* [`command`](#-pulpcore--admin--command)
* [`refreshonly`](#-pulpcore--admin--refreshonly)
* [`unless`](#-pulpcore--admin--unless)
* [`path`](#-pulpcore--admin--path)
* [`user`](#-pulpcore--admin--user)
* [`pulp_settings`](#-pulpcore--admin--pulp_settings)
* [`timeout`](#-pulpcore--admin--timeout)
* [`working_dir`](#-pulpcore--admin--working_dir)

##### <a name="-pulpcore--admin--command"></a>`command`

Data type: `String`

The command to run

Default value: `$title`

##### <a name="-pulpcore--admin--refreshonly"></a>`refreshonly`

Data type: `Boolean`

The command should only be run as a refresh mechanism for when a dependent
object is changed.

Default value: `false`

##### <a name="-pulpcore--admin--unless"></a>`unless`

Data type: `Optional[String]`

A test command that checks the state of the target system and restricts
when the exec can run.

Default value: `undef`

##### <a name="-pulpcore--admin--path"></a>`path`

Data type: `Array[Stdlib::Absolutepath]`

The path to look for commands.

Default value: `['/usr/bin']`

##### <a name="-pulpcore--admin--user"></a>`user`

Data type: `String`

The user to execute the command.

Default value: `$pulpcore::user`

##### <a name="-pulpcore--admin--pulp_settings"></a>`pulp_settings`

Data type: `Stdlib::Absolutepath`

Root directory for static content

Default value: `$pulpcore::settings_file`

##### <a name="-pulpcore--admin--timeout"></a>`timeout`

Data type: `Optional[Integer[0]]`

The command should timeout after so many seconds.

Default value: `undef`

##### <a name="-pulpcore--admin--working_dir"></a>`working_dir`

Data type: `Stdlib::Absolutepath`

The directory to run pulpcore-manager from.

Default value: `$pulpcore::user_home`

### <a name="pulpcore--plugin"></a>`pulpcore::plugin`

Install a plugin

#### Parameters

The following parameters are available in the `pulpcore::plugin` defined type:

* [`package_name`](#-pulpcore--plugin--package_name)
* [`config`](#-pulpcore--plugin--config)
* [`http_content`](#-pulpcore--plugin--http_content)
* [`https_content`](#-pulpcore--plugin--https_content)

##### <a name="-pulpcore--plugin--package_name"></a>`package_name`

Data type: `String`

The package name to install

Default value: `"pulpcore-plugin(${title})"`

##### <a name="-pulpcore--plugin--config"></a>`config`

Data type: `Optional[String]`

An optional config in the Pulp settings file

Default value: `undef`

##### <a name="-pulpcore--plugin--http_content"></a>`http_content`

Data type: `Optional[String]`

Optional fragment for the Apache HTTP vhost

Default value: `undef`

##### <a name="-pulpcore--plugin--https_content"></a>`https_content`

Data type: `Optional[String]`

Optional fragment for the Apache HTTPS vhost

Default value: `undef`

## Data types

### <a name="Pulpcore--ChecksumTypes"></a>`Pulpcore::ChecksumTypes`

The supported checksum types by pulpcore

Alias of `Array[Enum['md5', 'sha1', 'sha224', 'sha256', 'sha384', 'sha512'], 1]`

### <a name="Pulpcore--LogLevel"></a>`Pulpcore::LogLevel`

The Pulpcore::LogLevel data type.

Alias of `Enum['CRITICAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG']`

### <a name="Pulpcore--Logger"></a>`Pulpcore::Logger`

The Pulpcore::Logger data type.

Alias of

```puppet
Struct[{
  level => Pulpcore::LogLevel,
}]
```

