# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`podman`](#podman): Manage containers, pods, volumes, and images with podman without a docker daemon

#### Private Classes

* `podman::install`: Install podman packages
* `podman::options`: edit container options in /etc/containers
* `podman::service`: Manage the podman.socket service

### Defined types

* [`podman::container`](#podman--container): manage podman container and register as a systemd service
* [`podman::image`](#podman--image): pull or remove container images
* [`podman::network`](#podman--network): Create a podman network with defined flags
* [`podman::pod`](#podman--pod): Create a podman pod with defined flags
* [`podman::quadlet`](#podman--quadlet): manage podman quadlets
* [`podman::rootless`](#podman--rootless): Enable a given user to run rootless podman containers as a systemd user service.
* [`podman::secret`](#podman--secret): Manage a podman secret. Create and remove secrets, it cannot replace.
* [`podman::subgid`](#podman--subgid): Define an entry in the `/etc/subgid` file.
* [`podman::subuid`](#podman--subuid): Manage entries in `/etc/subuid`
* [`podman::volume`](#podman--volume): Create a podman volume with defined flags

## Classes

### <a name="podman"></a>`podman`

Manage containers, pods, volumes, and images with podman without a docker daemon

#### Examples

##### Basic usage

```puppet
include podman
```

##### A rootless Jenkins deployment using hiera

```puppet
podman::subid:
  jenkins:
    subuid: 2000000
    count: 65535
podman::volumes:
  jenkins:
    user: jenkins
podman::containers:
  jenkins:
    user: jenkins
    image: 'docker.io/jenkins/jenkins:lts'
    flags:
      label:
        - purpose=test
      publish:
        - '8080:8080'
        - '50000:50000'
      volume: 'jenkins:/var/jenkins_home'
    service_flags:
      timeout: '60'
    require:
      - Podman::Volume[jenkins]
```

#### Parameters

The following parameters are available in the `podman` class:

* [`podman_pkg`](#-podman--podman_pkg)
* [`skopeo_pkg`](#-podman--skopeo_pkg)
* [`buildah_pkg`](#-podman--buildah_pkg)
* [`podman_docker_pkg`](#-podman--podman_docker_pkg)
* [`compose_pkg`](#-podman--compose_pkg)
* [`machinectl_pkg`](#-podman--machinectl_pkg)
* [`podman_pkg_ensure`](#-podman--podman_pkg_ensure)
* [`buildah_pkg_ensure`](#-podman--buildah_pkg_ensure)
* [`podman_docker_pkg_ensure`](#-podman--podman_docker_pkg_ensure)
* [`compose_pkg_ensure`](#-podman--compose_pkg_ensure)
* [`machinectl_pkg_ensure`](#-podman--machinectl_pkg_ensure)
* [`nodocker`](#-podman--nodocker)
* [`storage_options`](#-podman--storage_options)
* [`containers_options`](#-podman--containers_options)
* [`rootless_users`](#-podman--rootless_users)
* [`enable_api_socket`](#-podman--enable_api_socket)
* [`manage_subuid`](#-podman--manage_subuid)
* [`file_header`](#-podman--file_header)
* [`match_subuid_subgid`](#-podman--match_subuid_subgid)
* [`subid`](#-podman--subid)
* [`pods`](#-podman--pods)
* [`volumes`](#-podman--volumes)
* [`images`](#-podman--images)
* [`containers`](#-podman--containers)
* [`networks`](#-podman--networks)
* [`quadlets`](#-podman--quadlets)

##### <a name="-podman--podman_pkg"></a>`podman_pkg`

Data type: `String`

The name of the podman package (default 'podman')

Default value: `'podman'`

##### <a name="-podman--skopeo_pkg"></a>`skopeo_pkg`

Data type: `String`

The name of the skopeo package (default 'skopeo')

Default value: `'skopeo'`

##### <a name="-podman--buildah_pkg"></a>`buildah_pkg`

Data type: `String`

The name of the buildah package (default 'buildah')

Default value: `'buildah'`

##### <a name="-podman--podman_docker_pkg"></a>`podman_docker_pkg`

Data type: `String`

The name of the podman-docker package (default 'podman-docker').

Default value: `'podman-docker'`

##### <a name="-podman--compose_pkg"></a>`compose_pkg`

Data type: `String`

The name of the podman-compose package (default 'podman-compose').

Default value: `'podman-compose'`

##### <a name="-podman--machinectl_pkg"></a>`machinectl_pkg`

Data type: `String`

The name of the machinectl package (default 'systemd-container').

Default value: `'systemd-container'`

##### <a name="-podman--podman_pkg_ensure"></a>`podman_pkg_ensure`

Data type: `Pattern[/^(\d+\.){2}\d+$/, /absent/, /installed/]`

The ensure value for the podman package (default 'installed')

Default value: `'installed'`

##### <a name="-podman--buildah_pkg_ensure"></a>`buildah_pkg_ensure`

Data type: `Enum['absent', 'installed']`

The ensure value for the buildah package (default 'absent')

Default value: `'absent'`

##### <a name="-podman--podman_docker_pkg_ensure"></a>`podman_docker_pkg_ensure`

Data type: `Enum['absent', 'installed']`

The ensure value for the podman docker package (default 'installed')

Default value: `'installed'`

##### <a name="-podman--compose_pkg_ensure"></a>`compose_pkg_ensure`

Data type: `Pattern[/^(\d+\.){2}\d+$/, /absent/, /installed/]`

The ensure value for the podman-compose package (default 'absent')

Default value: `'absent'`

##### <a name="-podman--machinectl_pkg_ensure"></a>`machinectl_pkg_ensure`

Data type: `Enum['absent', 'installed']`

The ensure value for the machinectl package (default 'installed')

Default value: `'installed'`

##### <a name="-podman--nodocker"></a>`nodocker`

Data type: `Enum['absent', 'file']`

Should the module create the `/etc/containers/nodocker` file to quiet Docker CLI messages.
Values should be either 'file' or 'absent'. (default is 'absent')

Default value: `'absent'`

##### <a name="-podman--storage_options"></a>`storage_options`

Data type: `Hash`

A hash containing any storage options you wish to set in /etc/containers/storage.conf

Default value: `{}`

##### <a name="-podman--containers_options"></a>`containers_options`

Data type: `Hash`

A hash containing any containers options you wish to set in /etc/containers/containers.conf

Default value: `{}`

##### <a name="-podman--rootless_users"></a>`rootless_users`

Data type: `Array`

An array of users to manage using [`podman::rootless`](#podmanrootless)

Default value: `[]`

##### <a name="-podman--enable_api_socket"></a>`enable_api_socket`

Data type: `Boolean`

The enable value of the API socket (default `false`)

Default value: `false`

##### <a name="-podman--manage_subuid"></a>`manage_subuid`

Data type: `Boolean`

Should the module manage the `/etc/subuid` and `/etc/subgid` files (default is false)
The implementation uses [concat](https://forge.puppet.com/puppetlabs/concat) fragments to build
out the subuid/subgid entries.  If you have a large number of entries you may want to manage them
with another method.  You cannot use the `subuid` and `subgid` defined types unless this is `true`.

Default value: `false`

##### <a name="-podman--file_header"></a>`file_header`

Data type: `String`

Optional header when `manage_subuid` is true.  Ensure you include a leading `#`.
Default file_header is `# FILE MANAGED BY PUPPET`

Default value: `'# FILE MANAGED BY PUPPET'`

##### <a name="-podman--match_subuid_subgid"></a>`match_subuid_subgid`

Data type: `Boolean`

Enable the `subid` parameter to manage both subuid and subgid entries with the same values.
This setting requires `manage_subuid` to be `true` or it will have no effect.
(default is true)

Default value: `true`

##### <a name="-podman--subid"></a>`subid`

Data type: `Hash`

A hash of users (or UIDs) with assigned subordinate user ID number and an count.
Implemented by using the `subuid` and `subgid` defined types with the same data.
Hash key `subuid` is the subordinate UID, and `count` is the number of subordinate UIDs

Default value: `{}`

##### <a name="-podman--pods"></a>`pods`

Data type: `Hash`

A hash of pods to manage using [`podman::pod`](#podmanpod)

Default value: `{}`

##### <a name="-podman--volumes"></a>`volumes`

Data type: `Hash`

A hash of volumes to manage using [`podman::volume`](#podmanvolume)

Default value: `{}`

##### <a name="-podman--images"></a>`images`

Data type: `Hash`

A hash of images to manage using [`podman::image`](#podmanimage)

Default value: `{}`

##### <a name="-podman--containers"></a>`containers`

Data type: `Hash`

A hash of containers to manage using [`podman::container`](#podmancontainer)

Default value: `{}`

##### <a name="-podman--networks"></a>`networks`

Data type: `Hash`

A hash of networks to manage using [`podman::network`](#podmannetwork)

Default value: `{}`

##### <a name="-podman--quadlets"></a>`quadlets`

Data type: `Hash`

A hash of quadlets to manage using [`podman::quadlet`](#podmanquadlet)

Default value: `{}`

## Defined types

### <a name="podman--container"></a>`podman::container`

manage podman container and register as a systemd service

#### Examples

##### 

```puppet
podman::container { 'jenkins':
  image         => 'docker.io/jenkins/jenkins',
  user          => 'jenkins',
  flags         => {
                   publish => [
                              '8080:8080',
                              '50000:50000',
                              ],
                   volume  => 'jenkins:/var/jenkins_home',
                   },
  service_flags => { timeout => '60' },
}
```

#### Parameters

The following parameters are available in the `podman::container` defined type:

* [`image`](#-podman--container--image)
* [`user`](#-podman--container--user)
* [`flags`](#-podman--container--flags)
* [`service_flags`](#-podman--container--service_flags)
* [`command`](#-podman--container--command)
* [`ensure`](#-podman--container--ensure)
* [`enable`](#-podman--container--enable)
* [`update`](#-podman--container--update)
* [`ruby`](#-podman--container--ruby)

##### <a name="-podman--container--image"></a>`image`

Data type: `Optional[String]`

Container registry source of the image being deployed.  Required when
`ensure` is `present` but optional when `ensure` is set to `absent`.

Default value: `undef`

##### <a name="-podman--container--user"></a>`user`

Data type: `Optional[String]`

Optional user for running rootless containers.  For rootless containers,
the user must also be defined as a puppet resource that includes at least
'uid', 'gid', and 'home' attributes.

Default value: `undef`

##### <a name="-podman--container--flags"></a>`flags`

Data type: `Hash`

All flags for the 'podman container create' command are supported via the
'flags' hash parameter, using only the long form of the flag name.  The
container name will be set as the resource name (namevar) unless the 'name'
flag is included in the flags hash.  If the flags for a container resource
are modified the container will be destroyed and re-deployed during the
next puppet run.  This is achieved by storing the complete set of flags as
a base64 encoded string in a container label named `puppet_resource_flags`
so it can be compared with the assigned resource state.
Flags that can be used more than once should be expressed as an array.  For
flags which take no arguments, set the hash value to be undef. In the
YAML representation you can use `~` or `null` as the value.

Default value: `{}`

##### <a name="-podman--container--service_flags"></a>`service_flags`

Data type: `Hash`

When a container is created, a systemd unit file for the container service
is generated using the 'podman generate systemd' command.  All flags for the
command are supported using the 'service_flags' hash parameter, again using
only the long form of the flag names.

Default value: `{}`

##### <a name="-podman--container--command"></a>`command`

Data type: `Optional[String]`

Optional command to be used as the container entry point.

Default value: `undef`

##### <a name="-podman--container--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Valid values are 'present' or 'absent'

Default value: `'present'`

##### <a name="-podman--container--enable"></a>`enable`

Data type: `Boolean`

Status of the automatically generated systemd service for the container.
Valid values are 'running' or 'stopped'.

Default value: `true`

##### <a name="-podman--container--update"></a>`update`

Data type: `Boolean`

When `true`, the container will be redeployed when a new container image is
detected in the container registry.  This is done by comparing the digest
value of the running container image with the digest of the registry image.
When `false`, the container will only be redeployed when the declared state
of the puppet resource is changed.

Default value: `true`

##### <a name="-podman--container--ruby"></a>`ruby`

Data type: `Optional[Stdlib::Unixpath]`

The absolute path to the ruby binary to use in scripts. The default path is
'/opt/puppetlabs/puppet/bin/ruby' for Puppetlabs packaged puppet, and
'/usr/bin/ruby' for all others.

Default value: `undef`

### <a name="podman--image"></a>`podman::image`

pull or remove container images

#### Examples

##### 

```puppet
podman::image { 'my_container':
  image => 'my_container:tag',
  flags => {
           creds => 'USERNAME:PASSWORD',
           },
}
```

#### Parameters

The following parameters are available in the `podman::image` defined type:

* [`image`](#-podman--image--image)
* [`ensure`](#-podman--image--ensure)
* [`flags`](#-podman--image--flags)
* [`user`](#-podman--image--user)
* [`exec_env`](#-podman--image--exec_env)

##### <a name="-podman--image--image"></a>`image`

Data type: `String`

The name of the container image to pull, which should be present in a
configured container registry.

##### <a name="-podman--image--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the resource must be either `present` or `absent`.

Default value: `'present'`

##### <a name="-podman--image--flags"></a>`flags`

Data type: `Hash`

All flags for the 'podman image pull' command are supported, using only the
long form of the flag name.

Default value: `{}`

##### <a name="-podman--image--user"></a>`user`

Data type: `Optional[String]`

Optional user for running rootless containers.  When using this parameter,
the user must also be defined as a Puppet resource and must include the
'uid', 'gid', and 'home'

Default value: `undef`

##### <a name="-podman--image--exec_env"></a>`exec_env`

Data type: `Array`

Optional array of environment variables used when the container image is
pulled.  Useful for defining a proxy for downloads. For example:
["HTTP_PROXY=http://${proxy_fqdn}:3128", "HTTPS_PROXY=http://${proxy_fqdn}:3128"]

Default value: `[]`

### <a name="podman--network"></a>`podman::network`

Create a podman network with defined flags

#### Examples

##### 

```puppet
podman::network { 'mnetwork':
  driver   => 'bridge',
  internal => true,
}
```

#### Parameters

The following parameters are available in the `podman::network` defined type:

* [`ensure`](#-podman--network--ensure)
* [`disable_dns`](#-podman--network--disable_dns)
* [`driver`](#-podman--network--driver)
* [`opts`](#-podman--network--opts)
* [`gateway`](#-podman--network--gateway)
* [`internal`](#-podman--network--internal)
* [`ip_range`](#-podman--network--ip_range)
* [`labels`](#-podman--network--labels)
* [`subnet`](#-podman--network--subnet)
* [`ipv6`](#-podman--network--ipv6)
* [`user`](#-podman--network--user)

##### <a name="-podman--network--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the resource must be either 'present' or 'absent'.

Default value: `'present'`

##### <a name="-podman--network--disable_dns"></a>`disable_dns`

Data type: `Boolean`

Disables the DNS plugin for this network which if enabled, can perform container
to container name resolution.

Default value: `false`

##### <a name="-podman--network--driver"></a>`driver`

Data type: `Enum['bridge', 'macvlan']`

Driver to manage the network.

Default value: `'bridge'`

##### <a name="-podman--network--opts"></a>`opts`

Data type: `Array[String]`

A list of driver specific options.

Default value: `[]`

##### <a name="-podman--network--gateway"></a>`gateway`

Data type: `Optional[String]`

Define the gateway for the network. Must also provide the subnet.

Default value: `undef`

##### <a name="-podman--network--internal"></a>`internal`

Data type: `Boolean`

Restrict external access of this network.

Default value: `false`

##### <a name="-podman--network--ip_range"></a>`ip_range`

Data type: `Optional[String]`

Allocate container IP from a range. The range must be a complete subnet and in
CIDR notation.

Default value: `undef`

##### <a name="-podman--network--labels"></a>`labels`

Data type: `Hash[String,String]`

A hash of metadata labels to set on the network.

Default value: `{}`

##### <a name="-podman--network--subnet"></a>`subnet`

Data type: `Optional[String]`

The subnet in CIDR notation

Default value: `undef`

##### <a name="-podman--network--ipv6"></a>`ipv6`

Data type: `Boolean`

Enable IPv6 (dual-stack) networking.

Default value: `false`

##### <a name="-podman--network--user"></a>`user`

Data type: `Optional[String]`

Optional user for creating rootless container networks.  For rootless containers,
the user must also be defined as a puppet resource that includes at least
'uid', 'gid', and 'home' attributes.

Default value: `undef`

### <a name="podman--pod"></a>`podman::pod`

Create a podman pod with defined flags

#### Examples

##### 

```puppet
podman::pod { 'mypod':
  flags => {
           label => 'use=test, app=wordpress',
           }
}
```

#### Parameters

The following parameters are available in the `podman::pod` defined type:

* [`ensure`](#-podman--pod--ensure)
* [`flags`](#-podman--pod--flags)
* [`user`](#-podman--pod--user)

##### <a name="-podman--pod--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the resource, which must be either 'present' or 'absent'.

Default value: `'present'`

##### <a name="-podman--pod--flags"></a>`flags`

Data type: `Hash`

All flags for the 'podman pod create' command are supported, using only the
long form of the flag name.  The resource name (namevar) will be used as the
pod name unless the 'name' flag is included in the hash of flags.

Default value: `{}`

##### <a name="-podman--pod--user"></a>`user`

Data type: `Optional[String]`

Optional user for running rootless containers.  When using this parameter,
the user must also be defined as a Puppet resource and must include the
'uid', 'gid', and 'home'

Default value: `undef`

### <a name="podman--quadlet"></a>`podman::quadlet`

manage podman quadlets

#### Examples

##### 

```puppet
podman::quadlet { 'jenkins':
  user     => 'jenkins',
  settings => {
    Unit => {
      Description => "Jenkins container",
    },
    Container => {
      Image       => 'docker.io/jenkins/jenkins:latest',
      PublishPort => [
        '5000:5000',
        '8080:8080',
      ],
      Volume      => 'jenkins:/var/jenkins_home',
    },
    Service => {
      TimeoutStartSec => '300',
    },
  },
}
```

#### Parameters

The following parameters are available in the `podman::quadlet` defined type:

* [`ensure`](#-podman--quadlet--ensure)
* [`user`](#-podman--quadlet--user)
* [`quadlet_type`](#-podman--quadlet--quadlet_type)
* [`settings`](#-podman--quadlet--settings)
* [`defaults`](#-podman--quadlet--defaults)

##### <a name="-podman--quadlet--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Valid values are 'present' or 'absent'

Default value: `'present'`

##### <a name="-podman--quadlet--user"></a>`user`

Data type: `String`

A username for running rootless containers.  The user must also be defined as
a puppet resource that includes at least 'uid', 'gid', and 'home' attributes.
The default value is "root" and results in root containers and resources.

Default value: `'root'`

##### <a name="-podman--quadlet--quadlet_type"></a>`quadlet_type`

Data type:

```puppet
Enum['container',
    'volume',
    'network',
    'build',
    'pod',
    'kube'
  ]
```

Must be one of the supported quadlet types: "container", "volume", "network",
"build", "pod", or "kube".  Default is "container"

Default value: `'container'`

##### <a name="-podman--quadlet--settings"></a>`settings`

Data type: `Hash`

A hash that represents the systemd unit file that will be managed for the podman
quadlet.  No sanity checking is done on this hash, so invalid values can result
in a service that fails to start, but this also allows full configuration of any
service or container setting now and in the future without needed to go back
and update the module.

Default value: `{}`

##### <a name="-podman--quadlet--defaults"></a>`defaults`

Data type: `Hash`

A hash of values that's merged with settings to simplify module
usage.  This allows running a container with nothing but an image defined.
See the "data/common.yaml" file for default values.

Default value: `{}`

### <a name="podman--rootless"></a>`podman::rootless`

Enable a given user to run rootless podman containers as a systemd user service.

### <a name="podman--secret"></a>`podman::secret`

Manage a podman secret. Create and remove secrets, it cannot replace.

#### Examples

##### Set a secret with a version from puppet directly

```puppet
podman::secret{'db_password':
  secret => Sensitive('NeverGuess'),
  flags  => {
    label => [
      'version=20230615',
    ]
  }
}
```

##### Set a secret from a file

```puppet
podman::secret{'db_password':
  path => '/etc/passwd',
}
```

##### Set a secret from a deferred function call.

```puppet
podman::secret{'ora_password':
  secret => Sensitive(Deferred('secret_lookup',['ora_password'])),
  flags => {
    labels => ['version=20230615'],
  }
  user => 'rootless user',
}
```

#### Parameters

The following parameters are available in the `podman::secret` defined type:

* [`ensure`](#-podman--secret--ensure)
* [`path`](#-podman--secret--path)
* [`secret`](#-podman--secret--secret)
* [`flags`](#-podman--secret--flags)
* [`user`](#-podman--secret--user)

##### <a name="-podman--secret--ensure"></a>`ensure`

Data type: `Enum['present','absent']`

State of the resource must be either 'present' or 'absent'.

Default value: `'present'`

##### <a name="-podman--secret--path"></a>`path`

Data type: `Optional[Stdlib::Unixpath]`

Load secret from an existing file path
The secret and path parameters are mutually exclusive.

Default value: `undef`

##### <a name="-podman--secret--secret"></a>`secret`

Data type: `Optional[Sensitive[String]]`

A secret to be stored - can be set as a Deferred function. If the secret is
changed the secret will **NOT** be modified. Best to set a secret version
as a label.
The secret and path parameters are mutually exclusive.

Default value: `undef`

##### <a name="-podman--secret--flags"></a>`flags`

Data type: `Hash`

All flags for the 'podman secret create' command are supported as part of the
'flags' hash, using only the long form of the flag name.  The value for any
defined flag in the 'flags' hash must be entered as a string.
If the flags for a secret are modified the secret will be recreated.

Default value: `{}`

##### <a name="-podman--secret--user"></a>`user`

Data type: `Optional[String[1]]`

Optional user for running rootless containers.  When using this parameter,
the user must also be defined as a Puppet resource and must include the
'uid', 'gid', and 'home'

Default value: `undef`

### <a name="podman--subgid"></a>`podman::subgid`

Define an entry in the `/etc/subgid` file.

#### Examples

##### 

```puppet
podman::subgid { 'myuser':
  subgid => 1000000
  count  => 65535
}
```

#### Parameters

The following parameters are available in the `podman::subgid` defined type:

* [`subgid`](#-podman--subgid--subgid)
* [`count`](#-podman--subgid--count)
* [`order`](#-podman--subgid--order)

##### <a name="-podman--subgid--subgid"></a>`subgid`

Data type: `Integer`

Numerical subordinate group ID

##### <a name="-podman--subgid--count"></a>`count`

Data type: `Integer`

Numerical subordinate group ID count

##### <a name="-podman--subgid--order"></a>`order`

Data type: `Integer`

Sequence number for concat fragments#

Default value: `10`

### <a name="podman--subuid"></a>`podman::subuid`

Manage entries in `/etc/subuid`

#### Examples

##### 

```puppet
podman::subuid { 'namevar':
  subuid => 1000000
  count  => 65535
}
```

#### Parameters

The following parameters are available in the `podman::subuid` defined type:

* [`subuid`](#-podman--subuid--subuid)
* [`count`](#-podman--subuid--count)
* [`order`](#-podman--subuid--order)

##### <a name="-podman--subuid--subuid"></a>`subuid`

Data type: `Integer`

Numerical subordinate user ID

##### <a name="-podman--subuid--count"></a>`count`

Data type: `Integer`

Numerical subordinate user ID count

##### <a name="-podman--subuid--order"></a>`order`

Data type: `Integer`

Sequence number for concat fragments

Default value: `10`

### <a name="podman--volume"></a>`podman::volume`

Create a podman volume with defined flags

#### Examples

##### 

```puppet
podman::volume { 'myvolume':
  flags => {
    label => 'use=test, app=wordpress',
  }
}
```

#### Parameters

The following parameters are available in the `podman::volume` defined type:

* [`ensure`](#-podman--volume--ensure)
* [`flags`](#-podman--volume--flags)
* [`user`](#-podman--volume--user)

##### <a name="-podman--volume--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the resource must be either 'present' or 'absent'.

Default value: `'present'`

##### <a name="-podman--volume--flags"></a>`flags`

Data type: `Hash`

All flags for the 'podman volume create' command are supported as part of the
'flags' hash, using only the long form of the flag name.  The value for any
defined flag in the 'flags' hash must be entered as a string.
Volume names are created based on the resoure title (namevar)

Default value: `{}`

##### <a name="-podman--volume--user"></a>`user`

Data type: `Optional[String]`

Optional user for running rootless containers.  When using this parameter,
the user must also be defined as a Puppet resource and must include the
'uid', 'gid', and 'home'

Default value: `undef`

