# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`systemd`](#systemd): This module allows triggering systemd commands once for all modules
* [`systemd::tmpfiles`](#systemd--tmpfiles): Update the systemd temp files

#### Private Classes

* `systemd::coredump`: This class manages the systemd-coredump configuration.
* `systemd::install`: Install any systemd sub packages
* `systemd::journald`: This class manages and configures journald.
* `systemd::logind`: This class manages systemd's login manager configuration.
* `systemd::machine_info`: This class manages systemd's machine-info file (hostnamectl)
* `systemd::modules_loads`: Activate the modules contained in modules-loads.d
* `systemd::networkd`: This class provides an abstract way to trigger systemd-networkd
* `systemd::oomd`: This class manages and configures oomd.
* `systemd::resolved`: This class provides an abstract way to trigger resolved.
* `systemd::system`: This class provides a solution to enable accounting
* `systemd::timedatectl`: This class provides an abstract way to set elements with timedatectl
* `systemd::timesyncd`: This class provides an abstract way to trigger systemd-timesyncd
* `systemd::udevd`: This class manages systemd's udev config

### Defined types

* [`systemd::daemon_reload`](#systemd--daemon_reload): Run systemctl daemon-reload
* [`systemd::dropin_file`](#systemd--dropin_file): Creates a drop-in file for a systemd unit
* [`systemd::manage_dropin`](#systemd--manage_dropin): Creates a drop-in file for a systemd unit from a template
* [`systemd::manage_unit`](#systemd--manage_unit): Generate unit file from template
* [`systemd::modules_load`](#systemd--modules_load): Creates a modules-load.d drop file
* [`systemd::network`](#systemd--network): Creates network config for systemd-networkd
* [`systemd::service_limits`](#systemd--service_limits): Deprecated - Adds a set of custom limits to the service
* [`systemd::timer`](#systemd--timer): Create a timer and optionally a service unit to execute with the timer unit
* [`systemd::timer_wrapper`](#systemd--timer_wrapper): Helper to define timer and accompanying services for a given task (cron like interface).
* [`systemd::tmpfile`](#systemd--tmpfile): Creates a systemd tmpfile
* [`systemd::udev::rule`](#systemd--udev--rule): Adds a custom udev rule
* [`systemd::unit_file`](#systemd--unit_file): Creates a systemd unit file
* [`systemd::user_service`](#systemd--user_service): Manage a user service running under systemd --user

### Resource types

* [`loginctl_user`](#loginctl_user): An arbitrary name used as the identity of the resource.

### Functions

* [`systemd::escape`](#systemd--escape): Escape strings as systemd-escape does.
* [`systemd::systemd_escape`](#systemd--systemd_escape): Escape strings by call the `systemd-escape` command in the background.

### Data types

* [`Systemd::CoredumpSettings`](#Systemd--CoredumpSettings): Configurations for coredump.conf
* [`Systemd::Dropin`](#Systemd--Dropin): custom datatype that validates filenames/paths for valid systemd dropin files
* [`Systemd::JournaldSettings`](#Systemd--JournaldSettings): Matches Systemd journald config Struct
* [`Systemd::JournaldSettings::Ensure`](#Systemd--JournaldSettings--Ensure): defines allowed ensure states for systemd-journald settings
* [`Systemd::LogindSettings`](#Systemd--LogindSettings): Matches Systemd Login Manager Struct
* [`Systemd::LogindSettings::Ensure`](#Systemd--LogindSettings--Ensure): defines allowed ensure states for systemd-logind settings
* [`Systemd::MachineInfoSettings`](#Systemd--MachineInfoSettings): Matches Systemd machine-info (hostnamectl) file Struct
* [`Systemd::OomdSettings`](#Systemd--OomdSettings): Configurations for oomd.conf
* [`Systemd::ServiceLimits`](#Systemd--ServiceLimits): Deprecated - Matches Systemd Service Limit Struct
* [`Systemd::Unit`](#Systemd--Unit): custom datatype that validates different filenames for systemd units and unit templates
* [`Systemd::Unit::Amount`](#Systemd--Unit--Amount): Systemd definition of amount, often bytes or united bytes
* [`Systemd::Unit::AmountOrPercent`](#Systemd--Unit--AmountOrPercent): Systemd definition of amount, often bytes or united bytes
* [`Systemd::Unit::Install`](#Systemd--Unit--Install): Possible keys for the [Install] section of a unit file
* [`Systemd::Unit::Path`](#Systemd--Unit--Path): Possible keys for the [Path] section of a unit file
* [`Systemd::Unit::Percent`](#Systemd--Unit--Percent): Systemd definition of a percentage
* [`Systemd::Unit::Service`](#Systemd--Unit--Service): Possible keys for the [Service] section of a unit file
* [`Systemd::Unit::Service::Exec`](#Systemd--Unit--Service--Exec): Possible strings for ExecStart, ExecStartPrep, ...
* [`Systemd::Unit::Slice`](#Systemd--Unit--Slice): Possible keys for the [Slice] section of a unit file
* [`Systemd::Unit::Socket`](#Systemd--Unit--Socket): Possible keys for the [Socket] section of a unit file
* [`Systemd::Unit::Timer`](#Systemd--Unit--Timer): Possible keys for the [Timer] section of a unit file
* [`Systemd::Unit::Timespan`](#Systemd--Unit--Timespan): Timer specification for systemd time spans, e.g. timers.
* [`Systemd::Unit::Unit`](#Systemd--Unit--Unit): Possible keys for the [Unit] section of a unit file

### Tasks

* [`systemctl_show`](#systemctl_show): Get systemctl show output of a unit

## Classes

### <a name="systemd"></a>`systemd`

This module allows triggering systemd commands once for all modules

#### Parameters

The following parameters are available in the `systemd` class:

* [`default_target`](#-systemd--default_target)
* [`service_limits`](#-systemd--service_limits)
* [`networks`](#-systemd--networks)
* [`timers`](#-systemd--timers)
* [`tmpfiles`](#-systemd--tmpfiles)
* [`unit_files`](#-systemd--unit_files)
* [`manage_resolved`](#-systemd--manage_resolved)
* [`resolved_ensure`](#-systemd--resolved_ensure)
* [`resolved_package`](#-systemd--resolved_package)
* [`manage_nspawn`](#-systemd--manage_nspawn)
* [`nspawn_package`](#-systemd--nspawn_package)
* [`dns`](#-systemd--dns)
* [`fallback_dns`](#-systemd--fallback_dns)
* [`domains`](#-systemd--domains)
* [`llmnr`](#-systemd--llmnr)
* [`multicast_dns`](#-systemd--multicast_dns)
* [`dnssec`](#-systemd--dnssec)
* [`dnsovertls`](#-systemd--dnsovertls)
* [`cache`](#-systemd--cache)
* [`dns_stub_listener`](#-systemd--dns_stub_listener)
* [`dns_stub_listener_extra`](#-systemd--dns_stub_listener_extra)
* [`manage_resolv_conf`](#-systemd--manage_resolv_conf)
* [`use_stub_resolver`](#-systemd--use_stub_resolver)
* [`manage_networkd`](#-systemd--manage_networkd)
* [`networkd_ensure`](#-systemd--networkd_ensure)
* [`networkd_package`](#-systemd--networkd_package)
* [`manage_timesyncd`](#-systemd--manage_timesyncd)
* [`timesyncd_ensure`](#-systemd--timesyncd_ensure)
* [`timesyncd_package`](#-systemd--timesyncd_package)
* [`ntp_server`](#-systemd--ntp_server)
* [`fallback_ntp_server`](#-systemd--fallback_ntp_server)
* [`timezone`](#-systemd--timezone)
* [`set_local_rtc`](#-systemd--set_local_rtc)
* [`manage_journald`](#-systemd--manage_journald)
* [`journald_settings`](#-systemd--journald_settings)
* [`manage_udevd`](#-systemd--manage_udevd)
* [`udev_log`](#-systemd--udev_log)
* [`udev_children_max`](#-systemd--udev_children_max)
* [`udev_exec_delay`](#-systemd--udev_exec_delay)
* [`udev_event_timeout`](#-systemd--udev_event_timeout)
* [`udev_resolve_names`](#-systemd--udev_resolve_names)
* [`udev_timeout_signal`](#-systemd--udev_timeout_signal)
* [`udev_rules`](#-systemd--udev_rules)
* [`machine_info_settings`](#-systemd--machine_info_settings)
* [`manage_logind`](#-systemd--manage_logind)
* [`logind_settings`](#-systemd--logind_settings)
* [`loginctl_users`](#-systemd--loginctl_users)
* [`dropin_files`](#-systemd--dropin_files)
* [`manage_units`](#-systemd--manage_units)
* [`manage_dropins`](#-systemd--manage_dropins)
* [`manage_all_network_files`](#-systemd--manage_all_network_files)
* [`network_path`](#-systemd--network_path)
* [`manage_accounting`](#-systemd--manage_accounting)
* [`accounting`](#-systemd--accounting)
* [`purge_dropin_dirs`](#-systemd--purge_dropin_dirs)
* [`manage_coredump`](#-systemd--manage_coredump)
* [`coredump_settings`](#-systemd--coredump_settings)
* [`coredump_backtrace`](#-systemd--coredump_backtrace)
* [`manage_oomd`](#-systemd--manage_oomd)
* [`oomd_package`](#-systemd--oomd_package)
* [`oomd_ensure`](#-systemd--oomd_ensure)
* [`oomd_settings`](#-systemd--oomd_settings)
* [`udev_purge_rules`](#-systemd--udev_purge_rules)

##### <a name="-systemd--default_target"></a>`default_target`

Data type: `Optional[Pattern['^.+\.target$']]`

The default systemd boot target, unmanaged if set to undef.

Default value: `undef`

##### <a name="-systemd--service_limits"></a>`service_limits`

Data type: `Stdlib::CreateResources`

Deprecated, use dropin_files - Hash of `systemd::service_limits` resources

Default value: `{}`

##### <a name="-systemd--networks"></a>`networks`

Data type: `Stdlib::CreateResources`

Hash of `systemd::network` resources

Default value: `{}`

##### <a name="-systemd--timers"></a>`timers`

Data type: `Stdlib::CreateResources`

Hash of `systemd::timer` resources

Default value: `{}`

##### <a name="-systemd--tmpfiles"></a>`tmpfiles`

Data type: `Stdlib::CreateResources`

Hash of `systemd::tmpfile` resources

Default value: `{}`

##### <a name="-systemd--unit_files"></a>`unit_files`

Data type: `Stdlib::CreateResources`

Hash of `systemd::unit_file` resources

Default value: `{}`

##### <a name="-systemd--manage_resolved"></a>`manage_resolved`

Data type: `Boolean`

Manage the systemd resolver

Default value: `false`

##### <a name="-systemd--resolved_ensure"></a>`resolved_ensure`

Data type: `Enum['stopped','running']`

The state that the ``resolved`` service should be in. When migrating from 'running' to
'stopped' an attempt will be made to restore a working `/etc/resolv.conf` using
`/run/systemd/resolve/resolv.conf`.

Default value: `'running'`

##### <a name="-systemd--resolved_package"></a>`resolved_package`

Data type: `Optional[Enum['systemd-resolved']]`

The name of a systemd sub package needed for systemd-resolved if one needs to be installed.

Default value: `undef`

##### <a name="-systemd--manage_nspawn"></a>`manage_nspawn`

Data type: `Boolean`

Manage the systemd-nspawn@service and machinectl subsystem.

Default value: `false`

##### <a name="-systemd--nspawn_package"></a>`nspawn_package`

Data type: `Optional[Enum['systemd-container']]`

The name of a systemd sub package needed for the nspawn tools machinectl and
systemd-nspawn if one needs to be installed.

Default value: `undef`

##### <a name="-systemd--dns"></a>`dns`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of IPv4 and IPv6 addresses to use as system DNS servers.
DNS requests are sent to one of the listed DNS servers in parallel to suitable
per-link DNS servers acquired from systemd-networkd.service(8) or set at runtime
by external applications. requires puppetlabs-inifile

Default value: `undef`

##### <a name="-systemd--fallback_dns"></a>`fallback_dns`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of IPv4 and IPv6 addresses to use as the fallback DNS
servers. Any per-link DNS servers obtained from systemd-networkd take
precedence over this setting. requires puppetlabs-inifile

Default value: `undef`

##### <a name="-systemd--domains"></a>`domains`

Data type: `Optional[Variant[Array[String],String]]`

A space-separated list of domains host names or IP addresses to be used
systemd-resolved take precedence over this setting.

Default value: `undef`

##### <a name="-systemd--llmnr"></a>`llmnr`

Data type: `Optional[Variant[Boolean,Enum['resolve']]]`

Takes a boolean argument or "resolve".

Default value: `undef`

##### <a name="-systemd--multicast_dns"></a>`multicast_dns`

Data type: `Optional[Variant[Boolean,Enum['resolve']]]`

Takes a boolean argument or "resolve".

Default value: `undef`

##### <a name="-systemd--dnssec"></a>`dnssec`

Data type: `Optional[Variant[Boolean,Enum['allow-downgrade']]]`

Takes a boolean argument or "allow-downgrade".

Default value: `undef`

##### <a name="-systemd--dnsovertls"></a>`dnsovertls`

Data type: `Variant[Boolean,Enum['yes', 'opportunistic', 'no']]`

Takes a boolean argument or one of "yes", "opportunistic" or "no". "true" corresponds to
"opportunistic" and "false" (default) to "no".

Default value: `false`

##### <a name="-systemd--cache"></a>`cache`

Data type: `Optional[Variant[Boolean,Enum['no-negative']]]`

Takes a boolean argument or "no-negative". If left `undef` the cache setting will not be modified.

Default value: `undef`

##### <a name="-systemd--dns_stub_listener"></a>`dns_stub_listener`

Data type: `Optional[Variant[Boolean,Enum['udp','tcp','absent']]]`

Takes a boolean argument or one of "udp" and "tcp".
Setting it to `'absent'` will remove `DNSStubListener` existing entries from the configuration file

Default value: `undef`

##### <a name="-systemd--dns_stub_listener_extra"></a>`dns_stub_listener_extra`

Data type: `Optional[Variant[Array[String[1]],Enum['absent']]]`

Additional addresses for the DNS stub listener to listen on
Setting it to `'absent'` will remove `DNSStubListenerExtra` existing entries from the configuration file

Default value: `undef`

##### <a name="-systemd--manage_resolv_conf"></a>`manage_resolv_conf`

Data type: `Boolean`

For when `manage_resolved` is `true` should the file `/etc/resolv.conf` be managed.

Default value: `true`

##### <a name="-systemd--use_stub_resolver"></a>`use_stub_resolver`

Data type: `Boolean`

Takes a boolean argument. When "false" (default) it uses /run/systemd/resolve/resolv.conf
as /etc/resolv.conf. When "true", it uses /run/systemd/resolve/stub-resolv.conf
When `resolved_ensure` is `stopped` this parameter is ignored.

Default value: `false`

##### <a name="-systemd--manage_networkd"></a>`manage_networkd`

Data type: `Boolean`

Manage the systemd network daemon

Default value: `false`

##### <a name="-systemd--networkd_ensure"></a>`networkd_ensure`

Data type: `Enum['stopped','running']`

The state that the ``networkd`` service should be in

Default value: `'running'`

##### <a name="-systemd--networkd_package"></a>`networkd_package`

Data type: `Optional[String[1]]`

Name of the package required for systemd-networkd, if any

Default value: `undef`

##### <a name="-systemd--manage_timesyncd"></a>`manage_timesyncd`

Data type: `Boolean`

Manage the systemd timesyncd daemon

Default value: `false`

##### <a name="-systemd--timesyncd_ensure"></a>`timesyncd_ensure`

Data type: `Enum['stopped','running']`

The state that the ``timesyncd`` service should be in

Default value: `'running'`

##### <a name="-systemd--timesyncd_package"></a>`timesyncd_package`

Data type: `Optional[String[1]]`

Name of the package required for systemd-timesyncd, if any

Default value: `undef`

##### <a name="-systemd--ntp_server"></a>`ntp_server`

Data type: `Optional[Variant[Array,String]]`

comma separated list of ntp servers, will be combined with interface specific
addresses from systemd-networkd. requires puppetlabs-inifile

Default value: `undef`

##### <a name="-systemd--fallback_ntp_server"></a>`fallback_ntp_server`

Data type: `Optional[Variant[Array,String]]`

A space-separated list of NTP server host names or IP addresses to be used
as the fallback NTP servers. Any per-interface NTP servers obtained from
systemd-networkd take precedence over this setting. requires puppetlabs-inifile

Default value: `undef`

##### <a name="-systemd--timezone"></a>`timezone`

Data type: `Optional[String[1]]`

Set the system time zone to the specified value.
Available timezones can be listed with list-timezones.
If the RTC is configured to be in the local time, this will also update
the RTC time. This call will alter the /etc/localtime symlink.

Default value: `undef`

##### <a name="-systemd--set_local_rtc"></a>`set_local_rtc`

Data type: `Optional[Boolean]`

Takes a boolean argument. If "false", the system is configured to maintain
the RTC in universal time.
If "true", it will maintain the RTC in local time instead.
Note that maintaining the RTC in the local timezone is not fully supported
and will create various problems with time zone changes and daylight saving
adjustments. If at all possible, keep the RTC in UTC mode.

Default value: `undef`

##### <a name="-systemd--manage_journald"></a>`manage_journald`

Data type: `Boolean`

Manage the systemd journald

Default value: `true`

##### <a name="-systemd--journald_settings"></a>`journald_settings`

Data type: `Systemd::JournaldSettings`

Config Hash that is used to configure settings in journald.conf

Default value: `{}`

##### <a name="-systemd--manage_udevd"></a>`manage_udevd`

Data type: `Boolean`

Manage the systemd udev daemon

Default value: `false`

##### <a name="-systemd--udev_log"></a>`udev_log`

Data type: `Optional[Variant[Integer,String]]`

The value of /etc/udev/udev.conf udev_log

Default value: `undef`

##### <a name="-systemd--udev_children_max"></a>`udev_children_max`

Data type: `Optional[Integer]`

The value of /etc/udev/udev.conf children_max

Default value: `undef`

##### <a name="-systemd--udev_exec_delay"></a>`udev_exec_delay`

Data type: `Optional[Integer]`

The value of /etc/udev/udev.conf exec_delay

Default value: `undef`

##### <a name="-systemd--udev_event_timeout"></a>`udev_event_timeout`

Data type: `Optional[Integer]`

The value of /etc/udev/udev.conf event_timeout

Default value: `undef`

##### <a name="-systemd--udev_resolve_names"></a>`udev_resolve_names`

Data type: `Optional[Enum['early', 'late', 'never']]`

The value of /etc/udev/udev.conf resolve_names

Default value: `undef`

##### <a name="-systemd--udev_timeout_signal"></a>`udev_timeout_signal`

Data type: `Optional[Variant[Integer,String]]`

The value of /etc/udev/udev.conf timeout_signal

Default value: `undef`

##### <a name="-systemd--udev_rules"></a>`udev_rules`

Data type: `Stdlib::CreateResources`

Config Hash that is used to generate instances of our
`udev::rule` define.

Default value: `{}`

##### <a name="-systemd--machine_info_settings"></a>`machine_info_settings`

Data type: `Systemd::MachineInfoSettings`

Settings to place into /etc/machine-info (hostnamectl)

Default value: `{}`

##### <a name="-systemd--manage_logind"></a>`manage_logind`

Data type: `Boolean`

Manage the systemd logind

Default value: `false`

##### <a name="-systemd--logind_settings"></a>`logind_settings`

Data type: `Systemd::LogindSettings`

Config Hash that is used to configure settings in logind.conf

Default value: `{}`

##### <a name="-systemd--loginctl_users"></a>`loginctl_users`

Data type: `Stdlib::CreateResources`

Config Hash that is used to generate instances of our type
`loginctl_user`.

Default value: `{}`

##### <a name="-systemd--dropin_files"></a>`dropin_files`

Data type: `Stdlib::CreateResources`

Configure dropin files via hiera and `systemd::dropin_file` with factory pattern

Default value: `{}`

##### <a name="-systemd--manage_units"></a>`manage_units`

Data type: `Stdlib::CreateResources`

Configure units via hiera and `systemd::manage_unit` with factory pattern

Default value: `{}`

##### <a name="-systemd--manage_dropins"></a>`manage_dropins`

Data type: `Stdlib::CreateResources`

Configure dropin files via hiera and `systemd::manage_dropin` with factory pattern

Default value: `{}`

##### <a name="-systemd--manage_all_network_files"></a>`manage_all_network_files`

Data type: `Boolean`



Default value: `false`

##### <a name="-systemd--network_path"></a>`network_path`

Data type: `Stdlib::Absolutepath`

where all networkd files are placed in

Default value: `'/etc/systemd/network'`

##### <a name="-systemd--manage_accounting"></a>`manage_accounting`

Data type: `Boolean`

when enabled, the different accounting options (network traffic, IO, CPU util...) are enabled for units

Default value: `false`

##### <a name="-systemd--accounting"></a>`accounting`

Data type: `Hash[String,String]`

Hash of the different accounting options. This highly depends on the used systemd version. The module provides sane defaults per operating system using Hiera.

Default value: `{}`

##### <a name="-systemd--purge_dropin_dirs"></a>`purge_dropin_dirs`

Data type: `Boolean`

When enabled, unused directories for dropin files will be purged

Default value: `true`

##### <a name="-systemd--manage_coredump"></a>`manage_coredump`

Data type: `Boolean`

Should systemd-coredump configuration be managed

Default value: `false`

##### <a name="-systemd--coredump_settings"></a>`coredump_settings`

Data type: `Systemd::CoredumpSettings`

Hash of systemd-coredump configurations for coredump.conf

Default value: `{}`

##### <a name="-systemd--coredump_backtrace"></a>`coredump_backtrace`

Data type: `Boolean`

Add --backtrace to systemd-coredump call systemd-coredump@.service unit

Default value: `false`

##### <a name="-systemd--manage_oomd"></a>`manage_oomd`

Data type: `Boolean`

Should systemd-oomd configuration be managed

Default value: `false`

##### <a name="-systemd--oomd_package"></a>`oomd_package`

Data type: `Optional[String[1]]`

Name of the package required for systemd-oomd, if any

Default value: `undef`

##### <a name="-systemd--oomd_ensure"></a>`oomd_ensure`

Data type: `Enum['stopped','running']`

The state that the ``oomd`` service should be in

Default value: `'running'`

##### <a name="-systemd--oomd_settings"></a>`oomd_settings`

Data type: `Systemd::OomdSettings`

Hash of systemd-oomd configurations for oomd.conf

Default value: `{}`

##### <a name="-systemd--udev_purge_rules"></a>`udev_purge_rules`

Data type: `Boolean`

Toggle if unmanaged files in /etc/udev/rules.d should be purged if manage_udevd is enabled

Default value: `false`

### <a name="systemd--tmpfiles"></a>`systemd::tmpfiles`

Update the systemd temp files

* **See also**
  * systemd-tmpfiles(8)

#### Parameters

The following parameters are available in the `systemd::tmpfiles` class:

* [`operations`](#-systemd--tmpfiles--operations)

##### <a name="-systemd--tmpfiles--operations"></a>`operations`

Data type: `Array[Enum['create','clean','remove']]`

The operations to perform on the systemd tempfiles

* All operations may be combined but you'll probably only ever want to
  use ``create``

Default value: `['create']`

## Defined types

### <a name="systemd--daemon_reload"></a>`systemd::daemon_reload`

Run systemctl daemon-reload

#### Examples

##### Force reload the system systemd

```puppet
notify{ 'fake event to notify from':
  notify => Systemd::Daemon_reload['special']
}
systemd::daemon_reload{ 'special': }
```

##### Force reload a systemd --user

```puppet
notify{ 'fake event to notify from':
  notify => Systemd::Daemon_reload['steve_user']
}
systemd::daemon_reload{ 'steve_user':
  user => 'steve',
}
```

#### Parameters

The following parameters are available in the `systemd::daemon_reload` defined type:

* [`name`](#-systemd--daemon_reload--name)
* [`enable`](#-systemd--daemon_reload--enable)
* [`user`](#-systemd--daemon_reload--user)

##### <a name="-systemd--daemon_reload--name"></a>`name`

A globally unique name for the resource

##### <a name="-systemd--daemon_reload--enable"></a>`enable`

Data type: `Boolean`

Enable the reload exec
* Added in case users want to disable the reload globally using a resource collector

Default value: `true`

##### <a name="-systemd--daemon_reload--user"></a>`user`

Data type: `Optional[String[1]]`

Specify user name of `systemd --user` to reload. This not supported **below** Redhat 9,
Ubuntu 22.04 or Debian 12.

Default value: `undef`

### <a name="systemd--dropin_file"></a>`systemd::dropin_file`

Creates a drop-in file for a systemd unit

* **See also**
  * systemd.unit(5)

#### Parameters

The following parameters are available in the `systemd::dropin_file` defined type:

* [`unit`](#-systemd--dropin_file--unit)
* [`filename`](#-systemd--dropin_file--filename)
* [`ensure`](#-systemd--dropin_file--ensure)
* [`path`](#-systemd--dropin_file--path)
* [`selinux_ignore_defaults`](#-systemd--dropin_file--selinux_ignore_defaults)
* [`content`](#-systemd--dropin_file--content)
* [`source`](#-systemd--dropin_file--source)
* [`target`](#-systemd--dropin_file--target)
* [`owner`](#-systemd--dropin_file--owner)
* [`group`](#-systemd--dropin_file--group)
* [`mode`](#-systemd--dropin_file--mode)
* [`show_diff`](#-systemd--dropin_file--show_diff)
* [`notify_service`](#-systemd--dropin_file--notify_service)
* [`daemon_reload`](#-systemd--dropin_file--daemon_reload)

##### <a name="-systemd--dropin_file--unit"></a>`unit`

Data type: `Systemd::Unit`

The target unit file to create

##### <a name="-systemd--dropin_file--filename"></a>`filename`

Data type: `Systemd::Dropin`

The filename of the drop in. The full path is determined using the path, unit and this filename.

Default value: `$name`

##### <a name="-systemd--dropin_file--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

the state of this dropin file

Default value: `'present'`

##### <a name="-systemd--dropin_file--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--dropin_file--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

If Puppet should ignore the default SELinux labels.

Default value: `false`

##### <a name="-systemd--dropin_file--content"></a>`content`

Data type: `Optional[Variant[String,Sensitive[String]]]`

The full content of the unit file (Mutually exclusive with `$source`)

Default value: `undef`

##### <a name="-systemd--dropin_file--source"></a>`source`

Data type: `Optional[String]`

The `File` resource compatible `source` Mutually exclusive with ``$content``

Default value: `undef`

##### <a name="-systemd--dropin_file--target"></a>`target`

Data type: `Optional[Stdlib::Absolutepath]`

If set, will force the file to be a symlink to the given target (Mutually exclusive with both `$source` and `$content`

Default value: `undef`

##### <a name="-systemd--dropin_file--owner"></a>`owner`

Data type: `String`

The owner to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--dropin_file--group"></a>`group`

Data type: `String`

The group to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--dropin_file--mode"></a>`mode`

Data type: `String`

The mode to set on the dropin file

Default value: `'0444'`

##### <a name="-systemd--dropin_file--show_diff"></a>`show_diff`

Data type: `Boolean`

Whether to show the diff when updating dropin file

Default value: `true`

##### <a name="-systemd--dropin_file--notify_service"></a>`notify_service`

Data type: `Boolean`

Notify a service for the unit, if it exists

Default value: `true`

##### <a name="-systemd--dropin_file--daemon_reload"></a>`daemon_reload`

Data type: `Boolean`

Call systemd::daemon_reload

Default value: `true`

### <a name="systemd--manage_dropin"></a>`systemd::manage_dropin`

Creates a drop-in file for a systemd unit from a template

* **See also**
  * systemd.unit(5)

#### Examples

##### drop in file to change Type and override ExecStart

```puppet
systemd::manage_dropin { 'myconf.conf':
  ensure        => present,
  unit          => 'myservice.service',
  service_entry => {
    'Type'      => 'oneshot',
    'ExecStart' => ['', '/usr/bin/doit.sh'],
  },
}
```

##### drop in file to change a path unit and override TriggerLimitBurst

```puppet
systemd::manage_dropin { 'triggerlimit.conf':
  ensure     => present,
  unit       => 'passwd.path',
  path_entry => {
    'TriggerLimitBurst' => 100,
  },
}
```

##### drop in file to override the LimitCORE for a service

```puppet
systemd::manage_dropin { 'corelimit.conf':
  ensure     => present,
  unit       => 'rsyslog.conf',
  path_entry => {
    'LimitCORE' => 'infinity',
  },
}
```

##### make a noisy unit less noisy

```puppet
systemd::manage_dropin { 'maxloglevel.conf':
  ensure        => present,
  unit          => 'chatty.service',
  service_entry => {
    'LogLevelMax' => 'warning',
  }
}
```

##### have a unit instance auto run before user-<uid>.service

```puppet
systemd::manage_dropin { 'user-aklog.conf':
  unit => 'user@.service',
  unit_entry => {
    'After'    => 'user-aklog@%i.service',
    'Requires' => 'user-aklog@%i.service'
  }
}
```

##### set memory limits on the user slices

```puppet
systemd::manage_dropin { 'userlimits.conf':
  unit        => 'user-.slice',
  slice_entry => {
    MemoryMax        => '10G',
    MemoryAccounting => true,
  }
}
```

##### set IO limits on two devices

```puppet
systemd::manage_dropin { 'devicelimits.conf':
  unit          =>  'special.service',
  service_entry => {
   'IOReadIOPSMax' => [
     ['/dev/afs',100],
     ['/dev/gluster','1000K'],
   ],
  },
}
```

#### Parameters

The following parameters are available in the `systemd::manage_dropin` defined type:

* [`unit`](#-systemd--manage_dropin--unit)
* [`filename`](#-systemd--manage_dropin--filename)
* [`ensure`](#-systemd--manage_dropin--ensure)
* [`path`](#-systemd--manage_dropin--path)
* [`selinux_ignore_defaults`](#-systemd--manage_dropin--selinux_ignore_defaults)
* [`owner`](#-systemd--manage_dropin--owner)
* [`group`](#-systemd--manage_dropin--group)
* [`mode`](#-systemd--manage_dropin--mode)
* [`show_diff`](#-systemd--manage_dropin--show_diff)
* [`notify_service`](#-systemd--manage_dropin--notify_service)
* [`daemon_reload`](#-systemd--manage_dropin--daemon_reload)
* [`unit_entry`](#-systemd--manage_dropin--unit_entry)
* [`slice_entry`](#-systemd--manage_dropin--slice_entry)
* [`service_entry`](#-systemd--manage_dropin--service_entry)
* [`install_entry`](#-systemd--manage_dropin--install_entry)
* [`timer_entry`](#-systemd--manage_dropin--timer_entry)
* [`path_entry`](#-systemd--manage_dropin--path_entry)
* [`socket_entry`](#-systemd--manage_dropin--socket_entry)

##### <a name="-systemd--manage_dropin--unit"></a>`unit`

Data type: `Systemd::Unit`

The unit to create a dropfile for

##### <a name="-systemd--manage_dropin--filename"></a>`filename`

Data type: `Systemd::Dropin`

The target unit file to create. The filename of the drop in. The full path is determined using the path, unit and this filename.

Default value: `$name`

##### <a name="-systemd--manage_dropin--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

The state of this dropin file

Default value: `'present'`

##### <a name="-systemd--manage_dropin--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--manage_dropin--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

If Puppet should ignore the default SELinux labels

Default value: `false`

##### <a name="-systemd--manage_dropin--owner"></a>`owner`

Data type: `String`

The owner to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--manage_dropin--group"></a>`group`

Data type: `String`

The group to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--manage_dropin--mode"></a>`mode`

Data type: `Stdlib::Filemode`

The mode to set on the dropin file

Default value: `'0444'`

##### <a name="-systemd--manage_dropin--show_diff"></a>`show_diff`

Data type: `Boolean`

Whether to show the diff when updating dropin file

Default value: `true`

##### <a name="-systemd--manage_dropin--notify_service"></a>`notify_service`

Data type: `Boolean`

Notify a service for the unit, if it exists

Default value: `false`

##### <a name="-systemd--manage_dropin--daemon_reload"></a>`daemon_reload`

Data type: `Boolean`

Call systemd::daemon_reload

Default value: `true`

##### <a name="-systemd--manage_dropin--unit_entry"></a>`unit_entry`

Data type: `Optional[Systemd::Unit::Unit]`

key value pairs for [Unit] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--slice_entry"></a>`slice_entry`

Data type: `Optional[Systemd::Unit::Slice]`

key value pairs for [Slice] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--service_entry"></a>`service_entry`

Data type: `Optional[Systemd::Unit::Service]`

key value pairs for [Service] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--install_entry"></a>`install_entry`

Data type: `Optional[Systemd::Unit::Install]`

key value pairs for [Install] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--timer_entry"></a>`timer_entry`

Data type: `Optional[Systemd::Unit::Timer]`

key value pairs for [Timer] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--path_entry"></a>`path_entry`

Data type: `Optional[Systemd::Unit::Path]`

key value pairs for [Path] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_dropin--socket_entry"></a>`socket_entry`

Data type: `Optional[Systemd::Unit::Socket]`

key value pairs for the [Socket] section of the unit file

Default value: `undef`

### <a name="systemd--manage_unit"></a>`systemd::manage_unit`

Generate unit file from template

* **See also**
  * systemd.unit(5)

#### Examples

##### Generate a service

```puppet
systemd::manage_unit { 'myrunner.service':
  unit_entry    => {
    'Description' => 'My great service',
  },
  service_entry => {
    'Type'      => 'oneshot',
    'ExecStart' => '/usr/bin/doit.sh',
  },
  install_entry => {
    'WantedBy' => 'multi-user.target',
  },
}
```

##### Genenerate a path unit

```puppet
systemd::manage_unit { 'passwd-mon.path':
  ensure        => present,
  unit_entry    => {
    'Description' => 'Monitor the passwd file',
  },
  path_entry    => {
    'PathModified' => '/etc/passwd',
    'Unit'         => 'passwd-mon.service',
  },
  install_entry => {
    'WantedBy' => 'multi-user.target',
  },
}
```

##### Generate a socket and service (xinetd style)

```puppet
systemd::manage_unit {'arcd.socket':
  ensure        => 'present',
  unit_entry    => {
    'Description' => 'arcd.service',
  },
  socket_entry  => {
    'ListenStream' => 4241,
    'Accept'       => true,
    'BindIPv6Only' => 'both',
  },
  install_entry => {
    'WantedBy' => 'sockets.target',
  },
}

systemd::manage_unit{'arcd@.service':
  ensure        => 'present',
  enable        => true,
  active        => true,
  unit_entry    => {
    'Description'   => 'arc sever for %i',
  },
  service_entry => {
    'Type'          => 'simple',
    'ExecStart'     => /usr/sbin/arcd /usr/libexec/arcd/arcd.pl,
    'StandardInput' => 'socket',
  },
}
```

##### Remove a unit file

```puppet
systemd::manage_unit { 'my.service':
  ensure     => 'absent',
}
```

#### Parameters

The following parameters are available in the `systemd::manage_unit` defined type:

* [`name`](#-systemd--manage_unit--name)
* [`ensure`](#-systemd--manage_unit--ensure)
* [`path`](#-systemd--manage_unit--path)
* [`owner`](#-systemd--manage_unit--owner)
* [`group`](#-systemd--manage_unit--group)
* [`mode`](#-systemd--manage_unit--mode)
* [`show_diff`](#-systemd--manage_unit--show_diff)
* [`enable`](#-systemd--manage_unit--enable)
* [`active`](#-systemd--manage_unit--active)
* [`restart`](#-systemd--manage_unit--restart)
* [`selinux_ignore_defaults`](#-systemd--manage_unit--selinux_ignore_defaults)
* [`service_parameters`](#-systemd--manage_unit--service_parameters)
* [`daemon_reload`](#-systemd--manage_unit--daemon_reload)
* [`service_restart`](#-systemd--manage_unit--service_restart)
* [`unit_entry`](#-systemd--manage_unit--unit_entry)
* [`slice_entry`](#-systemd--manage_unit--slice_entry)
* [`service_entry`](#-systemd--manage_unit--service_entry)
* [`install_entry`](#-systemd--manage_unit--install_entry)
* [`timer_entry`](#-systemd--manage_unit--timer_entry)
* [`path_entry`](#-systemd--manage_unit--path_entry)
* [`socket_entry`](#-systemd--manage_unit--socket_entry)

##### <a name="-systemd--manage_unit--name"></a>`name`

Data type: `Pattern['^[^/]+\.(service|socket|device|mount|automount|swap|target|path|timer|slice|scope)$']`

The target unit file to create

##### <a name="-systemd--manage_unit--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

The state of the unit file to ensure

Default value: `'present'`

##### <a name="-systemd--manage_unit--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--manage_unit--owner"></a>`owner`

Data type: `String`

The owner to set on the unit file

Default value: `'root'`

##### <a name="-systemd--manage_unit--group"></a>`group`

Data type: `String`

The group to set on the unit file

Default value: `'root'`

##### <a name="-systemd--manage_unit--mode"></a>`mode`

Data type: `Stdlib::Filemode`

The mode to set on the unit file

Default value: `'0444'`

##### <a name="-systemd--manage_unit--show_diff"></a>`show_diff`

Data type: `Boolean`

Whether to show the diff when updating unit file

Default value: `true`

##### <a name="-systemd--manage_unit--enable"></a>`enable`

Data type: `Optional[Variant[Boolean, Enum['mask']]]`

If set, manage the unit enablement status

Default value: `undef`

##### <a name="-systemd--manage_unit--active"></a>`active`

Data type: `Optional[Boolean]`

If set, will manage the state of the unit

Default value: `undef`

##### <a name="-systemd--manage_unit--restart"></a>`restart`

Data type: `Optional[String]`

Specify a restart command manually. If left unspecified, a standard Puppet service restart happens

Default value: `undef`

##### <a name="-systemd--manage_unit--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

maps to the same param on the file resource for the unit. false in the module because it's false in the file resource type

Default value: `false`

##### <a name="-systemd--manage_unit--service_parameters"></a>`service_parameters`

Data type: `Hash[String[1], Any]`

hash that will be passed with the splat operator to the service resource

Default value: `{}`

##### <a name="-systemd--manage_unit--daemon_reload"></a>`daemon_reload`

Data type: `Boolean`

call `systemd::daemon-reload` to ensure that the modified unit file is loaded

Default value: `true`

##### <a name="-systemd--manage_unit--service_restart"></a>`service_restart`

Data type: `Boolean`

restart (notify) the service when unit file changed

Default value: `true`

##### <a name="-systemd--manage_unit--unit_entry"></a>`unit_entry`

Data type: `Optional[Systemd::Unit::Unit]`

key value pairs for [Unit] section of the unit file.

Default value: `undef`

##### <a name="-systemd--manage_unit--slice_entry"></a>`slice_entry`

Data type: `Optional[Systemd::Unit::Slice]`

key value pairs for [Slice] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_unit--service_entry"></a>`service_entry`

Data type: `Optional[Systemd::Unit::Service]`

key value pairs for [Service] section of the unit file.

Default value: `undef`

##### <a name="-systemd--manage_unit--install_entry"></a>`install_entry`

Data type: `Optional[Systemd::Unit::Install]`

key value pairs for [Install] section of the unit file.

Default value: `undef`

##### <a name="-systemd--manage_unit--timer_entry"></a>`timer_entry`

Data type: `Optional[Systemd::Unit::Timer]`

key value pairs for [Timer] section of the unit file

Default value: `undef`

##### <a name="-systemd--manage_unit--path_entry"></a>`path_entry`

Data type: `Optional[Systemd::Unit::Path]`

key value pairs for [Path] section of the unit file.

Default value: `undef`

##### <a name="-systemd--manage_unit--socket_entry"></a>`socket_entry`

Data type: `Optional[Systemd::Unit::Socket]`

kev value paors for [Socket] section of the unit file.

Default value: `undef`

### <a name="systemd--modules_load"></a>`systemd::modules_load`

Creates a modules-load.d drop file

* **See also**
  * modules-load.d(5)

#### Examples

##### load a module

```puppet
systemd::modules_load { 'impi.conf':
   content => "ipmi\n",
}
```

##### override /lib/modules-load.d/myservice.conf in /etc/modules-load.d/myservice.conf

```puppet
systemd::modules_load { 'myservice.conf':
   content => "# Cancel system version of the file\n",
}
```

#### Parameters

The following parameters are available in the `systemd::modules_load` defined type:

* [`filename`](#-systemd--modules_load--filename)
* [`ensure`](#-systemd--modules_load--ensure)
* [`path`](#-systemd--modules_load--path)
* [`content`](#-systemd--modules_load--content)
* [`source`](#-systemd--modules_load--source)

##### <a name="-systemd--modules_load--filename"></a>`filename`

Data type: `Systemd::Dropin`

The name of the modules-load.d file to create

Default value: `$name`

##### <a name="-systemd--modules_load--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

Whether to drop a file or remove it

Default value: `'file'`

##### <a name="-systemd--modules_load--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd modules-load.d directory

Default value: `'/etc/modules-load.d'`

##### <a name="-systemd--modules_load--content"></a>`content`

Data type: `Optional[String[1]]`

The literal content to write to the file

* Mutually exclusive with ``$source``

Default value: `undef`

##### <a name="-systemd--modules_load--source"></a>`source`

Data type: `Optional[String[1]]`

A ``File`` resource compatible ``source``

* Mutually exclusive with ``$content``

Default value: `undef`

### <a name="systemd--network"></a>`systemd::network`

Creates network config for systemd-networkd

#### Parameters

The following parameters are available in the `systemd::network` defined type:

* [`ensure`](#-systemd--network--ensure)
* [`path`](#-systemd--network--path)
* [`content`](#-systemd--network--content)
* [`source`](#-systemd--network--source)
* [`target`](#-systemd--network--target)
* [`owner`](#-systemd--network--owner)
* [`group`](#-systemd--network--group)
* [`mode`](#-systemd--network--mode)
* [`show_diff`](#-systemd--network--show_diff)
* [`restart_service`](#-systemd--network--restart_service)

##### <a name="-systemd--network--ensure"></a>`ensure`

Data type: `Enum['file', 'absent']`

configure if the file should be configured or deleted

Default value: `file`

##### <a name="-systemd--network--path"></a>`path`

Data type: `Stdlib::Absolutepath`

directory where the network configs are stored

Default value: `'/etc/systemd/network'`

##### <a name="-systemd--network--content"></a>`content`

Data type: `Optional[String]`

the content of the file

Default value: `undef`

##### <a name="-systemd--network--source"></a>`source`

Data type: `Optional[String]`

a path to a file that's used as source

Default value: `undef`

##### <a name="-systemd--network--target"></a>`target`

Data type: `Optional[Stdlib::Absolutepath]`

optional absolute path  in case the file should be stored somewhere else

Default value: `undef`

##### <a name="-systemd--network--owner"></a>`owner`

Data type: `String`

the user who owns the file

Default value: `'root'`

##### <a name="-systemd--network--group"></a>`group`

Data type: `String`

the group that owns the file

Default value: `'root'`

##### <a name="-systemd--network--mode"></a>`mode`

Data type: `String`

the mode of the file

Default value: `'0444'`

##### <a name="-systemd--network--show_diff"></a>`show_diff`

Data type: `Boolean`

whether the file diff should be shown on modifications

Default value: `true`

##### <a name="-systemd--network--restart_service"></a>`restart_service`

Data type: `Boolean`

whether systemd-networkd should be restarted on changes, defaults to true. `$systemd::manage_networkd` needs to be true as well

Default value: `true`

### <a name="systemd--service_limits"></a>`systemd::service_limits`

Deprecated - Adds a set of custom limits to the service

* **See also**
  * systemd.exec(5)

#### Parameters

The following parameters are available in the `systemd::service_limits` defined type:

* [`name`](#-systemd--service_limits--name)
* [`ensure`](#-systemd--service_limits--ensure)
* [`path`](#-systemd--service_limits--path)
* [`selinux_ignore_defaults`](#-systemd--service_limits--selinux_ignore_defaults)
* [`limits`](#-systemd--service_limits--limits)
* [`source`](#-systemd--service_limits--source)
* [`restart_service`](#-systemd--service_limits--restart_service)

##### <a name="-systemd--service_limits--name"></a>`name`

Data type: `Pattern['^.+\.(service|socket|mount|swap)$']`

The name of the service that you will be modifying

##### <a name="-systemd--service_limits--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

Whether to drop a file or remove it

Default value: `'present'`

##### <a name="-systemd--service_limits--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd settings directory

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--service_limits--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

If Puppet should ignore the default SELinux labels.

Default value: `false`

##### <a name="-systemd--service_limits--limits"></a>`limits`

Data type: `Optional[Systemd::ServiceLimits]`

A Hash of service limits matching the settings in ``systemd.exec(5)``

* Mutually exclusive with ``$source``

Default value: `undef`

##### <a name="-systemd--service_limits--source"></a>`source`

Data type: `Optional[String]`

A ``File`` resource compatible ``source``

* Mutually exclusive with ``$limits``

Default value: `undef`

##### <a name="-systemd--service_limits--restart_service"></a>`restart_service`

Data type: `Boolean`

Unused parameter for compatibility with older versions. Will fail if true is passed in.

Default value: `false`

### <a name="systemd--timer"></a>`systemd::timer`

Create a timer and optionally a service unit to execute with the timer unit

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.timer.html
    * systemd.timer(5)

#### Parameters

The following parameters are available in the `systemd::timer` defined type:

* [`name`](#-systemd--timer--name)
* [`path`](#-systemd--timer--path)
* [`timer_content`](#-systemd--timer--timer_content)
* [`timer_source`](#-systemd--timer--timer_source)
* [`service_content`](#-systemd--timer--service_content)
* [`service_source`](#-systemd--timer--service_source)
* [`owner`](#-systemd--timer--owner)
* [`group`](#-systemd--timer--group)
* [`mode`](#-systemd--timer--mode)
* [`show_diff`](#-systemd--timer--show_diff)
* [`service_unit`](#-systemd--timer--service_unit)
* [`active`](#-systemd--timer--active)
* [`enable`](#-systemd--timer--enable)
* [`ensure`](#-systemd--timer--ensure)
* [`daemon_reload`](#-systemd--timer--daemon_reload)

##### <a name="-systemd--timer--name"></a>`name`

Data type: `Pattern['^.+\.timer$]`

The target of the timer unit to create

##### <a name="-systemd--timer--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--timer--timer_content"></a>`timer_content`

Data type: `Optional[String[1]]`

The full content of the timer unit file

* Mutually exclusive with ``$timer_source``

Default value: `undef`

##### <a name="-systemd--timer--timer_source"></a>`timer_source`

Data type: `Optional[String[1]]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$timer_content``

Default value: `undef`

##### <a name="-systemd--timer--service_content"></a>`service_content`

Data type: `Optional[String[1]]`

The full content of the service unit file

* Mutually exclusive with ``$service_source``

Default value: `undef`

##### <a name="-systemd--timer--service_source"></a>`service_source`

Data type: `Optional[String[1]]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$service_content``

Default value: `undef`

##### <a name="-systemd--timer--owner"></a>`owner`

Data type: `String[1]`

The owner to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--timer--group"></a>`group`

Data type: `String[1]`

The group to set on the dropin file

Default value: `'root'`

##### <a name="-systemd--timer--mode"></a>`mode`

Data type: `Stdlib::Filemode`

The mode to set on the dropin file

Default value: `'0444'`

##### <a name="-systemd--timer--show_diff"></a>`show_diff`

Data type: `Boolean`

Whether to show the diff when updating dropin file

Default value: `true`

##### <a name="-systemd--timer--service_unit"></a>`service_unit`

Data type: `Optional[Systemd::Unit]`

If set then the service_unit will have this name.
If not set the service unit has the same name
as the timer unit with s/.timer/.service/

Default value: `undef`

##### <a name="-systemd--timer--active"></a>`active`

Data type: `Optional[Boolean]`

If set to true or false the timer service will be maintained.
If true the timer service will be running and enabled, if false it will
explicitly stopped and disabled.

Default value: `undef`

##### <a name="-systemd--timer--enable"></a>`enable`

Data type: `Optional[Variant[Boolean, Enum['mask']]]`

If set, will manage the state of the unit.

Default value: `undef`

##### <a name="-systemd--timer--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

Defines the desired state of the timer

Default value: `'present'`

##### <a name="-systemd--timer--daemon_reload"></a>`daemon_reload`

Data type: `Boolean`

Call `systemd::daemon_reload`

Default value: `true`

### <a name="systemd--timer_wrapper"></a>`systemd::timer_wrapper`

Helper to define timer and accompanying services for a given task (cron like interface).

#### Examples

##### Create a timer that runs every 5 minutes

```puppet
systemd::timer_wrapper { 'my_timer':
  ensure        => 'present',
  command       => '/usr/bin/echo "Hello World"',
  on_calendar   => '*:0/5',
}
```

##### Create a timer with overrides for the service and timer

```puppet
systemd::timer_wrapper { 'my_timer':
  ensure             => 'present',
  command            => '/usr/bin/echo "Hello World"',
  on_calendar        => '*:0/5',
  service_overrides => { 'Group' => 'nobody' },
  timer_overrides   => { 'OnBootSec' => '10' },
}
```

##### Create a timer with overrides for the service_unit and timer_unit

```puppet
systemd::timer_wrapper { 'my_timer':
  ensure                 => 'present',
  command                => '/usr/bin/echo "Hello World"',
  on_calendar            => '*:0/5',
  service_unit_overrides => { 'Wants' => 'network-online.target' },
  timer_unit_overrides   => { 'Description' => 'Very special timer' },
}
```

#### Parameters

The following parameters are available in the `systemd::timer_wrapper` defined type:

* [`ensure`](#-systemd--timer_wrapper--ensure)
* [`command`](#-systemd--timer_wrapper--command)
* [`user`](#-systemd--timer_wrapper--user)
* [`on_active_sec`](#-systemd--timer_wrapper--on_active_sec)
* [`on_boot_sec`](#-systemd--timer_wrapper--on_boot_sec)
* [`on_start_up_sec`](#-systemd--timer_wrapper--on_start_up_sec)
* [`on_unit_active_sec`](#-systemd--timer_wrapper--on_unit_active_sec)
* [`on_unit_inactive_sec`](#-systemd--timer_wrapper--on_unit_inactive_sec)
* [`on_calendar`](#-systemd--timer_wrapper--on_calendar)
* [`service_overrides`](#-systemd--timer_wrapper--service_overrides)
* [`timer_overrides`](#-systemd--timer_wrapper--timer_overrides)
* [`service_unit_overrides`](#-systemd--timer_wrapper--service_unit_overrides)
* [`timer_unit_overrides`](#-systemd--timer_wrapper--timer_unit_overrides)

##### <a name="-systemd--timer_wrapper--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

whether the timer and service should be present or absent

##### <a name="-systemd--timer_wrapper--command"></a>`command`

Data type: `Optional[Systemd::Unit::Service::Exec]`

the command for the systemd servie to execute

Default value: `undef`

##### <a name="-systemd--timer_wrapper--user"></a>`user`

Data type: `Optional[String[1]]`

the user to run the command as

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_active_sec"></a>`on_active_sec`

Data type: `Optional[Systemd::Unit::Timespan]`

run service relative to the time when the timer was activated

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_boot_sec"></a>`on_boot_sec`

Data type: `Optional[Systemd::Unit::Timespan]`

run service relative to when the machine was booted

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_start_up_sec"></a>`on_start_up_sec`

Data type: `Optional[Systemd::Unit::Timespan]`

run service relative to when the service manager was started

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_unit_active_sec"></a>`on_unit_active_sec`

Data type: `Optional[Systemd::Unit::Timespan]`

run service relative to when the unit was last activated

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_unit_inactive_sec"></a>`on_unit_inactive_sec`

Data type: `Optional[Systemd::Unit::Timespan]`

run service relative to when the unit was last deactivated

Default value: `undef`

##### <a name="-systemd--timer_wrapper--on_calendar"></a>`on_calendar`

Data type: `Optional[Systemd::Unit::Timespan]`

the calendar event expressions time to run the service

Default value: `undef`

##### <a name="-systemd--timer_wrapper--service_overrides"></a>`service_overrides`

Data type: `Systemd::Unit::Service`

override for the`[Service]` section of the service

Default value: `{}`

##### <a name="-systemd--timer_wrapper--timer_overrides"></a>`timer_overrides`

Data type: `Systemd::Unit::Timer`

override for the`[Timer]` section of the timer

Default value: `{}`

##### <a name="-systemd--timer_wrapper--service_unit_overrides"></a>`service_unit_overrides`

Data type: `Systemd::Unit::Unit`

override for the`[Unit]` section of the service

Default value: `{}`

##### <a name="-systemd--timer_wrapper--timer_unit_overrides"></a>`timer_unit_overrides`

Data type: `Systemd::Unit::Unit`

override for the `[Unit]` section of the timer

Default value: `{}`

### <a name="systemd--tmpfile"></a>`systemd::tmpfile`

Creates a systemd tmpfile

* **See also**
  * systemd-tmpfiles(8)

#### Parameters

The following parameters are available in the `systemd::tmpfile` defined type:

* [`filename`](#-systemd--tmpfile--filename)
* [`ensure`](#-systemd--tmpfile--ensure)
* [`path`](#-systemd--tmpfile--path)
* [`content`](#-systemd--tmpfile--content)
* [`source`](#-systemd--tmpfile--source)

##### <a name="-systemd--tmpfile--filename"></a>`filename`

Data type: `Systemd::Dropin`

The name of the tmpfile to create

Default value: `$name`

##### <a name="-systemd--tmpfile--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

Whether to drop a file or remove it

Default value: `'file'`

##### <a name="-systemd--tmpfile--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd tmpfiles directory

Default value: `'/etc/tmpfiles.d'`

##### <a name="-systemd--tmpfile--content"></a>`content`

Data type: `Optional[String]`

The literal content to write to the file

* Mutually exclusive with ``$source``

Default value: `undef`

##### <a name="-systemd--tmpfile--source"></a>`source`

Data type: `Optional[String]`

A ``File`` resource compatible ``source``

* Mutually exclusive with ``$limits``

Default value: `undef`

### <a name="systemd--udev--rule"></a>`systemd::udev::rule`

Adds a custom udev rule

* **See also**
  * udev(7)

#### Parameters

The following parameters are available in the `systemd::udev::rule` defined type:

* [`name`](#-systemd--udev--rule--name)
* [`ensure`](#-systemd--udev--rule--ensure)
* [`path`](#-systemd--udev--rule--path)
* [`selinux_ignore_defaults`](#-systemd--udev--rule--selinux_ignore_defaults)
* [`notify_services`](#-systemd--udev--rule--notify_services)
* [`rules`](#-systemd--udev--rule--rules)

##### <a name="-systemd--udev--rule--name"></a>`name`

Data type: `Pattern['^.+\.rules$']`

The name of the udev rules to create

##### <a name="-systemd--udev--rule--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'file']`

Whether to drop a file or remove it

Default value: `'file'`

##### <a name="-systemd--udev--rule--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The path to the main systemd settings directory

Default value: `'/etc/udev/rules.d'`

##### <a name="-systemd--udev--rule--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

If Puppet should ignore the default SELinux labels.

Default value: `false`

##### <a name="-systemd--udev--rule--notify_services"></a>`notify_services`

Data type: `Variant[Array[String[1]], String[1]]`

List of services to notify when this rule is updated

Default value: `[]`

##### <a name="-systemd--udev--rule--rules"></a>`rules`

Data type: `Array`

The literal udev rules you want to deploy

Default value: `[]`

### <a name="systemd--unit_file"></a>`systemd::unit_file`

Creates a systemd unit file

* **See also**
  * systemd.unit(5)

#### Examples

##### manage unit file + service

```puppet
systemd::unit_file { 'foo.service':
  content => file("${module_name}/foo.service"),
  enable  => true,
  active  => true,
}
```

#### Parameters

The following parameters are available in the `systemd::unit_file` defined type:

* [`name`](#-systemd--unit_file--name)
* [`ensure`](#-systemd--unit_file--ensure)
* [`path`](#-systemd--unit_file--path)
* [`content`](#-systemd--unit_file--content)
* [`source`](#-systemd--unit_file--source)
* [`target`](#-systemd--unit_file--target)
* [`owner`](#-systemd--unit_file--owner)
* [`group`](#-systemd--unit_file--group)
* [`mode`](#-systemd--unit_file--mode)
* [`show_diff`](#-systemd--unit_file--show_diff)
* [`enable`](#-systemd--unit_file--enable)
* [`active`](#-systemd--unit_file--active)
* [`restart`](#-systemd--unit_file--restart)
* [`selinux_ignore_defaults`](#-systemd--unit_file--selinux_ignore_defaults)
* [`service_parameters`](#-systemd--unit_file--service_parameters)
* [`daemon_reload`](#-systemd--unit_file--daemon_reload)
* [`service_restart`](#-systemd--unit_file--service_restart)

##### <a name="-systemd--unit_file--name"></a>`name`

Data type: `Pattern['^[^/]+\.(service|socket|device|mount|automount|swap|target|path|timer|slice|scope)$']`

The target unit file to create

##### <a name="-systemd--unit_file--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

The state of the unit file to ensure

Default value: `'present'`

##### <a name="-systemd--unit_file--path"></a>`path`

Data type: `Stdlib::Absolutepath`

The main systemd configuration path

Default value: `'/etc/systemd/system'`

##### <a name="-systemd--unit_file--content"></a>`content`

Data type: `Optional[Variant[String, Sensitive[String], Deferred]]`

The full content of the unit file

* Mutually exclusive with ``$source``

Default value: `undef`

##### <a name="-systemd--unit_file--source"></a>`source`

Data type: `Optional[String]`

The ``File`` resource compatible ``source``

* Mutually exclusive with ``$content``

Default value: `undef`

##### <a name="-systemd--unit_file--target"></a>`target`

Data type: `Optional[Stdlib::Absolutepath]`

If set, will force the file to be a symlink to the given target

* Mutually exclusive with both ``$source`` and ``$content``

Default value: `undef`

##### <a name="-systemd--unit_file--owner"></a>`owner`

Data type: `String`

The owner to set on the unit file

Default value: `'root'`

##### <a name="-systemd--unit_file--group"></a>`group`

Data type: `String`

The group to set on the unit file

Default value: `'root'`

##### <a name="-systemd--unit_file--mode"></a>`mode`

Data type: `String`

The mode to set on the unit file

Default value: `'0444'`

##### <a name="-systemd--unit_file--show_diff"></a>`show_diff`

Data type: `Boolean`

Whether to show the diff when updating unit file

Default value: `true`

##### <a name="-systemd--unit_file--enable"></a>`enable`

Data type: `Optional[Variant[Boolean, Enum['mask']]]`

If set, will manage the unit enablement status.

Default value: `undef`

##### <a name="-systemd--unit_file--active"></a>`active`

Data type: `Optional[Boolean]`

If set, will manage the state of the unit.

Default value: `undef`

##### <a name="-systemd--unit_file--restart"></a>`restart`

Data type: `Optional[String]`

Specify a restart command manually. If left unspecified, a standard Puppet service restart happens.

Default value: `undef`

##### <a name="-systemd--unit_file--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Boolean`

maps to the same param on the file resource for the unit. false in the module because it's false in the file resource type

Default value: `false`

##### <a name="-systemd--unit_file--service_parameters"></a>`service_parameters`

Data type: `Hash[String[1], Any]`

hash that will be passed with the splat operator to the service resource

Default value: `{}`

##### <a name="-systemd--unit_file--daemon_reload"></a>`daemon_reload`

Data type: `Boolean`

call `systemd::daemon-reload` to ensure that the modified unit file is loaded

Default value: `true`

##### <a name="-systemd--unit_file--service_restart"></a>`service_restart`

Data type: `Boolean`

restart (notify) the service when unit file changed

Default value: `true`

### <a name="systemd--user_service"></a>`systemd::user_service`

Manage a user service running under systemd --user

#### Examples

##### Enable a service for all users

```puppet
systemd::user_service { 'systemd-tmpfiles-clean.timer':
  enable => true,
  global => true,
}
```

##### Enable a particular user's service

```puppet
systemd::user_service { 'podman-auto-update.timer':
  ensure => true,
  enable => true,
  user   => 'steve',
}
```

##### Notify a user's service to restart it

```puppet
file{ '/home/steve/.config/systemd/user/podman-auto-update.timer':
  ensure  => file,
  content => ...,
  notify  => Systemd::User_service['steve-podman-auto-update.timer']
}

systemd::user_service { 'steve-podman-auto-update.timer':
  ensure => true,
  enable => true,
  unit   => 'podman-auto-update.timer',
  user   => 'steve',
}

@param unit Unit name to work on
@param ensure Should the unit be started or stopped. Can only be true if user is specified.
@param enable Should the unit be enabled or disabled
@param user User name of user whose unit should be acted upon. Mutually exclusive with
@param global Act globally for all users. Mutually exclusibe with `user`.
```

#### Parameters

The following parameters are available in the `systemd::user_service` defined type:

* [`unit`](#-systemd--user_service--unit)
* [`ensure`](#-systemd--user_service--ensure)
* [`enable`](#-systemd--user_service--enable)
* [`global`](#-systemd--user_service--global)
* [`user`](#-systemd--user_service--user)

##### <a name="-systemd--user_service--unit"></a>`unit`

Data type: `Systemd::Unit`



Default value: `$title`

##### <a name="-systemd--user_service--ensure"></a>`ensure`

Data type: `Variant[Boolean,Enum['stopped','running']]`



Default value: `false`

##### <a name="-systemd--user_service--enable"></a>`enable`

Data type: `Boolean`



Default value: `false`

##### <a name="-systemd--user_service--global"></a>`global`

Data type: `Boolean`



Default value: `false`

##### <a name="-systemd--user_service--user"></a>`user`

Data type: `Optional[String[1]]`



Default value: `undef`

## Resource types

### <a name="loginctl_user"></a>`loginctl_user`

An arbitrary name used as the identity of the resource.

#### Properties

The following properties are available in the `loginctl_user` type.

##### `linger`

Valid values: `enabled`, `disabled`

Whether linger is enabled for the user.

Default value: `disabled`

#### Parameters

The following parameters are available in the `loginctl_user` type.

* [`name`](#-loginctl_user--name)
* [`provider`](#-loginctl_user--provider)

##### <a name="-loginctl_user--name"></a>`name`

namevar

An arbitrary name used as the identity of the resource.

##### <a name="-loginctl_user--provider"></a>`provider`

The specific backend to use for this `loginctl_user` resource. You will seldom need to specify this --- Puppet will
usually discover the appropriate provider for your platform.

## Functions

### <a name="systemd--escape"></a>`systemd::escape`

Type: Puppet Language

Escape strings as systemd-escape does.

#### Examples

##### Escaping a string

```puppet
$result = systemd::escape('foo::bar')
```

##### Escaping a path

```puppet
$result = systemd::escape('/mnt/foobar',true)
```

#### `systemd::escape(String[1] $input, Boolean $path = false)`

The systemd::escape function.

Returns: `String` String

##### Examples

###### Escaping a string

```puppet
$result = systemd::escape('foo::bar')
```

###### Escaping a path

```puppet
$result = systemd::escape('/mnt/foobar',true)
```

##### `input`

Data type: `String[1]`

Input string

##### `path`

Data type: `Boolean`

Use path (-p) ornon-path  style escaping.

### <a name="systemd--systemd_escape"></a>`systemd::systemd_escape`

Type: Ruby 4.x API

Escape strings by call the `systemd-escape` command in the background.

#### `systemd::systemd_escape(String $input, Optional[Optional[Boolean]] $path)`

The systemd::systemd_escape function.

Returns: `String`

##### `input`

Data type: `String`

Input string

##### `path`

Data type: `Optional[Optional[Boolean]]`

Use path (-p) ornon-path  style escaping.

## Data types

### <a name="Systemd--CoredumpSettings"></a>`Systemd::CoredumpSettings`

Configurations for coredump.conf

* **See also**
  * https://www.freedesktop.org/software/systemd/man/coredump.conf.html

Alias of

```puppet
Struct[{
    Optional['Storage']         => Enum['none', 'external', 'journal'],
    Optional['Compress']        => Enum['yes','no'],
    Optional['ProcessSizeMax']  => Systemd::Unit::Amount,
    Optional['ExternalSizeMax'] => Systemd::Unit::Amount,
    Optional['JournalSizeMax']  => Systemd::Unit::Amount,
    Optional['MaxUse']          => Systemd::Unit::Amount,
    Optional['KeepFree']        => Systemd::Unit::Amount,
  }]
```

### <a name="Systemd--Dropin"></a>`Systemd::Dropin`

custom datatype that validates filenames/paths for valid systemd dropin files

Alias of `Pattern['^[^/]+\.conf$']`

### <a name="Systemd--JournaldSettings"></a>`Systemd::JournaldSettings`

Matches Systemd journald config Struct

Alias of

```puppet
Struct[{
    Optional['Storage']              => Variant[Enum['volatile','persistent','auto','none'],Systemd::JournaldSettings::Ensure],
    Optional['Compress']             => Variant[Enum['yes','no'], Systemd::Unit::Amount ,Systemd::JournaldSettings::Ensure],
    Optional['Seal']                 => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['SplitMode']            => Variant[Enum['uid','none'],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitInterval']    => Variant[Pattern[/^[0-9]+(s|min|h|ms|us)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitIntervalSec'] => Variant[Pattern[/^[0-9]+(s|min|h|ms|us)?$/],Systemd::JournaldSettings::Ensure],
    Optional['RateLimitBurst']       => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxUse']         => Variant[Systemd::Unit::AmountOrPercent,Systemd::JournaldSettings::Ensure],
    Optional['SystemKeepFree']       => Variant[Systemd::Unit::AmountOrPercent,Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxFileSize']    => Variant[Systemd::Unit::AmountOrPercent,Systemd::JournaldSettings::Ensure],
    Optional['SystemMaxFiles']       => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxUse']        => Variant[Systemd::Unit::AmountOrPercent ,Systemd::JournaldSettings::Ensure],
    Optional['RuntimeKeepFree']      => Variant[Systemd::Unit::AmountOrPercent ,Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxFileSize']   => Variant[Systemd::Unit::AmountOrPercent ,Systemd::JournaldSettings::Ensure],
    Optional['RuntimeMaxFiles']      => Variant[Integer[0], Pattern[/^[0-9]+$/],Systemd::JournaldSettings::Ensure],
    Optional['MaxFileSec']           => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['MaxRetentionSec']      => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['SyncIntervalSec']      => Variant[Pattern[/^[0-9]+(year|month|week|day|h|m)?$/],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToSyslog']      => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToKMsg']        => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToConsole']     => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['ForwardToWall']        => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelStore']        => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelSyslog']       => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelKMsg']         => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelConsole']      => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['MaxLevelWall']         => Variant[Enum['emerg','alert','crit','err','warning','notice','info','debug'],Integer[0,7],Systemd::JournaldSettings::Ensure],
    Optional['ReadKMsg']             => Variant[Enum['yes','no'],Systemd::JournaldSettings::Ensure],
    Optional['TTYPath']              => Variant[Stdlib::Absolutepath,Systemd::JournaldSettings::Ensure],
    Optional['LineMax']              => Variant[Systemd::Unit::Amount,Systemd::JournaldSettings::Ensure],
  }]
```

### <a name="Systemd--JournaldSettings--Ensure"></a>`Systemd::JournaldSettings::Ensure`

defines allowed ensure states for systemd-journald settings

Alias of `Struct[{ 'ensure' => Enum['present','absent'] }]`

### <a name="Systemd--LogindSettings"></a>`Systemd::LogindSettings`

Matches Systemd Login Manager Struct

Alias of

```puppet
Struct[{
    Optional['HandleHibernateKey']           => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitch']              => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitchDocked']        => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleLidSwitchExternalPower'] => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandlePowerKey']               => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HandleSuspendKey']             => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['HibernateKeyIgnoreInhibited']  => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['HoldoffTimeoutSec']            => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['IdleAction']                   => Variant[Enum['ignore','poweroff','reboot','halt','kexec','suspend','hibernate','hybrid-sleep','suspend-then-hibernate','lock'],Systemd::LogindSettings::Ensure],
    Optional['IdleActionSec']                => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['InhibitDelayMaxSec']           => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['InhibitorsMax']                => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['KillExcludeUsers']             => Variant[Array[String],Systemd::LogindSettings::Ensure],
    Optional['KillOnlyUsers']                => Variant[Array[String],Systemd::LogindSettings::Ensure],
    Optional['KillUserProcesses']            => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['LidSwitchIgnoreInhibited']     => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['NAutoVTs']                     => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['PowerKeyIgnoreInhibited']      => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['RemoveIPC']                    => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['ReserveVT']                    => Variant[Integer,Systemd::LogindSettings::Ensure],
    Optional['RuntimeDirectorySize']         => Variant[Systemd::Unit::AmountOrPercent ,Systemd::LogindSettings::Ensure],
    Optional['SessionsMax']                  => Variant[Systemd::Unit::Amount,Systemd::LogindSettings::Ensure],
    Optional['SuspendKeyIgnoreInhibited']    => Variant[Enum['yes','no'],Systemd::LogindSettings::Ensure],
    Optional['UserTasksMax']                 => Variant[Systemd::Unit::Amount,Systemd::LogindSettings::Ensure],
    Optional['StopIdleSessionSec']           => Variant[Systemd::Unit::Amount,Systemd::LogindSettings::Ensure]
  }]
```

### <a name="Systemd--LogindSettings--Ensure"></a>`Systemd::LogindSettings::Ensure`

defines allowed ensure states for systemd-logind settings

Alias of `Struct[{ 'ensure' => Enum['present','absent'] }]`

### <a name="Systemd--MachineInfoSettings"></a>`Systemd::MachineInfoSettings`

Matches Systemd machine-info (hostnamectl) file Struct

Alias of

```puppet
Struct[{
    Optional['PRETTY_HOSTNAME'] => String[1],
    Optional['ICON_NAME']       => String[1],
    Optional['CHASSIS']         => String[1],
    Optional['DEPLOYMENT']      => String[1],
    Optional['LOCATION']        => String[1],
    Optional['HARDWARE_VENDOR'] => String[1],
    Optional['HARDWARE_MODEL']  => String[1],
  }]
```

### <a name="Systemd--OomdSettings"></a>`Systemd::OomdSettings`

Configurations for oomd.conf

* **See also**
  * https://www.freedesktop.org/software/systemd/man/oomd.conf.html

Alias of

```puppet
Struct[{
    Optional['SwapUsedLimit']                    => Pattern[/^[0-9]+[%|‰|‱]$/],
    Optional['DefaultMemoryPressureLimit']       => Pattern[/^[0-9]+%$/],
    Optional['DefaultMemoryPressureDurationSec'] => Integer[0],
  }]
```

### <a name="Systemd--ServiceLimits"></a>`Systemd::ServiceLimits`

Deprecated - Matches Systemd Service Limit Struct

Alias of

```puppet
Struct[{
    Optional['LimitCPU']            => Pattern['^\d+(s|m|h|d|w|M|y)?(:\d+(s|m|h|d|w|M|y)?)?$'],
    Optional['LimitFSIZE']          => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitDATA']           => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitSTACK']          => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitCORE']           => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitRSS']            => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNOFILE']         => Variant[Integer[-1],Pattern['^(infinity|\d+(:(infinity|\d+))?)$']],
    Optional['LimitAS']             => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNPROC']          => Variant[Integer[-1],Pattern['^(infinity|\d+(:(infinity|\d+))?)$']],
    Optional['LimitMEMLOCK']        => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitLOCKS']          => Integer[1],
    Optional['LimitSIGPENDING']     => Integer[1],
    Optional['LimitMSGQUEUE']       => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNICE']           => Variant[Integer[0,40], Pattern['^(-\+([0-1]?[0-9]|20))|([0-3]?[0-9]|40)$']],
    Optional['LimitRTPRIO']         => Integer[0],
    Optional['LimitRTTIME']         => Pattern['^\d+(ms|s|m|h|d|w|M|y)?(:\d+(ms|s|m|h|d|w|M|y)?)?$'],
    Optional['CPUAccounting']       => Boolean,
    Optional['CPUShares']           => Integer[2,262144],
    Optional['StartupCPUShares']    => Integer[2,262144],
    Optional['CPUQuota']            => Pattern['^([1-9][0-9]*)%$'],
    Optional['MemoryAccounting']    => Boolean,
    Optional['MemoryLow']           => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['MemoryMin']           => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['MemoryHigh']          => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['MemoryMax']           => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['MemoryLimit']         => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['MemorySwapMax']       => Pattern['\A(infinity|\d+(K|M|G|T|%)?(:\d+(K|M|G|T|%)?)?)\z'],
    Optional['TasksAccounting']     => Boolean,
    Optional['TasksMax']            => Variant[Integer[1],Pattern['^(infinity|([1-9][0-9]?$|^100)%)$']],
    Optional['IOAccounting']        => Boolean,
    Optional['IOWeight']            => Integer[1,10000],
    Optional['StartupIOWeight']     => Integer[1,10000],
    Optional['IODeviceWeight']      => Array[Hash[Stdlib::Absolutepath, Integer[1,10000], 1, 1]],
    Optional['IOReadBandwidthMax']  => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOWriteBandwidthMax'] => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOReadIOPSMax']       => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['IOWriteIOPSMax']      => Array[Hash[Stdlib::Absolutepath, Pattern['^(\d+(K|M|G|T)?)$'], 1, 1]],
    Optional['DeviceAllow']         => String[1],
    Optional['DevicePolicy']        => Enum['auto','closed','strict'],
    Optional['Slice']               => String[1],
    Optional['Delegate']            => Boolean,
    Optional['OOMScoreAdjust']      => Integer[-1000,1000]
  }]
```

### <a name="Systemd--Unit"></a>`Systemd::Unit`

custom datatype that validates different filenames for systemd units and unit templates

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.unit.html

Alias of `Pattern[/^[a-zA-Z0-9:\-_.\\@%]+\.(service|socket|device|mount|automount|swap|target|path|timer|slice|scope)$/]`

### <a name="Systemd--Unit--Amount"></a>`Systemd::Unit::Amount`

Systemd definition of amount, often bytes or united bytes
Some man pages are lagging behind and only report support up to Tera.
https://github.com/systemd/systemd/blob/main/src/basic/format-util.c
shows support for Peta and Exa.

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.service.html
  * https://www.freedesktop.org/software/systemd/man/systemd.slice.html

Alias of `Variant[Integer[0], Pattern['\A(infinity|\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)\z']]`

### <a name="Systemd--Unit--AmountOrPercent"></a>`Systemd::Unit::AmountOrPercent`

Systemd definition of amount, often bytes or united bytes

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.service.html
  * https://www.freedesktop.org/software/systemd/man/systemd.slice.html

Alias of `Variant[Systemd::Unit::Amount, Systemd::Unit::Percent]`

### <a name="Systemd--Unit--Install"></a>`Systemd::Unit::Install`

Possible keys for the [Install] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.unit.html

Alias of

```puppet
Struct[{
    Optional['Alias']      => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['WantedBy']   => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['RequiredBy'] => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Also']       => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
  }]
```

### <a name="Systemd--Unit--Path"></a>`Systemd::Unit::Path`

Possible keys for the [Path] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.path.html

Alias of

```puppet
Struct[{
    Optional['PathExists']              => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['PathExistsGlob']          => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['PathChanged']             => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['PathModified']            => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['DirectoryNotEmpty']       => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['Unit']                    => Systemd::Unit,
    Optional['MakeDirectory']           => Boolean,
    Optional['DirectoryMode']           => Pattern[/\A[0-7]{1,4}\z/],
    Optional['TriggerLimitIntervalSec'] => String,
    Optional['TriggerLimitBurst']       => Integer[0],
  }]
```

### <a name="Systemd--Unit--Percent"></a>`Systemd::Unit::Percent`

Systemd definition of a percentage

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.service.html
  * https://www.freedesktop.org/software/systemd/man/systemd.slice.html

Alias of `Pattern['\A([0-9][0-9]?|100)%\z']`

### <a name="Systemd--Unit--Service"></a>`Systemd::Unit::Service`

Possible keys for the [Service] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.service.html
  * https://www.freedesktop.org/software/systemd/man/systemd.exec.html

Alias of

```puppet
Struct[{
    Optional['AmbientCapabilities']       => Variant[Pattern[/^CAP_[A-Z_]+$/],Array[Pattern[/^CAP_[A-Z_]+$/],1]],
    Optional['UMask']                     => String[3,4],
    Optional['User']                      => String[1],
    Optional['Group']                     => String[1],
    Optional['DynamicUser']               => Boolean,
    Optional['SupplementaryGroups']       => Variant[String[0],Array[String[0],1]],
    Optional['WorkingDirectory']          => String[0],
    Optional['Type']                      => Enum['simple', 'exec', 'forking', 'oneshot', 'dbus', 'notify', 'idle'],
    Optional['ExitType']                  => Enum['main', 'cgroup'],
    Optional['RemainAfterExit']           => Boolean,
    Optional['GuessMainPID']              => Boolean,
    Optional['PIDFile']                   => Stdlib::Unixpath,
    Optional['BusName']                   => String[1],
    Optional['ExecStart']                 => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStartPre']              => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStartPost']             => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecCondition']             => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecReload']                => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStop']                  => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStopPost']              => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['KillSignal']                => Pattern[/^SIG[A-Z]+$/],
    Optional['KillMode']                  => Enum['control-group', 'mixed', 'process', 'none'],
    Optional['Nice']                      => Variant[String[0,0],Integer[-20,19]],
    Optional['IOSchedulingClass']         => Enum['','realtime','best-effort','idle'],
    Optional['IOSchedulingPriority']      => Variant[String[0,0],Integer[0,7]],
    Optional['SyslogIdentifier']          => String,
    Optional['LogLevelMax']               => Enum['emerg','alert','crit','err','warning','notice','info','debug'],
    Optional['LimitCPU']                  => Pattern['^\d+(s|m|h|d|w|M|y)?(:\d+(s|m|h|d|w|M|y)?)?$'],
    Optional['LimitFSIZE']                => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitDATA']                 => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitSTACK']                => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitCORE']                 => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitRSS']                  => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNOFILE']               => Variant[Integer[-1],Pattern['^(infinity|\d+(:(infinity|\d+))?)$']],
    Optional['LimitAS']                   => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNPROC']                => Variant[Integer[-1],Pattern['^(infinity|\d+(:(infinity|\d+))?)$']],
    Optional['LimitMEMLOCK']              => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitLOCKS']                => Integer[1],
    Optional['LimitSIGPENDING']           => Integer[1],
    Optional['LimitMSGQUEUE']             => Pattern['^(infinity|((\d+(K|M|G|T|P|E)?(:\d+(K|M|G|T|P|E)?)?)))$'],
    Optional['LimitNICE']                 => Variant[Integer[0,40], Pattern['^(-\+([0-1]?[0-9]|20))|([0-3]?[0-9]|40)$']],
    Optional['LimitRTPRIO']               => Integer[0],
    Optional['LimitRTTIME']               => Pattern['^\d+(ms|s|m|h|d|w|M|y)?(:\d+(ms|s|m|h|d|w|M|y)?)?$'],
    Optional['CPUAccounting']             => Boolean,
    Optional['CPUShares']                 => Integer[2,262144],
    Optional['StartupCPUShares']          => Integer[2,262144],
    Optional['CPUQuota']                  => Pattern['^([1-9][0-9]*)%$'], # bigger than 100% is okay.
    Optional['MemoryAccounting']          => Boolean,
    Optional['MemoryLow']                 => Systemd::Unit::AmountOrPercent,
    Optional['MemoryMin']                 => Systemd::Unit::AmountOrPercent,
    Optional['MemoryHigh']                => Systemd::Unit::AmountOrPercent,
    Optional['MemoryMax']                 => Systemd::Unit::AmountOrPercent,
    Optional['MemoryLimit']               => Systemd::Unit::Amount,
    Optional['MemorySwapMax']             => Systemd::Unit::Amount,
    Optional['TasksAccounting']           => Boolean,
    Optional['TasksMax']                  => Systemd::Unit::AmountOrPercent,
    Optional['IOAccounting']              => Boolean,
    Optional['IOWeight']                  => Integer[1,10000],
    Optional['StartupIOWeight']           => Integer[1,10000],
    Optional['IODeviceWeight']            => Variant[Tuple[Stdlib::Absolutepath, Integer[1,10000]],Array[Tuple[Stdlib::Absolutepath, Integer[1,10000]]]],
    Optional['IOReadBandwidthMax']        => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOWriteBandwidthMax']       => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOReadIOPSMax']             => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOWriteIOPSMax']            => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['DeviceAllow']               => String[1],
    Optional['DevicePolicy']              => Enum['auto','closed','strict'],
    Optional['Slice']                     => String[1],
    Optional['Delegate']                  => Boolean,
    Optional['RestartSec']                => String,
    Optional['TimeoutStartSec']           => String,
    Optional['TimeoutStopSec']            => String,
    Optional['TimeoutAbortSec']           => String,
    Optional['TimeoutSec']                => String,
    Optional['TimeoutStartFailureMode']   => Enum['terminate', 'abort', 'kill'],
    Optional['TimeoutStopFailureMode']    => Enum['terminate', 'abort', 'kill'],
    Optional['RuntimeMaxSec']             => String,
    Optional['RuntimeRandomizedExtraSec'] => String,
    Optional['WatchdogSec']               => String,
    Optional['Restart']                   => Enum['no', 'on-success', 'on-failure', 'on-abnormal', 'on-watchdog', 'on-abort', 'always'],
    Optional['SuccessExitStatus']         => String,
    Optional['RestartPreventExitStatus']  => String,
    Optional['RestartForceExitStatus']    => String,
    Optional['RootDirectoryStartOnly']    => Boolean,
    Optional['NonBlocking']               => Boolean,
    Optional['NotifyAccess']              => Enum['none', 'default', 'main', 'exec',  'all'],
    Optional['OOMPolicy']                 => Enum['continue', 'stop','kill'],
    Optional['OOMScoreAdjust']            => Integer[-1000,1000],
    Optional['Environment']               => Variant[String[0],Array[String[1],1]],
    Optional['EnvironmentFile']           => Variant[
      Stdlib::Unixpath,Pattern[/-\/.+/],
      Array[Variant[Stdlib::Unixpath,Pattern[/-\/.+/]],1],
    ],
    Optional['StandardOutput']            => Variant[Enum['inherit','null','tty','journal','kmsg','journal+console','kmsg+console','socket'],Pattern[/\A(file:|append:|truncate:).+$\z/]],
    Optional['StandardError']             => Variant[Enum['inherit','null','tty','journal','kmsg','journal+console','kmsg+console','socket'],Pattern[/\A(file:|append:|truncate:).+$\z/]],
    Optional['StandardInput']             => Variant[Enum['null','tty','tty-force','tty-fail','data','socket'], Pattern[/\A(file:|fd:).+$\z/]],
    Optional['PrivateTmp']                => Boolean,
    Optional['RuntimeDirectory']          => String,
    Optional['RuntimeDirectoryMode']      => Stdlib::Filemode,
    Optional['StateDirectory']            => String,
    Optional['LogsDirectory']             => String,
    Optional['LogsDirectoryMode']         => Stdlib::Filemode,
    Optional['ProtectSystem']             => Variant[Boolean, Enum['full', 'strict']],
    Optional['ProtectHome']               => Variant[Boolean, Enum['read-only', 'tmpfs']],
    Optional['BindPaths']                 => Variant[Stdlib::Unixpath,Pattern[/-\/.+/], Array[Variant[Stdlib::Unixpath,Pattern[/-\/.+/]],1]],
    Optional['BindReadOnlyPaths']         => Variant[Stdlib::Unixpath,Pattern[/-\/.+/], Array[Variant[Stdlib::Unixpath,Pattern[/-\/.+/]],1]],
    Optional['PrivateDevices']            => Boolean,
    Optional['RemoveIPC']                 => Boolean,
    Optional['ProtectKernelModules']      => Boolean,
    Optional['ProtectKernelTunables']     => Boolean,
    Optional['ProtectControlGroups']      => Boolean,
    Optional['RestrictRealtime']          => Boolean,
    Optional['RestrictAddressFamilies']   => Variant[Enum['AF_UNIX', 'AF_INET', 'AF_INET6', 'AF_NETLINK', 'none'], Array[Enum['AF_UNIX', 'AF_INET', 'AF_INET6', 'AF_NETLINK', 'none']]],
    Optional['RestrictNamespaces']        => Variant[Boolean, Enum['ipc', 'net', 'mnt', 'pid', 'user', 'uts', 'cgroup'], Array[Enum['ipc', 'net', 'mnt', 'pid', 'user', 'uts', 'cgroup']]],
    Optional['SystemCallArchitectures']   => Variant[String, Array[String]],
    Optional['SystemCallFilter']          => Variant[String, Array[String]],
    Optional['SystemCallErrorNumber']     => String,
    Optional['ProtectClock']              => Boolean,
    Optional['PrivateUsers']              => Boolean,
    Optional['ProtectKernelLogs']         => Boolean,
    Optional['ProtectProc']               => Enum['noaccess', 'invisible', 'ptraceable', 'default'],
    Optional['ProtectHostname']           => Boolean,
    Optional['RestrictSUIDSGID']          => Boolean,
    Optional['CapabilityBoundingSet']     => Variant[String, Array[String]],
    Optional['NoNewPrivileges']           => Boolean,
    Optional['LockPersonality']           => Boolean,
    Optional['NetworkNamespacePath']      => Stdlib::Unixpath,
    Optional['MemoryDenyWriteExecute']    => Boolean,
  }]
```

### <a name="Systemd--Unit--Service--Exec"></a>`Systemd::Unit::Service::Exec`

Possible strings for ExecStart, ExecStartPrep, ...

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.service.html
  * https://www.freedesktop.org/software/systemd/man/systemd.exec.html

Alias of `Variant[Enum[''], Pattern[/^[@\-:]*(\+|!|!!)?[@\-:]*\/.*/], Pattern[/^[@\-:]*(\+|!|!!)?[@\-:]*[^\/]*(\s.*)?$/]]`

### <a name="Systemd--Unit--Slice"></a>`Systemd::Unit::Slice`

Possible keys for the [Slice] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.slice.html
  * https://www.freedesktop.org/software/systemd/man/systemd.resource-control.html

Alias of

```puppet
Struct[{
    Optional['CPUAccounting']       => Boolean,
    Optional['CPUQuota']            => Pattern['^([1-9][0-9]*)%$'], # bigger than 100% is okay.
    Optional['CPUShares']           => Integer[2,262144],
    Optional['CPUWeight']           => Variant[Enum['idle'],Integer[1,10000]],
    Optional['Delegate']            => Boolean,
    Optional['DeviceAllow']         => Pattern['^(/dev/)|(char-)|(block-).*$'],
    Optional['DevicePolicy']        => Enum['auto','closed','strict'],
    Optional['IOAccounting']        => Boolean,
    Optional['IODeviceWeight']      => Variant[Tuple[Stdlib::Absolutepath, Integer[1,10000]],Array[Tuple[Stdlib::Absolutepath, Integer[1,10000]]]],
    Optional['IOReadBandwidthMax']  => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOReadIOPSMax']       => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOWeight']            => Integer[1,10000],
    Optional['IOWriteBandwidthMax'] => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IOWriteIOPSMax']      => Variant[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount],Array[Tuple[Stdlib::Absolutepath, Systemd::Unit::Amount]]],
    Optional['IPAccounting']        => Boolean,
    Optional['MemoryAccounting']    => Boolean,
    Optional['MemoryHigh']          => Systemd::Unit::AmountOrPercent,
    Optional['MemoryLimit']         => Systemd::Unit::AmountOrPercent, # depprecated in systemd
    Optional['MemoryLow']           => Systemd::Unit::AmountOrPercent,
    Optional['MemoryMax']           => Systemd::Unit::AmountOrPercent,
    Optional['MemoryMin']           => Systemd::Unit::AmountOrPercent,
    Optional['MemorySwapMax']       => Systemd::Unit::AmountOrPercent,
    Optional['Slice']               => String[1],
    Optional['StartupCPUShares']    => Integer[2,262144],
    Optional['StartupIOWeight']     => Integer[1,10000],
    Optional['TasksAccounting']     => Boolean,
    Optional['TasksMax']            => Systemd::Unit::AmountOrPercent,
  }]
```

### <a name="Systemd--Unit--Socket"></a>`Systemd::Unit::Socket`

Possible keys for the [Socket] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.socket.html

Alias of

```puppet
Struct[{
    Optional['ListenStream']            => Variant[Stdlib::Port,String[1]],
    Optional['ListenDatagram']          => Variant[Stdlib::Port,String[1]],
    Optional['ListenSequentialPacket']  => Variant[Stdlib::Port,String[1]],
    Optional['ListenFIFO']              => Stdlib::Unixpath,
    Optional['ListenSpecial']           => Stdlib::Unixpath,
    Optional['ListenNetlink']           => String[1],
    Optional['ListenMessageQueue']      => Pattern[/\A\/.*\z/],
    Optional['ListenUSBFunction']       => Stdlib::Unixpath,
    Optional['SocketProtocol']          => Enum['udplite', 'sctp'],
    Optional['BindIPv6Only']            => Enum['default', 'both', 'ipv6-only'],
    Optional['Backlog']                 => Integer[0],
    Optional['BindToDevice']            => String[1],
    Optional['SocketUser']              => String[1],
    Optional['SocketGroup']             => String[1],
    Optional['SocketMode']              => Stdlib::Filemode,
    Optional['DirectoryMode']           => Stdlib::Filemode,
    Optional['Accept']                  => Boolean,
    Optional['Writable']                => Boolean,
    Optional['FlushPending']            => Boolean,
    Optional['MaxConnections']          => Integer[0],
    Optional['MaxConnectionsPerSource'] => Integer[0],
    Optional['KeepAlive']               => Boolean,
    Optional['KeepAliveTimeSec']        => Integer[0],
    Optional['KeepAliveIntervalSec']    => Integer[0],
    Optional['KeepAliveProbes']         => Integer[0],
    Optional['NoDelay']                 => Boolean,
    Optional['Priority']                => Integer,
    Optional['DeferAcceptSec']          => Integer[0],
    Optional['ReceiveBuffer']           => Variant[Integer[0],String[1]],
    Optional['SendBuffer']              => Variant[Integer[0],String[1]],
    Optional['IPTOS']                   => Variant[Integer,Enum['low-delay', 'throughput', 'reliability', 'low-cost']],
    Optional['IPTTL']                   => Integer[0],
    Optional['Mark']                    => String[1],
    Optional['ReusePort']               => Boolean,
    Optional['SmackLabel']              => String[1],
    Optional['SmackLabelIPIn']          => String[1],
    Optional['SmackLabelIPOut']         => String[1],
    Optional['SELinuxContextFromNet']   => Boolean,
    Optional['PipeSize']                => Variant[Integer[0],String[1]],
    Optional['FreeBind']                => Boolean,
    Optional['Transparent']             => Boolean,
    Optional['Broadcast']               => Boolean,
    Optional['PassCredentials']         => Boolean,
    Optional['PassSecurity']            => Boolean,
    Optional['PassPacketInfo']          => Boolean,
    Optional['Timestamping']            => Enum['off', 'us', 'usec', 'ns'],
    Optional['TCPCongestion']           => Enum['westwood', 'veno', 'cubic', 'lp'],
    Optional['ExecStartPre']            => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStartPost']           => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStopPre']             => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStopPost']            => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['TimeoutSec']              => String[1],
    Optional['Service']                 => Systemd::Unit,
    Optional['RemoveOnStop']            => Boolean,
    Optional['Symlinks']                => Variant[Stdlib::Unixpath,Array[Stdlib::Unixpath,1]],
    Optional['FileDescriptorName']      => String[1,255],
    Optional['TriggerLimitIntervalSec'] => String[1],
    Optional['TriggerLimitBurst']       => Integer[0],
  }]
```

### <a name="Systemd--Unit--Timer"></a>`Systemd::Unit::Timer`

Possible keys for the [Timer] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.timer.html

Alias of

```puppet
Struct[{
    Optional['OnActiveSec']        => Systemd::Unit::Timespan,
    Optional['OnBootSec']          => Systemd::Unit::Timespan,
    Optional['OnStartUpSec']       => Systemd::Unit::Timespan,
    Optional['OnUnitActiveSec']    => Systemd::Unit::Timespan,
    Optional['OnUnitInactiveSec']  => Systemd::Unit::Timespan,
    Optional['OnCalendar']         => Systemd::Unit::Timespan,
    Optional['AccuracySec']        => Variant[Integer[0],String],
    Optional['RandomizedDelaySec'] => Variant[Integer[0],String],
    Optional['FixedRandomDelay']   => Boolean,
    Optional['OnClockChange']      => Boolean,
    Optional['OnTimezoneChange']   => Boolean,
    Optional['Unit']               => Systemd::Unit,
    Optional['Persistent']         => Boolean,
    Optional['WakeSystem']         => Boolean,
    Optional['RemainAfterElapse']  => Boolean,
  }]
```

### <a name="Systemd--Unit--Timespan"></a>`Systemd::Unit::Timespan`

Timer specification for systemd time spans, e.g. timers.

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.time.html

Alias of `Variant[Integer[0], String, Array[Variant[Integer[0],String]]]`

### <a name="Systemd--Unit--Unit"></a>`Systemd::Unit::Unit`

Possible keys for the [Unit] section of a unit file

* **See also**
  * https://www.freedesktop.org/software/systemd/man/systemd.unit.html

Alias of

```puppet
Struct[{
    Optional['Description']               => Variant[String,Array[String,1]],
    Optional['Documentation']             => Variant[String,Array[String,1]],
    Optional['Wants']                     => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Requires']                  => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Requisite']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['BindsTo']                   => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PartOf']                    => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Upholds']                   => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Conflicts']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Before']                    => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['After']                     => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['OnFailure']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['OnSuccess']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PropagatesReloadTo']        => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['ReloadPropagatedFrom']      => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PropagatesStopTo']          => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['StopPropagatedFrom']        => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['JoinsNamespaceOf']          => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['RequiresMountsFor']         => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['OnSuccessJobMode']          => Enum['fail', 'replace', 'replace-irreversibly', 'isolate', 'flush', 'ignore-dependencies', 'ignore-requirements'],
    Optional['OnFailureJobMode']          => Enum['fail', 'replace', 'replace-irreversibly', 'isolate', 'flush', 'ignore-dependencies', 'ignore-requirements'],
    Optional['IgnoreOnIsolate']           => Boolean,
    Optional['StopWhenUnneeded']          => Boolean,
    Optional['RefuseManualStart']         => Boolean,
    Optional['RefuseManualStop']          => Boolean,
    Optional['AllowIsolate']              => Boolean,
    Optional['DefaultDependencies']       => Boolean,
    Optional['SurviveFinalKillSignal']    => Boolean,
    Optional['CollectMode']               => Enum['inactive', 'inactive-or-failed'],
    Optional['FailureAction']             => Enum['none', 'reboot', 'reboot-force', 'reboot-immediate', 'poweroff', 'poweroff-force', 'poweroff-immediate', 'exit', 'exit-force', 'soft-reboot', 'soft-reboot-force', 'kexec', 'kexec-force', 'halt', 'halt-force', 'halt-immediate'],
    Optional['SuccessAction']             => Enum['none', 'reboot', 'reboot-force', 'reboot-immediate', 'poweroff', 'poweroff-force', 'poweroff-immediate', 'exit', 'exit-force', 'soft-reboot', 'soft-reboot-force', 'kexec', 'kexec-force', 'halt', 'halt-force', 'halt-immediate'],
    Optional['FailureActionExitStatus']   => Variant[Enum[''],Integer[0, 255]],
    Optional['SuccessActionExitStatus']   => Variant[Enum[''],Integer[0, 255]],
    # Conditions and Asserts
    Optional['AssertPathExists']          => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['AssertPathIsDirectory']     => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathExists']       => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathIsDirectory']  => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathIsMountPoint'] => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['StartLimitIntervalSec']     => String[1],
    Optional['StartLimitBurst']           => Integer[1],
  }]
```

## Tasks

### <a name="systemctl_show"></a>`systemctl_show`

Get systemctl show output of a unit

**Supports noop?** false

#### Parameters

##### `bin_path`

Data type: `String[1]`

Path to systemctl binary

##### `properties`

Data type: `Array[String[1]]`

Properties to retrieve from the unit

##### `unit_name`

Data type: `String[1]`

Name of the unit

