# == Class: iop::service_vulnerability_frontend
#
# Install and configure the Vulnerability frontend assets
#
# === Parameters:
#
# $image::  The container image
#
# $ensure:: Ensure frontend asserts are present or absent
#
class iop::service_vulnerability_frontend (
  String[1] $image = 'quay.io/iop/vulnerability-frontend:latest',
  Enum['present', 'absent'] $ensure = 'present',
) {
  ensure_resource('file', '/var/lib/foreman/public/assets/apps', { 'ensure' => 'directory' })

  iop_frontend { '/var/lib/foreman/public/assets/apps/vulnerability':
    ensure => $ensure,
    image  => $image,
  }
}
