# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Defined types

* [`concat`](#concat): Manages a file, compiled from one or more text fragments.
* [`concat::fragment`](#concat--fragment): Manages a fragment of text to be compiled into a file.

### Resource types

* [`concat_file`](#concat_file): Generates a file with content from fragments sharing a common unique tag.
* [`concat_fragment`](#concat_fragment): Manages the fragment.

## Defined types

### <a name="concat"></a>`concat`

Manages a file, compiled from one or more text fragments.

#### Examples

##### 

```puppet
concat { '/tmp/concat':
  ensure => present,
  owner  => 'root',
  group  => 'root',
  mode   => '0644',
}
```

#### Parameters

The following parameters are available in the `concat` defined type:

* [`backup`](#-concat--backup)
* [`ensure`](#-concat--ensure)
* [`ensure_newline`](#-concat--ensure_newline)
* [`format`](#-concat--format)
* [`force`](#-concat--force)
* [`group`](#-concat--group)
* [`mode`](#-concat--mode)
* [`order`](#-concat--order)
* [`owner`](#-concat--owner)
* [`path`](#-concat--path)
* [`replace`](#-concat--replace)
* [`selinux_ignore_defaults`](#-concat--selinux_ignore_defaults)
* [`selrange`](#-concat--selrange)
* [`selrole`](#-concat--selrole)
* [`seltype`](#-concat--seltype)
* [`seluser`](#-concat--seluser)
* [`show_diff`](#-concat--show_diff)
* [`validate_cmd`](#-concat--validate_cmd)
* [`warn`](#-concat--warn)
* [`create_empty_file`](#-concat--create_empty_file)

##### <a name="-concat--backup"></a>`backup`

Data type: `Variant[Boolean, String]`

Specifies whether (and how) to back up the destination file before overwriting it. Your value gets passed on to Puppet's native file
resource for execution. Valid options: true, false, or a string representing either a target filebucket or a filename extension
beginning with ".".

Default value: `'puppet'`

##### <a name="-concat--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the destination file should exist. Setting to 'absent' tells Puppet to delete the destination file if it exists, and
negates the effect of any other parameters.

Default value: `'present'`

##### <a name="-concat--ensure_newline"></a>`ensure_newline`

Data type: `Boolean`

Specifies whether to add a line break at the end of each fragment that doesn't already end in one.

Default value: `false`

##### <a name="-concat--format"></a>`format`

Data type: `Enum['plain', 'yaml', 'json', 'json-array', 'json-pretty', 'json-array-pretty']`

Specify what data type to merge the fragments as. Valid options: 'plain', 'yaml', 'json', 'json-array', 'json-pretty',
'json-array-pretty'.

Default value: `'plain'`

##### <a name="-concat--force"></a>`force`

Data type: `Boolean`

Specifies whether to merge data structures, keeping the values with higher order. Used when format is specified as a value other than
'plain'.

Default value: `false`

##### <a name="-concat--group"></a>`group`

Data type: `Optional[Variant[String, Integer]]`

Specifies a permissions group for the destination file. Valid options: a string containing a group name or integer containing a gid.

Default value: `undef`

##### <a name="-concat--mode"></a>`mode`

Data type: `String`

Specifies the permissions mode of the destination file. Valid options: a string containing a permission mode value in octal notation.

Default value: `'0644'`

##### <a name="-concat--order"></a>`order`

Data type: `Enum['alpha','numeric']`

Specifies a method for sorting your fragments by name within the destination file. You can override this setting for individual
fragments by adjusting the order parameter in their concat::fragment declarations.

Default value: `'alpha'`

##### <a name="-concat--owner"></a>`owner`

Data type: `Optional[Variant[String, Integer]]`

Specifies the owner of the destination file. Valid options: a string containing a username or integer containing a uid.

Default value: `undef`

##### <a name="-concat--path"></a>`path`

Data type: `Stdlib::Absolutepath`

Specifies a destination file for the combined fragments.

Default value: `$name`

##### <a name="-concat--replace"></a>`replace`

Data type: `Boolean`

Specifies whether to overwrite the destination file if it already exists.

Default value: `true`

##### <a name="-concat--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Data type: `Optional[Boolean]`

See the file type's selinux_ignore_defaults documentention:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selinux_ignore_defaults

Default value: `undef`

##### <a name="-concat--selrange"></a>`selrange`

Data type: `Optional[String]`

See the file type's selrange documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrange

Default value: `undef`

##### <a name="-concat--selrole"></a>`selrole`

Data type: `Optional[String]`

See the file type's selrole documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrole

Default value: `undef`

##### <a name="-concat--seltype"></a>`seltype`

Data type: `Optional[String]`

See the file type's seltype documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seltype

Default value: `undef`

##### <a name="-concat--seluser"></a>`seluser`

Data type: `Optional[String]`

See the file type's seluser documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seluser

Default value: `undef`

##### <a name="-concat--show_diff"></a>`show_diff`

Data type: `Boolean`

Specifies whether to set the show_diff parameter for the file resource. Useful for hiding secrets stored in hiera from insecure
reporting methods.

Default value: `true`

##### <a name="-concat--validate_cmd"></a>`validate_cmd`

Data type: `Optional[String]`

Specifies a validation command to apply to the destination file.

Default value: `undef`

##### <a name="-concat--warn"></a>`warn`

Data type: `Variant[Boolean, String]`

Specifies whether to add a header message at the top of the destination file. Valid options: the booleans true and false, or a string
to serve as the header.
If you set 'warn' to true, concat adds the following line with an order of 0:
`# This file is managed by Puppet. DO NOT EDIT.`
Before 2.0.0, this parameter would add a newline at the end of the warn message. To improve flexibilty, this was removed. Please add
it explicitly if you need it.

Default value: `false`

##### <a name="-concat--create_empty_file"></a>`create_empty_file`

Data type: `Boolean`

Specifies whether to create an empty file if no fragments are defined. Defaults to true.

Default value: `true`

### <a name="concat--fragment"></a>`concat::fragment`

Manages a fragment of text to be compiled into a file.

#### Parameters

The following parameters are available in the `concat::fragment` defined type:

* [`content`](#-concat--fragment--content)
* [`order`](#-concat--fragment--order)
* [`source`](#-concat--fragment--source)
* [`target`](#-concat--fragment--target)

##### <a name="-concat--fragment--content"></a>`content`

Data type: `Optional[Variant[Sensitive[String], String, Deferred]]`

Supplies the content of the fragment. Note: You must supply either a content parameter or a source parameter.
Allows a String or a Deferred function which returns a String.

Default value: `undef`

##### <a name="-concat--fragment--order"></a>`order`

Data type: `Variant[String, Integer]`

Reorders your fragments within the destination file. Fragments that share the same order number are ordered by name. The string
option is recommended.

Default value: `'10'`

##### <a name="-concat--fragment--source"></a>`source`

Data type: `Optional[Variant[String, Array]]`

Specifies a file to read into the content of the fragment. Note: You must supply either a content parameter or a source parameter.
Valid options: a string or an array, containing one or more Puppet URLs.

Default value: `undef`

##### <a name="-concat--fragment--target"></a>`target`

Data type: `String`

Specifies the destination file of the fragment. Valid options: a string containing the path or title of the parent concat resource.

## Resource types

### <a name="concat_file"></a>`concat_file`

Generates a file with content from fragments sharing a common unique tag.

#### Examples

##### 

```puppet
Concat_fragment <<| tag == 'unique_tag' |>>

concat_file { '/tmp/file':
  tag            => 'unique_tag', # Optional. Default to undef
  path           => '/tmp/file',  # Optional. If given it overrides the resource name
  owner          => 'root',       # Optional. Default to undef
  group          => 'root',       # Optional. Default to undef
  mode           => '0644'        # Optional. Default to undef
  order          => 'numeric'     # Optional, Default to 'numeric'
  ensure_newline => false         # Optional, Defaults to false
}
```

#### Properties

The following properties are available in the `concat_file` type.

##### `ensure`

Valid values: `present`, `absent`

Specifies whether the destination file should exist. Setting to 'absent' tells Puppet to delete the destination file if it exists, and
negates the effect of any other parameters.

Default value: `present`

#### Parameters

The following parameters are available in the `concat_file` type.

* [`backup`](#-concat_file--backup)
* [`create_empty_file`](#-concat_file--create_empty_file)
* [`ensure_newline`](#-concat_file--ensure_newline)
* [`force`](#-concat_file--force)
* [`format`](#-concat_file--format)
* [`group`](#-concat_file--group)
* [`mode`](#-concat_file--mode)
* [`order`](#-concat_file--order)
* [`owner`](#-concat_file--owner)
* [`path`](#-concat_file--path)
* [`replace`](#-concat_file--replace)
* [`selinux_ignore_defaults`](#-concat_file--selinux_ignore_defaults)
* [`selrange`](#-concat_file--selrange)
* [`selrole`](#-concat_file--selrole)
* [`seltype`](#-concat_file--seltype)
* [`seluser`](#-concat_file--seluser)
* [`show_diff`](#-concat_file--show_diff)
* [`tag`](#-concat_file--tag)
* [`validate_cmd`](#-concat_file--validate_cmd)

##### <a name="-concat_file--backup"></a>`backup`

Specifies whether (and how) to back up the destination file before overwriting it. Your value gets passed on to Puppet's
native file
resource for execution. Valid options: true, false, or a string representing either a target filebucket or a filename
extension
beginning with ".".'

##### <a name="-concat_file--create_empty_file"></a>`create_empty_file`

Valid values: `true`, `false`, `yes`, `no`

Specifies whether to create an empty file if no fragments are defined.

Default value: `true`

##### <a name="-concat_file--ensure_newline"></a>`ensure_newline`

Valid values: `true`, `false`, `yes`, `no`

Specifies whether to add a line break at the end of each fragment that doesn't already end in one.

Default value: `false`

##### <a name="-concat_file--force"></a>`force`

Valid values: `true`, `false`, `yes`, `no`

Specifies whether to merge data structures, keeping the values with higher order.

Default value: `false`

##### <a name="-concat_file--format"></a>`format`

Valid values: `plain`, `yaml`, `json`, `json-array`, `json-pretty`, `json-array-pretty`

Specify what data type to merge the fragments as. Valid options: 'plain', 'yaml', 'json', 'json-array', 'json-pretty',
'json-array-pretty'.

Default value: `plain`

##### <a name="-concat_file--group"></a>`group`

Specifies a permissions group for the destination file. Valid options: a string containing a group name or integer
containing a
gid.

##### <a name="-concat_file--mode"></a>`mode`

Specifies the permissions mode of the destination file. Valid options: a string containing a permission mode value in
octal notation.

##### <a name="-concat_file--order"></a>`order`

Valid values: `alpha`, `numeric`

Specifies a method for sorting your fragments by name within the destination file. You can override this setting for
individual
fragments by adjusting the order parameter in their concat::fragment declarations.

Default value: `numeric`

##### <a name="-concat_file--owner"></a>`owner`

Specifies the owner of the destination file. Valid options: a string containing a username or integer containing a uid.

##### <a name="-concat_file--path"></a>`path`

Specifies a destination file for the combined fragments. Valid options: a string containing an absolute path. Default
value: the
title of your declared resource.

##### <a name="-concat_file--replace"></a>`replace`

Valid values: `true`, `false`, `yes`, `no`

Specifies whether to overwrite the destination file if it already exists.

Default value: `true`

##### <a name="-concat_file--selinux_ignore_defaults"></a>`selinux_ignore_defaults`

Valid values: `true`, `false`, `yes`, `no`

See the file type's selinux_ignore_defaults documentention:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selinux_ignore_defaults.

##### <a name="-concat_file--selrange"></a>`selrange`

See the file type's selrange documentation:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrange

##### <a name="-concat_file--selrole"></a>`selrole`

See the file type's selrole documentation:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrole

##### <a name="-concat_file--seltype"></a>`seltype`

See the file type's seltype documentation:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seltype

##### <a name="-concat_file--seluser"></a>`seluser`

See the file type's seluser documentation:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seluser

##### <a name="-concat_file--show_diff"></a>`show_diff`

Valid values: `true`, `false`, `yes`, `no`

Specifies whether to set the show_diff parameter for the file resource. Useful for hiding secrets stored in hiera from
insecure
reporting methods.

##### <a name="-concat_file--tag"></a>`tag`

Required. Specifies a unique tag reference to collect all concat_fragments with the same tag.

##### <a name="-concat_file--validate_cmd"></a>`validate_cmd`

Specifies a validation command to apply to the destination file. Requires Puppet version 3.5 or newer. Valid options: a
string to
be passed to a file resource.

### <a name="concat_fragment"></a>`concat_fragment`

Manages the fragment.

#### Examples

##### 

```puppet
# The example is based on exported resources.

concat_fragment { "uniqe_name_${::fqdn}":
  tag => 'unique_name',
  order => 10, # Optional. Default to 10
  content => 'some content' # OR
  # content => template('template.erb')
  source  => 'puppet:///path/to/file'
}
```

#### Parameters

The following parameters are available in the `concat_fragment` type.

* [`content`](#-concat_fragment--content)
* [`name`](#-concat_fragment--name)
* [`order`](#-concat_fragment--order)
* [`source`](#-concat_fragment--source)
* [`tag`](#-concat_fragment--tag)
* [`target`](#-concat_fragment--target)

##### <a name="-concat_fragment--content"></a>`content`

Supplies the content of the fragment. Note: You must supply either a content parameter or a source parameter. Valid
options: a string

##### <a name="-concat_fragment--name"></a>`name`

namevar

Name of resource.

##### <a name="-concat_fragment--order"></a>`order`

Reorders your fragments within the destination file. Fragments that share the same order number are ordered by name. The
string
option is recommended.

Default value: `10`

##### <a name="-concat_fragment--source"></a>`source`

Specifies a file to read into the content of the fragment. Note: You must supply either a content parameter or a source
parameter.
Valid options: a string or an array, containing one or more Puppet URLs.

##### <a name="-concat_fragment--tag"></a>`tag`

Specifies a unique tag to be used by concat_file to reference and collect content.

##### <a name="-concat_fragment--target"></a>`target`

Required. Specifies the destination file of the fragment. Valid options: a string containing the path or title of the
parent
concat_file resource.

