# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`tftp`](#tftp): Installs and configures a TFTP server

#### Private Classes

* `tftp::config`: Configure TFTP
* `tftp::install`: Install TFTP
* `tftp::service`: TFTP service

## Classes

### <a name="tftp"></a>`tftp`

Installs and configures a TFTP server

#### Examples

##### Simple usage

```puppet
include tftp
```

##### Configure a TFTP server with a non-default root directory

```puppet
class { 'tftp':
  root => '/tftpboot',
}
```

##### Configure a TFTP server with non-default package name

```puppet
class { 'tftp:'
  package => 'tftp-hpa-destruct',
}
```

#### Parameters

The following parameters are available in the `tftp` class:

* [`root`](#-tftp--root)
* [`package`](#-tftp--package)
* [`syslinux_package`](#-tftp--syslinux_package)
* [`manage_syslinux_package`](#-tftp--manage_syslinux_package)
* [`manage_root_dir`](#-tftp--manage_root_dir)
* [`service`](#-tftp--service)
* [`service_provider`](#-tftp--service_provider)

##### <a name="-tftp--root"></a>`root`

Data type: `Stdlib::Absolutepath`

Configures the root directory for the TFTP server

##### <a name="-tftp--package"></a>`package`

Data type: `String`

Name of the TFTP server package

##### <a name="-tftp--syslinux_package"></a>`syslinux_package`

Data type: `Variant[String, Array[String]]`

Name of the syslinux package, essential for pxe boot

##### <a name="-tftp--manage_syslinux_package"></a>`manage_syslinux_package`

Data type: `Boolean`

manages the syslinux package, defaults to true

##### <a name="-tftp--manage_root_dir"></a>`manage_root_dir`

Data type: `Boolean`

manages the root dir, which tftpd will serve, defaults to true

##### <a name="-tftp--service"></a>`service`

Data type: `Optional[String]`

Name of the TFTP service, when daemon is true

Default value: `undef`

##### <a name="-tftp--service_provider"></a>`service_provider`

Data type: `Optional[String]`

Override TFTP service provider, when daemon is true

Default value: `undef`

