# @summary Possible keys for the [Socket] section of a unit file
# @see https://www.freedesktop.org/software/systemd/man/systemd.socket.html
#
type Systemd::Unit::Socket = Struct[
  {
    Optional['ListenStream']            => Variant[Stdlib::Port,String[1]],
    Optional['ListenDatagram']          => Variant[Stdlib::Port,String[1]],
    Optional['ListenSequentialPacket']  => Variant[Stdlib::Port,String[1]],
    Optional['ListenFIFO']              => Stdlib::Unixpath,
    Optional['ListenSpecial']           => Stdlib::Unixpath,
    Optional['ListenNetlink']           => String[1],
    Optional['ListenMessageQueue']      => Pattern[/\A\/.*\z/],
    Optional['ListenUSBFunction']       => Stdlib::Unixpath,
    Optional['SocketProtocol']          => Enum['udplite', 'sctp'],
    Optional['BindIPv6Only']            => Enum['default', 'both', 'ipv6-only'],
    Optional['Backlog']                 => Integer[0],
    Optional['BindToDevice']            => String[1],
    Optional['SocketUser']              => String[1],
    Optional['SocketGroup']             => String[1],
    Optional['SocketMode']              => Stdlib::Filemode,
    Optional['DirectoryMode']           => Stdlib::Filemode,
    Optional['Accept']                  => Boolean,
    Optional['Writable']                => Boolean,
    Optional['FlushPending']            => Boolean,
    Optional['MaxConnections']          => Integer[0],
    Optional['MaxConnectionsPerSource'] => Integer[0],
    Optional['KeepAlive']               => Boolean,
    Optional['KeepAliveTimeSec']        => Integer[0],
    Optional['KeepAliveIntervalSec']    => Integer[0],
    Optional['KeepAliveProbes']         => Integer[0],
    Optional['NoDelay']                 => Boolean,
    Optional['Priority']                => Integer,
    Optional['DeferAcceptSec']          => Integer[0],
    Optional['ReceiveBuffer']           => Variant[Integer[0],String[1]],
    Optional['SendBuffer']              => Variant[Integer[0],String[1]],
    Optional['IPTOS']                   => Variant[Integer,Enum['low-delay', 'throughput', 'reliability', 'low-cost']],
    Optional['IPTTL']                   => Integer[0],
    Optional['Mark']                    => String[1],
    Optional['ReusePort']               => Boolean,
    Optional['SmackLabel']              => String[1],
    Optional['SmackLabelIPIn']          => String[1],
    Optional['SmackLabelIPOut']         => String[1],
    Optional['SELinuxContextFromNet']   => Boolean,
    Optional['PipeSize']                => Variant[Integer[0],String[1]],
    Optional['FreeBind']                => Boolean,
    Optional['Transparent']             => Boolean,
    Optional['Broadcast']               => Boolean,
    Optional['PassCredentials']         => Boolean,
    Optional['PassSecurity']            => Boolean,
    Optional['PassPacketInfo']          => Boolean,
    Optional['Timestamping']            => Enum['off', 'us', 'usec', 'ns'],
    Optional['TCPCongestion']           => Enum['westwood', 'veno', 'cubic', 'lp'],
    Optional['ExecStartPre']            => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStartPost']           => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStopPre']             => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['ExecStopPost']            => Variant[Systemd::Unit::Service::Exec,Array[Systemd::Unit::Service::Exec,1]],
    Optional['TimeoutSec']              => String[1],
    Optional['Service']                 => Systemd::Unit,
    Optional['RemoveOnStop']            => Boolean,
    Optional['Symlinks']                => Variant[Stdlib::Unixpath,Array[Stdlib::Unixpath,1]],
    Optional['FileDescriptorName']      => String[1,255],
    Optional['TriggerLimitIntervalSec'] => String[1],
    Optional['TriggerLimitBurst']       => Integer[0],
  }
]
