# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`dhcp`](#dhcp): Manage an ISC DHCP server
* [`dhcp::disable`](#dhcp--disable): Remove and Disable the DHCP server
* [`dhcp::failover`](#dhcp--failover): Define a failover peer

#### Private Classes

* `dhcp::params`: Default parameters

### Defined types

* [`dhcp::dhcp_class`](#dhcp--dhcp_class): Define a DHCP class
* [`dhcp::host`](#dhcp--host): Define a DHCP host reservation
* [`dhcp::pool`](#dhcp--pool): Define a DHCP pool
* [`dhcp::subnet`](#dhcp--subnet): Define a DHCP subnet

### Data types

* [`Dhcp::DhcpPool`](#Dhcp--DhcpPool): Define a DHCP pool inside a DHCP configuration block
* [`Dhcp::Macaddress`](#Dhcp--Macaddress)
* [`Dhcp::Range`](#Dhcp--Range)
* [`Dhcp::StaticRoute`](#Dhcp--StaticRoute)

## Classes

### <a name="dhcp"></a>`dhcp`

Manage an ISC DHCP server

#### Parameters

The following parameters are available in the `dhcp` class:

* [`option_static_route`](#-dhcp--option_static_route)
* [`dnsdomain`](#-dhcp--dnsdomain)
* [`nameservers`](#-dhcp--nameservers)
* [`failover`](#-dhcp--failover)
* [`bootp`](#-dhcp--bootp)
* [`ntpservers`](#-dhcp--ntpservers)
* [`interfaces`](#-dhcp--interfaces)
* [`interface`](#-dhcp--interface)
* [`default_lease_time`](#-dhcp--default_lease_time)
* [`max_lease_time`](#-dhcp--max_lease_time)
* [`dnskeyname`](#-dhcp--dnskeyname)
* [`dnsupdatekey`](#-dhcp--dnsupdatekey)
* [`dnsupdateserver`](#-dhcp--dnsupdateserver)
* [`omapi`](#-dhcp--omapi)
* [`omapi_name`](#-dhcp--omapi_name)
* [`omapi_algorithm`](#-dhcp--omapi_algorithm)
* [`omapi_key`](#-dhcp--omapi_key)
* [`pxeserver`](#-dhcp--pxeserver)
* [`pxefilename`](#-dhcp--pxefilename)
* [`ipxe_filename`](#-dhcp--ipxe_filename)
* [`mtu`](#-dhcp--mtu)
* [`bootfiles`](#-dhcp--bootfiles)
* [`logfacility`](#-dhcp--logfacility)
* [`dhcp_monitor`](#-dhcp--dhcp_monitor)
* [`dhcp_dir`](#-dhcp--dhcp_dir)
* [`manage_dhcp_dir`](#-dhcp--manage_dhcp_dir)
* [`conf_dir_mode`](#-dhcp--conf_dir_mode)
* [`packagename`](#-dhcp--packagename)
* [`servicename`](#-dhcp--servicename)
* [`options`](#-dhcp--options)
* [`authoritative`](#-dhcp--authoritative)
* [`dhcp_root_user`](#-dhcp--dhcp_root_user)
* [`dhcp_root_group`](#-dhcp--dhcp_root_group)
* [`ddns_updates`](#-dhcp--ddns_updates)
* [`ddns_domainname`](#-dhcp--ddns_domainname)
* [`ddns_rev_domainname`](#-dhcp--ddns_rev_domainname)
* [`ddns_update_style`](#-dhcp--ddns_update_style)
* [`client_updates`](#-dhcp--client_updates)
* [`subnets`](#-dhcp--subnets)
* [`pools`](#-dhcp--pools)
* [`hosts`](#-dhcp--hosts)
* [`includes`](#-dhcp--includes)
* [`config_comment`](#-dhcp--config_comment)

##### <a name="-dhcp--option_static_route"></a>`option_static_route`

Data type: `Boolean`

When enabled it sets the options rfc3442-classless-static-routes and ms-classless-static-routes

Default value: `false`

##### <a name="-dhcp--dnsdomain"></a>`dnsdomain`

Data type: `Array[String]`



Default value: `$dhcp::params::dnsdomain`

##### <a name="-dhcp--nameservers"></a>`nameservers`

Data type: `Array[String]`



Default value: `[]`

##### <a name="-dhcp--failover"></a>`failover`

Data type: `Boolean`



Default value: `false`

##### <a name="-dhcp--bootp"></a>`bootp`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-dhcp--ntpservers"></a>`ntpservers`

Data type: `Array[String]`



Default value: `[]`

##### <a name="-dhcp--interfaces"></a>`interfaces`

Data type: `Optional[Array[String]]`



Default value: `undef`

##### <a name="-dhcp--interface"></a>`interface`

Data type: `String`



Default value: `'NOTSET'`

##### <a name="-dhcp--default_lease_time"></a>`default_lease_time`

Data type: `Integer[0]`



Default value: `43200`

##### <a name="-dhcp--max_lease_time"></a>`max_lease_time`

Data type: `Integer[0]`



Default value: `86400`

##### <a name="-dhcp--dnskeyname"></a>`dnskeyname`

Data type: `String`



Default value: `'rndc-key'`

##### <a name="-dhcp--dnsupdatekey"></a>`dnsupdatekey`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--dnsupdateserver"></a>`dnsupdateserver`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--omapi"></a>`omapi`

Data type: `Boolean`



Default value: `true`

##### <a name="-dhcp--omapi_name"></a>`omapi_name`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--omapi_algorithm"></a>`omapi_algorithm`

Data type: `String`



Default value: `'HMAC-MD5'`

##### <a name="-dhcp--omapi_key"></a>`omapi_key`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pxeserver"></a>`pxeserver`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pxefilename"></a>`pxefilename`

Data type: `String`



Default value: `$dhcp::params::pxefilename`

##### <a name="-dhcp--ipxe_filename"></a>`ipxe_filename`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--mtu"></a>`mtu`

Data type: `Optional[Integer[0]]`



Default value: `undef`

##### <a name="-dhcp--bootfiles"></a>`bootfiles`

Data type: `Hash[String, String]`



Default value: `$dhcp::params::bootfiles`

##### <a name="-dhcp--logfacility"></a>`logfacility`

Data type: `String`



Default value: `'local7'`

##### <a name="-dhcp--dhcp_monitor"></a>`dhcp_monitor`

Data type: `Boolean`



Default value: `true`

##### <a name="-dhcp--dhcp_dir"></a>`dhcp_dir`

Data type: `Stdlib::Absolutepath`



Default value: `$dhcp::params::dhcp_dir`

##### <a name="-dhcp--manage_dhcp_dir"></a>`manage_dhcp_dir`

Data type: `Boolean`



Default value: `$dhcp::params::manage_dhcp_dir`

##### <a name="-dhcp--conf_dir_mode"></a>`conf_dir_mode`

Data type: `Optional[Stdlib::Filemode]`



Default value: `$dhcp::params::conf_dir_mode`

##### <a name="-dhcp--packagename"></a>`packagename`

Data type: `String`



Default value: `$dhcp::params::packagename`

##### <a name="-dhcp--servicename"></a>`servicename`

Data type: `String`



Default value: `$dhcp::params::servicename`

##### <a name="-dhcp--options"></a>`options`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--authoritative"></a>`authoritative`

Data type: `Boolean`



Default value: `false`

##### <a name="-dhcp--dhcp_root_user"></a>`dhcp_root_user`

Data type: `String`



Default value: `'root'`

##### <a name="-dhcp--dhcp_root_group"></a>`dhcp_root_group`

Data type: `String`



Default value: `$dhcp::params::root_group`

##### <a name="-dhcp--ddns_updates"></a>`ddns_updates`

Data type: `Boolean`



Default value: `false`

##### <a name="-dhcp--ddns_domainname"></a>`ddns_domainname`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--ddns_rev_domainname"></a>`ddns_rev_domainname`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--ddns_update_style"></a>`ddns_update_style`

Data type: `Enum['none', 'interim', 'standard']`



Default value: `'interim'`

##### <a name="-dhcp--client_updates"></a>`client_updates`

Data type: `Optional[Boolean]`



Default value: `undef`

##### <a name="-dhcp--subnets"></a>`subnets`

Data type: `Hash[String, Hash]`



Default value: `{}`

##### <a name="-dhcp--pools"></a>`pools`

Data type: `Hash[String, Hash]`



Default value: `{}`

##### <a name="-dhcp--hosts"></a>`hosts`

Data type: `Hash[String, Hash]`



Default value: `{}`

##### <a name="-dhcp--includes"></a>`includes`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--config_comment"></a>`config_comment`

Data type: `String`



Default value: `'dhcpd.conf'`

### <a name="dhcp--disable"></a>`dhcp::disable`

Remove and Disable the DHCP server

### <a name="dhcp--failover"></a>`dhcp::failover`

Define a failover peer

#### Parameters

The following parameters are available in the `dhcp::failover` class:

* [`peer_address`](#-dhcp--failover--peer_address)
* [`role`](#-dhcp--failover--role)
* [`address`](#-dhcp--failover--address)
* [`port`](#-dhcp--failover--port)
* [`max_response_delay`](#-dhcp--failover--max_response_delay)
* [`max_unacked_updated`](#-dhcp--failover--max_unacked_updated)
* [`mclt`](#-dhcp--failover--mclt)
* [`load_split`](#-dhcp--failover--load_split)
* [`load_balance`](#-dhcp--failover--load_balance)
* [`omapi_key`](#-dhcp--failover--omapi_key)
* [`max_unacked_updates`](#-dhcp--failover--max_unacked_updates)

##### <a name="-dhcp--failover--peer_address"></a>`peer_address`

Data type: `String`

The address of the failover peer.

##### <a name="-dhcp--failover--role"></a>`role`

Data type: `Enum['primary', 'secondary']`

Primary or Secondary role in DHCP failover relationship.

Default value: `'primary'`

##### <a name="-dhcp--failover--address"></a>`address`

Data type: `String`

IP Address of the DHCP failover server.

Default value: `$facts['networking']['ip']`

##### <a name="-dhcp--failover--port"></a>`port`

Data type: `Variant[Integer[0, 65535], String]`

Port to listen for failover messages.

Default value: `519`

##### <a name="-dhcp--failover--max_response_delay"></a>`max_response_delay`

Data type: `Variant[Integer[0], String]`

max-response-delay in seconds before failover peer is considered failed.

Default value: `30`

##### <a name="-dhcp--failover--max_unacked_updated"></a>`max_unacked_updated`

max-unacked-updates before the server will wait to send additional packets to peer.

##### <a name="-dhcp--failover--mclt"></a>`mclt`

Data type: `Variant[Integer[0], String]`

MCLT, the maximum time a lease may be extended beyond expiration set by DHCP peer.

Default value: `300`

##### <a name="-dhcp--failover--load_split"></a>`load_split`

Data type: `Variant[Integer[0], String]`

Load split between the DHCP servers as fraction out of 256.

Default value: `128`

##### <a name="-dhcp--failover--load_balance"></a>`load_balance`

Data type: `Variant[Integer[0], String]`

Load balance max seconds, cutoff after which load balancing is disabled.

Default value: `3`

##### <a name="-dhcp--failover--omapi_key"></a>`omapi_key`

Data type: `Optional[String]`

OMAPI key to cryptographically sign traffic if OMAPI protocol is enabled.

Default value: `undef`

##### <a name="-dhcp--failover--max_unacked_updates"></a>`max_unacked_updates`

Data type: `Variant[Integer[0], String]`



Default value: `10`

## Defined types

### <a name="dhcp--dhcp_class"></a>`dhcp::dhcp_class`

Define a DHCP class

#### Parameters

The following parameters are available in the `dhcp::dhcp_class` defined type:

* [`parameters`](#-dhcp--dhcp_class--parameters)

##### <a name="-dhcp--dhcp_class--parameters"></a>`parameters`

Data type: `Variant[Array[String], String]`

The parameters for the class definition. When specified as a string, it
will be used verbatim with a semi colon at the end. When specified as an
array, every string is used and appended with a semi colon.

### <a name="dhcp--host"></a>`dhcp::host`

Define a DHCP host reservation

#### Parameters

The following parameters are available in the `dhcp::host` defined type:

* [`ip`](#-dhcp--host--ip)
* [`mac`](#-dhcp--host--mac)
* [`comment`](#-dhcp--host--comment)
* [`raw_append`](#-dhcp--host--raw_append)
* [`raw_prepend`](#-dhcp--host--raw_prepend)

##### <a name="-dhcp--host--ip"></a>`ip`

Data type: `String`

The IP address in the reservation

##### <a name="-dhcp--host--mac"></a>`mac`

Data type: `Dhcp::Macaddress`

The host's MAC address

##### <a name="-dhcp--host--comment"></a>`comment`

Data type: `Optional[String]`

An optional comment for the host

Default value: `undef`

##### <a name="-dhcp--host--raw_append"></a>`raw_append`

Data type: `Optional[String]`

Host configuration to append as-is

Default value: `undef`

##### <a name="-dhcp--host--raw_prepend"></a>`raw_prepend`

Data type: `Optional[String]`

Host configuration to prepend as-is

Default value: `undef`

### <a name="dhcp--pool"></a>`dhcp::pool`

Define a DHCP pool

#### Parameters

The following parameters are available in the `dhcp::pool` defined type:

* [`network`](#-dhcp--pool--network)
* [`mask`](#-dhcp--pool--mask)
* [`gateway`](#-dhcp--pool--gateway)
* [`pool_parameters`](#-dhcp--pool--pool_parameters)
* [`range`](#-dhcp--pool--range)
* [`failover`](#-dhcp--pool--failover)
* [`options`](#-dhcp--pool--options)
* [`parameters`](#-dhcp--pool--parameters)
* [`mtu`](#-dhcp--pool--mtu)
* [`nameservers`](#-dhcp--pool--nameservers)
* [`pxeserver`](#-dhcp--pool--pxeserver)
* [`pxefilename`](#-dhcp--pool--pxefilename)
* [`domain_name`](#-dhcp--pool--domain_name)
* [`static_routes`](#-dhcp--pool--static_routes)
* [`search_domains`](#-dhcp--pool--search_domains)
* [`raw_append`](#-dhcp--pool--raw_append)
* [`raw_prepend`](#-dhcp--pool--raw_prepend)

##### <a name="-dhcp--pool--network"></a>`network`

Data type: `String`



##### <a name="-dhcp--pool--mask"></a>`mask`

Data type: `String`



##### <a name="-dhcp--pool--gateway"></a>`gateway`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--pool_parameters"></a>`pool_parameters`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--pool--range"></a>`range`

Data type: `Variant[Array[Dhcp::Range], Optional[Dhcp::Range], Enum[''], Boolean]`



Default value: `undef`

##### <a name="-dhcp--pool--failover"></a>`failover`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--options"></a>`options`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--pool--parameters"></a>`parameters`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--pool--mtu"></a>`mtu`

Data type: `Optional[Integer[0]]`



Default value: `undef`

##### <a name="-dhcp--pool--nameservers"></a>`nameservers`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--pool--pxeserver"></a>`pxeserver`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--pxefilename"></a>`pxefilename`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--domain_name"></a>`domain_name`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--static_routes"></a>`static_routes`

Data type: `Optional[Array[Dhcp::StaticRoute]]`



Default value: `undef`

##### <a name="-dhcp--pool--search_domains"></a>`search_domains`

Data type: `Variant[Array[String], Optional[String]]`



Default value: `undef`

##### <a name="-dhcp--pool--raw_append"></a>`raw_append`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-dhcp--pool--raw_prepend"></a>`raw_prepend`

Data type: `Optional[String]`



Default value: `undef`

### <a name="dhcp--subnet"></a>`dhcp::subnet`

Define a DHCP subnet

#### Parameters

The following parameters are available in the `dhcp::subnet` defined type:

* [`network`](#-dhcp--subnet--network)
* [`mask`](#-dhcp--subnet--mask)
* [`pools`](#-dhcp--subnet--pools)
* [`gateway`](#-dhcp--subnet--gateway)
* [`options`](#-dhcp--subnet--options)
* [`parameters`](#-dhcp--subnet--parameters)
* [`mtu`](#-dhcp--subnet--mtu)
* [`nameservers`](#-dhcp--subnet--nameservers)
* [`pxeserver`](#-dhcp--subnet--pxeserver)
* [`pxefilename`](#-dhcp--subnet--pxefilename)
* [`domain_name`](#-dhcp--subnet--domain_name)
* [`static_routes`](#-dhcp--subnet--static_routes)
* [`search_domains`](#-dhcp--subnet--search_domains)
* [`raw_append`](#-dhcp--subnet--raw_append)
* [`raw_prepend`](#-dhcp--subnet--raw_prepend)

##### <a name="-dhcp--subnet--network"></a>`network`

Data type: `Stdlib::IP::Address::Nosubnet`

The network range (without the mask) from where IP's will be served

##### <a name="-dhcp--subnet--mask"></a>`mask`

Data type: `Stdlib::IP::Address::Nosubnet`

The subnet mask for our network

##### <a name="-dhcp--subnet--pools"></a>`pools`

Data type: `Array[Dhcp::DhcpPool]`

Specify a pool of addresses that will be treated differently than another pool of addresses,
even on the same network segment or subnet.

##### <a name="-dhcp--subnet--gateway"></a>`gateway`

Data type: `Optional[String]`

This option specifies a list of comma-separated IP addresses for routers on the client's subnet.
Routers should be listed in order of preference.

Default value: `undef`

##### <a name="-dhcp--subnet--options"></a>`options`

Data type: `Variant[Array[String], Optional[String]]`

Custom DHCP option statements
DHCP option statements always start with the option keyword, followed by an option name, followed by option
data. The option names and data formats are described below. It is not necessary to exhaustively specify all
DHCP options - only those options which are needed by clients

Default value: `undef`

##### <a name="-dhcp--subnet--parameters"></a>`parameters`

Data type: `Variant[Array[String], Optional[String]]`

Custom DHCP parameters
Each element is added as a separate line

Default value: `undef`

##### <a name="-dhcp--subnet--mtu"></a>`mtu`

Data type: `Optional[Integer[0]]`

This option specifies the MTU to use on this interface. The minimum legal value for the MTU is 68.

Default value: `undef`

##### <a name="-dhcp--subnet--nameservers"></a>`nameservers`

Data type: `Variant[Array[String], Optional[String]]`

Specifies a list of Domain Name System (STD 13, RFC 1035) name servers available to the client.
Servers should be listed in order of preference.

Default value: `undef`

##### <a name="-dhcp--subnet--pxeserver"></a>`pxeserver`

Data type: `Optional[String]`

This is used to specify the host address of the server from which the initial boot file
(specified in the filename statement) is to be loaded. Server-name should be a numeric IP address or a
domain name. If no next-server statement applies to a given client, the address 0.0.0.0 is used.

Default value: `undef`

##### <a name="-dhcp--subnet--pxefilename"></a>`pxefilename`

Data type: `Optional[String]`

This can be used to specify the name of the initial boot file which is to be loaded by a
client. The filename should be a filename recognizable to whatever file transfer protocol the client can be
expected to use to load the file.

Default value: `undef`

##### <a name="-dhcp--subnet--domain_name"></a>`domain_name`

Data type: `Optional[String]`

This option specifies the domain name that client should use when resolving hostnames via the Domain Name
System.

Default value: `undef`

##### <a name="-dhcp--subnet--static_routes"></a>`static_routes`

Data type: `Optional[Array[Dhcp::StaticRoute]]`

This option specifies a list of static routes that the client should install in its routing cache. If multiple
routes to the same destination are specified, they are listed in descending order of priority.

Default value: `undef`

##### <a name="-dhcp--subnet--search_domains"></a>`search_domains`

Data type: `Variant[Array[String], Optional[String]]`

Specifies a ´search list´ of Domain Names to be used by the client to locate not-fully-qualified domain
names. The difference between this option and historic use of the domain-name option
for the same ends is that this option is encoded in RFC1035 compressed labels on the wire. For example:

Default value: `undef`

##### <a name="-dhcp--subnet--raw_append"></a>`raw_append`

Data type: `Optional[String]`

Partial that is appended to the dhcpd.conf (before the final `}`)

Default value: `undef`

##### <a name="-dhcp--subnet--raw_prepend"></a>`raw_prepend`

Data type: `Optional[String]`

Partial that is prepended to the dhcpd.conf (after the first `{`)

Default value: `undef`

## Data types

### <a name="Dhcp--DhcpPool"></a>`Dhcp::DhcpPool`

Define a DHCP pool inside a DHCP configuration block

* **See also**
  * https://linux.die.net/man/5/dhcpd.conf
  * More information about DHCP pools section "Address Pools"
  * https://stevendiver.com/2020/02/21/isc-dhcp-failover-configuration/
  * More information about failover

Alias of

```puppet
Struct[{
    'range'                => Optional[Variant[Array[Dhcp::Range], Dhcp::Range, Enum[''], Boolean]],
    Optional['failover']   => Optional[String],
    Optional['parameters'] => Optional[Variant[Array[String], String]],
  }]
```

#### Parameters

The following parameters are available in the `Dhcp::DhcpPool` data type:

* [`range`](#-Dhcp--DhcpPool--range)
* [`failover`](#-Dhcp--DhcpPool--failover)
* [`parameters`](#-Dhcp--DhcpPool--parameters)

##### <a name="-Dhcp--DhcpPool--range"></a>`range`

The range or ranges to assign IP's from

##### <a name="-Dhcp--DhcpPool--failover"></a>`failover`

Which peer to failover to

##### <a name="-Dhcp--DhcpPool--parameters"></a>`parameters`

Custom parameters, added verbatim to the pool block

### <a name="Dhcp--Macaddress"></a>`Dhcp::Macaddress`

The Dhcp::Macaddress data type.

Alias of `Pattern[/^[0-9A-Fa-f]{1,2}(:[0-9A-Fa-f]{1,2}){5}$/]`

### <a name="Dhcp--Range"></a>`Dhcp::Range`

The Dhcp::Range data type.

Alias of `Pattern[/^(dynamic-bootp )?((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d)))(\/((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))|[0-9]+))?( ((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d)))(\/((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))|[0-9]+))?)?$/]`

### <a name="Dhcp--StaticRoute"></a>`Dhcp::StaticRoute`

The Dhcp::StaticRoute data type.

Alias of

```puppet
Struct[{
    'mask'              => String,
    'gateway'           => String,
    Optional['network'] => String,
  }]
```

