# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`hashfile`](#hashfile): Create various file formats from a source hash

### Defined types

* [`hashfile::ini`](#hashfileini): Defined type provides an implementation of the hash2ini function, creating an INI file from the input hash
* [`hashfile::json`](#hashfilejson): Defined type provides an implementation of the hash2json function, creating a JSON file from the input hash
* [`hashfile::kv`](#hashfilekv): Defined type provides an implementation of the hash2kv function, creating a key-value/shellvar file from the input hash
* [`hashfile::properties`](#hashfileproperties): Defined type provides an implementation of the hash2properties function, creating a Java properties file from the input hash
* [`hashfile::yaml`](#hashfileyaml): Defined type provides an implementation of the hash2yaml function, creating a YAML file from the input hash

### Functions

* [`hash2ini`](#hash2ini): Converts a puppet hash to INI file string.
* [`hash2kv`](#hash2kv): Converts a puppet hash to key/value (SHELLVAR) file string.
* [`hash2properties`](#hash2properties): Converts a puppet hash to Java properties file string.
* [`hash2yaml`](#hash2yaml): Converts a puppet hash to YAML string.

## Classes

### `hashfile`

Create various file formats from a source hash

#### Examples

##### Hiera representation of an INI file from a hash

```puppet
hashfile::ini:
  /tmp/file.ini:
    file:
      ensure: file
      owner: root
      group: root
      mode: '0600'
    data:
      section1:
        key1: value1
        key2: value2
```

#### Parameters

The following parameters are available in the `hashfile` class.

##### `ini`

Data type: `Hash`

A data hash to be converted to ini files

Default value: `{}`

##### `json`

Data type: `Hash`

A data hash to be converted to json files

Default value: `{}`

##### `kv`

Data type: `Hash`

A data hash to be converted to key/value (shellvar) files

Default value: `{}`

##### `properties`

Data type: `Hash`

A data hash to be converted to Java properties files

Default value: `{}`

##### `yaml`

Data type: `Hash`

A data hash to be converted to yaml files

Default value: `{}`

## Defined types

### `hashfile::ini`

Defined type provides an implementation of the hash2ini function, creating an INI file from the input hash

#### Examples

##### 

```puppet
hashfile::ini { '/some/file.ini':
  file => {
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }
  data => {
    section1 => {
      key1   => 'value1',
    }
  }
}
```

#### Parameters

The following parameters are available in the `hashfile::ini` defined type.

##### `file`

Data type: `Hash`

Properties of the target file resource.  Accepts and requires the same parameters of a puppet "file"

##### `data`

Data type: `Hash`

Hash representation of the INI file, to include section names and key/value pairs

##### `options`

Data type: `Hash`

Optional hash of values to format output. See the "hash2ini" function for details.

Default value: `{}`

### `hashfile::json`

Defined type provides an implementation of the hash2json function, creating a JSON file from the input hash

#### Examples

##### 

```puppet
hashfile::json { 'namevar':
  file => {
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }
  data => {
    section1 => {
      key1   => 'value1',
    }
  }
}
```

#### Parameters

The following parameters are available in the `hashfile::json` defined type.

##### `file`

Data type: `Hash`

Properties of the target file resource.  Accepts and requires the same parameters of a puppet "file"

##### `data`

Data type: `Hash`

Hash representation of the JSON file.

### `hashfile::kv`

Defined type provides an implementation of the hash2kv function, creating a key-value/shellvar file from the input hash

#### Examples

##### 

```puppet
hashfile::kv { 'namevar':
  file => {
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }
  data => {
    section1 => {
      key1   => 'value1',
    }
  }
}
```

#### Parameters

The following parameters are available in the `hashfile::kv` defined type.

##### `file`

Data type: `Hash`

Properties of the target file resource.  Accepts and requires the same parameters of a puppet "file"

##### `data`

Data type: `Hash`

Hash representation of the key-value/shellvar file.

##### `options`

Data type: `Hash`

Hash of optional values to format output file. See "hash2kv" function for details.

Default value: `{}`

### `hashfile::properties`

Defined type provides an implementation of the hash2properties function, creating a Java properties file from the input hash

#### Examples

##### 

```puppet
hashfile::properties { 'namevar':
  file => {
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }
  data => {
    section1 => {
      key1   => 'value1',
    }
  }
}
```

#### Parameters

The following parameters are available in the `hashfile::properties` defined type.

##### `file`

Data type: `Hash`

Properties of the target file resource.  Accepts and requires the same parameters of a puppet "file"

##### `data`

Data type: `Hash`

Hash representation of the properties file.

##### `options`

Data type: `Hash`

Hash of optional values to format output file. See the "hash2properties" function for details.

Default value: `{}`

### `hashfile::yaml`

Defined type provides an implementation of the hash2yaml function, creating a YAML file from the input hash

#### Examples

##### 

```puppet
hashfile::yaml { 'namevar':
  file => {
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }
  data  => {
    section1 => {
      key1   => 'value1',
    }
  }
}
```

#### Parameters

The following parameters are available in the `hashfile::yaml` defined type.

##### `file`

Data type: `Hash`

Properties of the target file resource.  Accepts and requires the same parameters of a puppet "file"

##### `data`

Data type: `Hash`

Hash representation of the YAML file.

##### `options`

Data type: `Hash`

Hash of optional values to format output file. See "hash2yaml" function for details.

Default value: `{}`

## Functions

### `hash2ini`

Type: Ruby 4.x API

Converts a puppet hash to INI file string.

#### Examples

##### Call the function with the $input and $options hashes

```puppet
hash2ini($input, $options)
```

#### `hash2ini(Hash $input, Optional[Hash] $options)`

The hash2ini function.

Returns: `String` An INI file formatted string

##### Examples

###### Call the function with the $input and $options hashes

```puppet
hash2ini($input, $options)
```

##### `input`

Data type: `Hash`

The hash to be converted to INI file

##### `options`

Data type: `Optional[Hash]`

A hash of options to control INI file format

### `hash2kv`

Type: Ruby 4.x API

Converts a puppet hash to key/value (SHELLVAR) file string.

#### Examples

##### Call the function with the $input and $options hashes

```puppet
hash2ini($input, $options)
```

#### `hash2kv(Hash $input, Optional[Hash] $options)`

The hash2kv function.

Returns: `String` A K/V file formatted string

##### Examples

###### Call the function with the $input and $options hashes

```puppet
hash2ini($input, $options)
```

##### `input`

Data type: `Hash`

The hash to be converted to K/V file

##### `options`

Data type: `Optional[Hash]`

A hash of options to control K/V file format

### `hash2properties`

Type: Ruby 4.x API

Converts a puppet hash to Java properties file string.

#### Examples

##### Call the function with the $input hash

```puppet
hash2properties($input)
```

#### `hash2properties(Hash $input, Optional[Hash] $options)`

The hash2properties function.

Returns: `String` A properties formatted string

##### Examples

###### Call the function with the $input hash

```puppet
hash2properties($input)
```

##### `input`

Data type: `Hash`

The hash to be converted to properties

##### `options`

Data type: `Optional[Hash]`

A hash of options to control properties file format

### `hash2yaml`

Type: Ruby 4.x API

Converts a puppet hash to YAML string.

#### Examples

##### Call the function with the $input hash

```puppet
hash2yaml($input)
```

#### `hash2yaml(Hash $input, Optional[Hash] $options)`

The hash2yaml function.

Returns: `String` A YAML formatted string

##### Examples

###### Call the function with the $input hash

```puppet
hash2yaml($input)
```

##### `input`

Data type: `Hash`

The hash to be converted to YAML

##### `options`

Data type: `Optional[Hash]`

A hash of options to control YAML file format

