module.exports = {
  plugins: ['spellcheck', '@theforeman/rules'],
  rules: {
    'spellcheck/spell-checker': [
      'warn',
      {
        comments: false,
        identifiers: false,
        strings: true,
        lang: 'en_US',
        ignoreRequire: false,
        skipWords: [
          '2xl',
          '45vh',
          '4xl',
          'ampm',
          'Ansible',
          'ascii',
          'auditable',
          'Autocompletion',
          'autogenerated',
          'axios',
          'bool',
          'bootable',
          'Borderless',
          'btns',
          'candlepin',
          'centos',
          'checkbox',
          'clearbutton',
          'clearfix',
          'comms',
          'Composable',
          'consts',
          'cpu',
          'csrf',
          'csv',
          'datacenter',
          'datastore',
          'datastores',
          'datatables',
          'datepicker',
          'datetime',
          'datetimepicker',
          'debian',
          'decrement', // should be removed once https://github.com/aotaduy/eslint-plugin-spellcheck/issues/67 is resolved.
          'devs',
          'dgettext',
          'dngettext',
          'donut',
          'dow',
          'dropdown',
          'dropdowns',
          'dsmorse',
          'ec2',
          'erb',
          'fieldset',
          'fnc',
          'formatter',
          'fqdn',
          'func',
          'gettext',
          'glyphicon',
          'gpg',
          'graphql',
          'gridster',
          'hostdetails',
          'hostgroup',
          'hostgroups',
          'href',
          'hypervisor',
          'i386',
          'internets',
          'ip6',
          'IPv4',
          'IPv6',
          'javascript',
          'javascripts',
          'jed',
          'jsx',
          'katello',
          'keybind',
          'keydown',
          'keypress',
          'klasses',
          'labelledby',
          'lang',
          'ldap',
          'loc',
          'locs',
          'lsi',
          'matcher',
          'menuitem',
          'monokai',
          'mousedown',
          'mouseup',
          'msg',
          'nailgun',
          'nat',
          'navitem',
          'netgroups',
          'networksurl',
          'ngettext',
          'nic',
          'nfs',
          'nonpersistent',
          'noopener',
          'noreferrer',
          'nowrap',
          'npx',
          'num',
          'numpad',
          'operatingsystem',
          'operatingsystems',
          'orderable',
          'orgs',
          'ouia',
          'ouiaid',
          'ownfield',
          'paravirtual',
          'patternfly',
          'pficon',
          'poolsurl',
          'popstate',
          'posinset',
          'posix',
          'pqr',
          'ptable',
          'puppetclass',
          'puppetclasses',
          'pxe_loader',
          'Pv',
          'qcow2',
          'rbt',
          'readonly',
          'redhat',
          'redux',
          'refetches',
          'rendering',
          'repo',
          'resize',
          'rex',
          'rfc4519',
          'rhel',
          'safemode',
          'sbs',
          'scrollable',
          'scsi',
          'securityfailure',
          'setsize',
          'sizex',
          'sizey',
          'Solaris',
          'sparc',
          'storages',
          'stringified',
          'subcomponent',
          'subcomponents',
          'subnav',
          'subnet',
          'subnets',
          'substate',
          'svg',
          'symlink',
          'Symlink',
          'testoption',
          'testoption',
          'textarea',
          'textfield',
          'tfm',
          'theforeman',
          'timepicker',
          'timerdelay',
          'timeseries',
          'tlv',
          'tooltip',
          'turbolinks',
          'twipsy',
          'txt',
          'typeahead',
          'ubuntu',
          'ujs',
          'uncheck',
          'unencrypted',
          'unmount',
          'unordered',
          'unprocessable',
          'unselect',
          'unselecting',
          'unstyled',
          'utf8',
          'virtualization',
          'vms',
          'vmware',
          'vnc',
          'vnic',
          'webpack',
          'wget',
          'wss',
          'x86_64',
          'xml',
          'xpi',
          'xyz',
          'yaml',
        ],
        minLength: 3,
      },
    ],
    'import/no-unresolved': [
      'error',
      {
        ignore: ['foremanReact/.*'],
      },
    ],
    'import/extensions': [
      'error',
      {
        ignore: ['foremanReact/.*'],
      },
    ],
    '@theforeman/rules/require-ouiaid': 'error',
  },
};
