module FogExtensions
end

require 'fog_extensions/model'
Fog::Model.include FogExtensions::Model if defined? Fog::Model

# Fog is required by bundler, and depending on the group configuration,
# different providers will be available.
if Foreman::Model::EC2.available?
  require 'fog/aws'
  require 'fog/aws/models/compute/flavor'
  Fog::AWS::Compute::Flavor.include FogExtensions::AWS::Flavor
  require 'fog/aws/models/compute/tag'
  Fog::AWS::Compute::Tag.include FogExtensions::AWS::Tag
  require 'fog/aws/models/compute/server'
  Fog::AWS::Compute::Server.include FogExtensions::AWS::Server
end

if Foreman::Model::Libvirt.available?
  require 'fog/libvirt'
  require 'fog/libvirt/compute'
  require 'fog/libvirt/models/compute/server'
  Fog::Libvirt::Compute::Server.include FogExtensions::Libvirt::Server
end

if Foreman::Model::Openstack.available?
  require 'fog/openstack'
  require 'fog/openstack/compute/models/server'
  require 'fog/openstack/compute/models/flavor'
  Fog::OpenStack::Compute::Real.include FogExtensions::Openstack::Core
  Fog::OpenStack::Compute::Server.prepend FogExtensions::Openstack::Server
  Fog::OpenStack::Compute::Flavor.include FogExtensions::Openstack::Flavor
end

if Foreman::Model::Vmware.available?
  require 'fog/vsphere'
  require 'fog/vsphere/models/compute/cluster'
  require 'fog/vsphere/models/compute/network'
  require 'fog/vsphere/models/compute/datastore'
  require 'fog/vsphere/models/compute/storage_pod'
  require 'fog/vsphere/models/compute/resource_pool'
  require 'fog/vsphere/models/compute/server'
  Fog::Vsphere::Compute::Server.include FogExtensions::Vsphere::Server

  require 'fog/vsphere/models/compute/folder'
  Fog::Vsphere::Compute::Folder.include FogExtensions::Vsphere::Folder
end
